/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservice.assetcatalog.server.spring;

import org.odpi.openmetadata.accessservice.assetcatalog.model.SequenceOrderType;
import org.odpi.openmetadata.accessservice.assetcatalog.model.Status;
import org.odpi.openmetadata.accessservice.assetcatalog.responses.RelationshipResponse;
import org.odpi.openmetadata.accessservice.assetcatalog.responses.RelationshipsResponse;
import org.odpi.openmetadata.accessservice.assetcatalog.service.AssetCatalogRelationshipService;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open-metadata/access-services/asset-catalog/users/{userId}/relationships"})
public class AssetCatalogRelationshipResource {
    private AssetCatalogRelationshipService relationshipService = new AssetCatalogRelationshipService();

    @RequestMapping(method={RequestMethod.GET}, path={"/{relationshipId}"}, produces={"application/json"})
    public RelationshipResponse getRelationship(@PathVariable(value="userId") String userId, @PathVariable(value="relationshipId") String relationshipId) {
        return this.relationshipService.getRelationshipById(userId, relationshipId);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/property-name/{propertyName}"}, produces={"application/json"})
    public RelationshipsResponse getRelationshipByLabel(@PathVariable(value="userId") String userId, @PathVariable(value="propertyName") String propertyName, @RequestParam(required=false, value="propertyValue") String propertyValue, @RequestParam(required=false, value="relationshipTypeId") String relationshipTypeId, @RequestParam(required=false, value="limit", defaultValue="0") Integer limit, @RequestParam(required=false, value="offset", defaultValue="0") Integer offset, @RequestParam(required=false, value="orderType") SequenceOrderType orderType, @RequestParam(required=false, value="orderProperty") String orderProperty, @RequestParam(required=false, value="status") Status status) {
        return this.relationshipService.getRelationshipByProperty(userId, relationshipTypeId, propertyName, propertyValue, limit, offset, orderType, orderProperty, status);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/type/{relationshipTypeId}/search/{criteria}"}, produces={"application/json"})
    public RelationshipsResponse searchForRelationships(@PathVariable(value="userId") String userId, @PathVariable(value="relationshipTypeId") String relationshipTypeId, @PathVariable(value="criteria") String criteria, @RequestParam(required=false, value="limit", defaultValue="0") Integer limit, @RequestParam(required=false, value="offset", defaultValue="0") Integer offset, @RequestParam(required=false, value="orderType") SequenceOrderType orderType, @RequestParam(required=false, value="orderProperty") String orderProperty, @RequestParam(required=false, value="status") Status status) {
        return this.relationshipService.searchForRelationships(userId, relationshipTypeId, criteria, limit, offset, orderProperty, orderType, status);
    }
}

