/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetcatalog.server.spring;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetcatalog.exception.NotImplementedException;
import org.odpi.openmetadata.accessservices.assetcatalog.model.AssetDescription;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.body.SearchParameters;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.AssetDescriptionResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.AssetResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.ClassificationsResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.RelationshipsResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.service.AssetCatalogService;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/asset-catalog/users/{userId}"})
public class AssetCatalogEntityResource {
    private AssetCatalogService assetService = new AssetCatalogService();

    @RequestMapping(method={RequestMethod.GET}, path={"/asset-summary/{assetId}"}, produces={"application/json"})
    public AssetDescriptionResponse getAssetSummary(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="assetId") String assetId) {
        return this.assetService.getAssetSummaryById(serverName, userId, assetId);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/asset-details/{assetId}"}, produces={"application/json"})
    public AssetDescriptionResponse getAssetDetail(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="assetId") String assetId) {
        return this.assetService.getAssetDetailsById(serverName, userId, assetId);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/asset-universe/{assetId}"}, produces={"application/json"})
    public AssetDescriptionResponse getAssetUniverse(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="assetId") String assetId) {
        return this.assetService.getAssetUniverseByGUID(serverName, userId, assetId);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/asset-relationships/{assetId}"}, produces={"application/json"})
    public RelationshipsResponse getAssetRelationships(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="assetId") String assetId, @RequestBody SearchParameters searchParameters) {
        return this.assetService.getAssetRelationships(serverName, userId, assetId, searchParameters);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/asset-classifications/{assetId}"}, produces={"application/json"})
    public ClassificationsResponse getAssetByClassification(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="assetId") String assetId, @RequestBody SearchParameters searchParameters) {
        return this.assetService.getClassificationByAssetGUID(serverName, userId, assetId, searchParameters);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/assets-by-property/{propertyValue}"}, produces={"application/json"})
    public AssetDescriptionResponse getAssetsByProperty(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="propertyValue") String propertyValue, @RequestBody SearchParameters searchParameters) {
        return this.assetService.getAssetsByProperty(serverName, userId, propertyValue, searchParameters);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/assets-by-classification-name/{classificationName}"}, produces={"application/json"})
    public AssetDescriptionResponse getAssetsByClassificationName(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="classificationName") String classificationName, @RequestBody SearchParameters searchParameters) {
        return this.assetService.getAssetsByClassificationName(serverName, userId, classificationName, searchParameters);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/assets-linking-relationships/from/{assetId}/to/{endAssetId}"}, produces={"application/json"})
    public RelationshipsResponse getLinkingRelationships(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="assetId") String startAssetId, @PathVariable(value="endAssetId") String endAssetId) {
        return this.assetService.getLinkingRelationships(serverName, userId, startAssetId, endAssetId);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/linking-assets/from/{assetId}/to/{endAssetId}"}, produces={"application/json"})
    public AssetDescriptionResponse getLinkingAssets(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="assetId") String startAssetId, @PathVariable(value="endAssetId") String endAssetId) {
        return this.assetService.getLinkingAssets(serverName, userId, startAssetId, endAssetId);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/related-assets/{assetId}"}, produces={"application/json"})
    public AssetDescriptionResponse getRelatedAssets(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="assetId") String assetId, @RequestBody SearchParameters searchParameters) {
        return this.assetService.getRelatedAssets(serverName, userId, assetId, searchParameters);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/assets-from-neighborhood/{assetId}"}, produces={"application/json"})
    public AssetDescriptionResponse getAssetsFromNeighborhood(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="assetId") String assetId, @RequestBody SearchParameters searchParameters) {
        return this.assetService.getAssetsFromNeighborhood(serverName, userId, assetId, searchParameters);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/related-relationships/{assetId}"}, produces={"application/json"})
    public RelationshipsResponse getRelationshipsFromNeighborhood(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="assetId") String assetId, @RequestBody SearchParameters searchParameters) {
        return this.assetService.getRelationshipsFromNeighborhood(serverName, userId, assetId, searchParameters);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/last-created"}, produces={"application/json"})
    public List<AssetDescription> getLastCreatedAssets(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @RequestBody SearchParameters searchParameters) throws NotImplementedException {
        return this.assetService.getLastCreatedAssets(serverName, userId, searchParameters);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/last-updated"}, produces={"application/json"})
    public List<AssetDescription> getLastUpdatedAssets(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @RequestBody SearchParameters searchParameters) throws NotImplementedException {
        return this.assetService.getLastUpdatedAssets(serverName, userId, searchParameters);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/search-asset/{searchCriteria}"}, produces={"application/json"})
    public AssetDescriptionResponse searchAssets(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="searchCriteria") String searchCriteria, @RequestBody SearchParameters searchParameters) {
        return this.assetService.searchAssets(serverName, userId, searchCriteria, searchParameters);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/search/asset-property/{searchCriteria}"}, produces={"application/json"})
    public AssetDescriptionResponse searchAssetsByPropertyValue(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="searchCriteria") String searchCriteria, @RequestBody SearchParameters searchParameters) {
        return this.assetService.searchAssetsByPropertyValue(serverName, userId, searchCriteria, searchParameters);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/search-asset-v2/{searchCriteria}"}, produces={"application/json"})
    public AssetResponse searchAssetsV2(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="searchCriteria") String searchCriteria, @RequestBody SearchParameters searchParameters) {
        return this.assetService.searchAssetsGeneric(serverName, userId, searchCriteria, searchParameters);
    }
}

