/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetcatalog.server.spring;

import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.body.SearchParameters;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.RelationshipResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.RelationshipsResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.service.AssetCatalogRelationshipService;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/asset-catalog/users/{userId}/relationships"})
public class AssetCatalogRelationshipResource {
    private AssetCatalogRelationshipService relationshipService = new AssetCatalogRelationshipService();

    @RequestMapping(method={RequestMethod.GET}, path={"/{relationshipId}"}, produces={"application/json"})
    public RelationshipResponse getRelationship(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="relationshipId") String relationshipId) {
        return this.relationshipService.getRelationshipById(serverName, userId, relationshipId);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/property-name/{propertyName}"}, produces={"application/json"})
    public RelationshipsResponse getRelationshipByLabel(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="propertyName") String propertyName, @RequestBody SearchParameters searchParameters) {
        return this.relationshipService.getRelationshipByProperty(serverName, userId, propertyName, searchParameters);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/type/{relationshipTypeId}/search/{criteria}"}, produces={"application/json"})
    public RelationshipsResponse searchForRelationships(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="relationshipTypeId") String relationshipTypeId, @PathVariable(value="criteria") String criteria, @RequestBody SearchParameters searchParameters) {
        return this.relationshipService.searchForRelationships(serverName, userId, relationshipTypeId, criteria, searchParameters);
    }
}

