/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetcatalog.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.PositiveOrZero;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.body.SearchParameters;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.AssetCatalogSupportedTypes;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.AssetDescriptionListResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.AssetDescriptionResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.AssetListResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.AssetResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.ClassificationListResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.RelationshipListResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.service.AssetCatalogRESTService;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/asset-catalog/users/{userId}"})
@Tag(name="Asset Catalog OMAS", description="The Asset Catalog OMAS provides services to search for data assets including data stores, event feeds, APIs, data sets.", externalDocs=@ExternalDocumentation(description="Asset Catalog Open Metadata Access Service (OMAS)", url="https://egeria.odpi.org/open-metadata-implementation/access-services/asset-catalog/"))
public class AssetCatalogEntityResource {
    private AssetCatalogRESTService assetService = new AssetCatalogRESTService();

    @GetMapping(path={"/asset-details/{assetGUID}"}, produces={"application/json"})
    public AssetDescriptionResponse getAssetDetail(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="assetGUID") @NotBlank String assetGUID, @RequestParam(name="assetType", required=false) @NotNull String assetType) {
        return this.assetService.getAssetDetailsByGUID(serverName, userId, assetGUID, assetType);
    }

    @GetMapping(path={"/asset-universe/{assetGUID}"}, produces={"application/json"})
    public AssetDescriptionResponse getAssetUniverse(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="assetGUID") @NotBlank String assetGUID, @RequestParam(name="assetType", required=false) @NotNull String assetType) {
        return this.assetService.getAssetUniverseByGUID(serverName, userId, assetGUID, assetType);
    }

    @GetMapping(path={"/asset-relationships/{assetGUID}"}, produces={"application/json"})
    public RelationshipListResponse getAssetRelationships(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="assetGUID") @NotBlank String assetGUID, @RequestParam(name="assetType", required=false) String assetType, @RequestParam(name="relationshipType", required=false) String relationshipType, @RequestParam(name="from", required=false, defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="pageSize", required=false, defaultValue="100") @PositiveOrZero Integer pageSize) {
        return this.assetService.getAssetRelationships(serverName, userId, assetGUID, assetType, relationshipType, from, pageSize);
    }

    @GetMapping(path={"/asset-classifications/{assetGUID}"}, produces={"application/json"})
    public ClassificationListResponse getClassificationsForAsset(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="assetGUID") @NotBlank String assetGUID, @RequestParam(name="assetType", required=false) String assetType, @RequestParam(name="classificationName", required=false) String classificationName) {
        return this.assetService.getClassificationByAssetGUID(serverName, userId, assetGUID, assetType, classificationName);
    }

    @GetMapping(path={"/linking-assets/from/{assetGUID}/to/{endAssetGUID}"}, produces={"application/json"})
    public AssetDescriptionListResponse getLinkingAssets(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="assetGUID") @NotBlank String startAssetGUID, @PathVariable(value="endAssetGUID") @NotBlank String endAssetGUID) {
        return this.assetService.getLinkingAssets(serverName, userId, startAssetGUID, endAssetGUID);
    }

    @GetMapping(path={"/linking-assets-relationships/from/{assetGUID}/to/{endAssetGUID}"}, produces={"application/json"})
    public RelationshipListResponse getLinkingRelationships(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="assetGUID") String startAssetGUID, @PathVariable(value="endAssetGUID") String endAssetGUID) {
        return this.assetService.getLinkingRelationships(serverName, userId, startAssetGUID, endAssetGUID);
    }

    @PostMapping(path={"/assets-from-neighborhood/{assetGUID}"}, produces={"application/json"})
    public AssetDescriptionListResponse getAssetsFromNeighborhood(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="assetGUID") @NotBlank String assetGUID, @RequestBody SearchParameters searchParameters) {
        return this.assetService.getAssetsFromNeighborhood(serverName, userId, assetGUID, searchParameters);
    }

    @PostMapping(path={"/search"}, produces={"application/json"})
    public AssetListResponse searchByType(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @RequestParam(value="searchCriteria") @NotBlank String searchCriteria, @RequestBody SearchParameters searchParameters) {
        return this.assetService.searchByType(serverName, userId, searchCriteria, searchParameters);
    }

    @GetMapping(path={"/asset-context/{assetGUID}"}, produces={"application/json"})
    public AssetResponse getAssetContext(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="assetGUID") @NotBlank String assetGUID, @RequestParam(name="assetType", required=false) String assetType) {
        return this.assetService.buildContext(serverName, userId, assetGUID, assetType);
    }

    @GetMapping(path={"/supportedTypes"}, produces={"application/json"})
    public AssetCatalogSupportedTypes getSupportedTypes(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @RequestParam(name="type", required=false) @Nullable String type) {
        return this.assetService.getSupportedTypes(serverName, userId, type);
    }
}

