/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetcatalog.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.PositiveOrZero;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.body.SearchParameters;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.AssetCatalogResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.AssetCatalogSupportedTypes;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.AssetListResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.AssetResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.ClassificationListResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.model.rest.responses.RelationshipListResponse;
import org.odpi.openmetadata.accessservices.assetcatalog.service.AssetCatalogRESTService;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectionResponse;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/asset-catalog/users/{userId}"})
@Tag(name="Asset Catalog OMAS", description="The Asset Catalog OMAS provides services to search for data assets including data stores, event feeds, APIs, data sets.", externalDocs=@ExternalDocumentation(description="Asset Catalog Open Metadata Access Service (OMAS)", url="https://egeria-project.org/services/omas/asset-catalog/overview/"))
public class AssetCatalogEntityResource {
    private final AssetCatalogRESTService assetService = new AssetCatalogRESTService();

    @GetMapping(path={"/asset-details/{assetGUID}"}, produces={"application/json"})
    @Operation(summary="getAssetDetail", description="Returns the asset", externalDocs=@ExternalDocumentation(description="Asset", url="https://egeria-project.org/concepts/asset"))
    public AssetCatalogResponse getAssetDetail(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="assetGUID") @NotBlank String assetGUID, @RequestParam(name="assetType", required=false) @NotNull String assetType) {
        return this.assetService.getAssetDetailsByGUID(serverName, userId, assetGUID, assetType);
    }

    @GetMapping(path={"/asset-universe/{assetGUID}"}, produces={"application/json"})
    @Operation(summary="getAssetUniverse", description="Returns the asset universe, which means the asset details and the relationships it has", externalDocs=@ExternalDocumentation(description="Metadata Relationships", url="https://egeria-project.org/patterns/metadata-manager/categories-of-metadata/?h=relationships#metadata-relationships-and-classifications"))
    public AssetCatalogResponse getAssetUniverse(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="assetGUID") @NotBlank String assetGUID, @RequestParam(name="assetType", required=false) @NotNull String assetType) {
        return this.assetService.getAssetUniverseByGUID(serverName, userId, assetGUID, assetType);
    }

    @GetMapping(path={"/asset-relationships/{assetGUID}"}, produces={"application/json"})
    @Operation(summary="getAssetRelationships", description="Returns the asset relationships", externalDocs=@ExternalDocumentation(description="Metadata Relationships", url="https://egeria-project.org/patterns/metadata-manager/categories-of-metadata/?h=relationships#metadata-relationships-and-classifications"))
    public RelationshipListResponse getAssetRelationships(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="assetGUID") @NotBlank String assetGUID, @RequestParam(name="assetType", required=false) String assetType, @RequestParam(name="relationshipType", required=false) String relationshipType, @RequestParam(name="from", required=false, defaultValue="0") @PositiveOrZero Integer from, @RequestParam(name="pageSize", required=false, defaultValue="100") @PositiveOrZero Integer pageSize) {
        return this.assetService.getAssetRelationships(serverName, userId, assetGUID, assetType, relationshipType, from, pageSize);
    }

    @GetMapping(path={"/asset-classifications/{assetGUID}"}, produces={"application/json"})
    @Operation(summary="getClassificationsForAsset", description="Returns the classifications that exists on the asset", externalDocs=@ExternalDocumentation(description="Metadata Classifications", url="https://egeria-project.org/patterns/metadata-manager/categories-of-metadata/?h=relationships#metadata-relationships-and-classifications"))
    public ClassificationListResponse getClassificationsForAsset(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="assetGUID") @NotBlank String assetGUID, @RequestParam(name="assetType", required=false) String assetType, @RequestParam(name="classificationName", required=false) String classificationName) {
        return this.assetService.getClassificationByAssetGUID(serverName, userId, assetGUID, assetType, classificationName);
    }

    @PostMapping(path={"/search"}, produces={"application/json"})
    @Operation(summary="searchByType", description="Returns a list of assets based on the given search criteria", externalDocs=@ExternalDocumentation(description="Search by type Javadoc", url="https://odpi.github.io/egeria/org/odpi/openmetadata/accessservices/assetcatalog/service/AssetCatalogRESTService.html#searchByType(java.lang.String,java.lang.String,java.lang.String,org.odpi.openmetadata.accessservices.assetcatalog.model.rest.body.SearchParameters)"))
    public AssetListResponse searchByType(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @RequestParam(value="searchCriteria") @NotBlank String searchCriteria, @RequestBody SearchParameters searchParameters) {
        return this.assetService.searchByType(serverName, userId, searchCriteria, searchParameters);
    }

    @GetMapping(path={"/assets-by-type-name/{typeName}"}, produces={"application/json"})
    @Operation(summary="getAssetsByTypeName", description="Returns a list of assets based on the given search criteria, using the type name", externalDocs=@ExternalDocumentation(description="Search by type name Javadoc", url="https://odpi.github.io/egeria/org/odpi/openmetadata/accessservices/assetcatalog/service/AssetCatalogRESTService.html#searchByTypeName(java.lang.String,java.lang.String,java.lang.String)"))
    public AssetListResponse getAssetsByTypeName(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="typeName") @NotBlank String typeName) {
        return this.assetService.searchByTypeName(serverName, userId, typeName);
    }

    @GetMapping(path={"/assets-by-type-guid/{typeGUID}"}, produces={"application/json"})
    @Operation(summary="getAssetsByTypeGUID", description="Returns a list of assets based on the given search criteria, using the type GUID", externalDocs=@ExternalDocumentation(description="Search by type GUID Javadoc", url="https://odpi.github.io/egeria/org/odpi/openmetadata/accessservices/assetcatalog/service/AssetCatalogRESTService.html#searchByTypeGUID(java.lang.String,java.lang.String,java.lang.String)"))
    public AssetListResponse getAssetsByTypeGUID(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="typeGUID") @NotBlank String typeGUID) {
        return this.assetService.searchByTypeGUID(serverName, userId, typeGUID);
    }

    @GetMapping(path={"/asset-context/{assetGUID}"}, produces={"application/json"})
    @Operation(summary="getAssetContext", description="Returns the entities that are attached to the given one", externalDocs=@ExternalDocumentation(description="Get attached entities Javadoc", url="https://odpi.github.io/egeria/org/odpi/openmetadata/commonservices/generichandlers/OpenMetadataAPIGenericHandler.html#getAttachedFilteredEntities(java.lang.String,java.lang.String,java.lang.String,java.lang.String,java.lang.String,java.lang.String,int,java.lang.String,java.lang.String,boolean,java.util.Set,java.lang.String,int,boolean,boolean,int,boolean,boolean,java.util.Date,java.lang.String)"))
    public AssetResponse getAssetContext(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="assetGUID") @NotBlank String assetGUID, @RequestParam(name="assetType", required=false) String assetType) {
        return this.assetService.buildContext(serverName, userId, assetGUID, assetType);
    }

    @GetMapping(path={"/supportedTypes"}, produces={"application/json"})
    @Operation(summary="getSupportedTypes", description="Returns the Open Metadata Types that are supported by the Asset Catalog OMAS", externalDocs=@ExternalDocumentation(description="The open metadata type system", url="https://egeria-project.org/types/"))
    public AssetCatalogSupportedTypes getSupportedTypes(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @RequestParam(name="type", required=false) @Nullable String type) {
        return this.assetService.getSupportedTypes(serverName, userId, type);
    }

    @GetMapping(path={"/topics/out-topic-connection/{callerId}"}, produces={"application/json"})
    @Operation(summary="getOutTopicConnection", description="Returns the OutTopic connection", externalDocs=@ExternalDocumentation(description="OMAS OutTopic", url="https://egeria-project.org/concepts/out-topic/"))
    public ConnectionResponse getOutTopicConnection(@PathVariable(value="serverName") String serverName, @PathVariable(value="userId") String userId, @PathVariable(value="callerId") String callerId) {
        return this.assetService.getOutTopicConnection(serverName, userId, callerId);
    }
}

