/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.assetcatalog.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.search.SequencingOrder;
import org.odpi.openmetadata.viewservices.assetcatalog.beans.AssetCatalogBean;
import org.odpi.openmetadata.viewservices.assetcatalog.beans.Elements;
import org.odpi.openmetadata.viewservices.assetcatalog.beans.Type;
import org.odpi.openmetadata.viewservices.assetcatalog.rest.AssetCatalogResponse;
import org.odpi.openmetadata.viewservices.assetcatalog.rest.AssetCatalogSupportedTypes;
import org.odpi.openmetadata.viewservices.assetcatalog.rest.AssetListResponse;
import org.odpi.openmetadata.viewservices.assetcatalog.rest.AssetResponse;
import org.odpi.openmetadata.viewservices.assetcatalog.server.AssetCatalogUIRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/api/open-metadata/asset-catalog/old/assets"})
@Tag(name="API: Asset Catalog OMVS", description="Search for assets, retrieve their properties, lineage and related glossary information.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/asset-catalog/overview/"))
@Deprecated
public class AssetController {
    private final RESTExceptionHandler exceptionHandler = new RESTExceptionHandler();
    private final AssetCatalogUIRESTServices restAPI = new AssetCatalogUIRESTServices();

    @GetMapping(path={"/search"})
    public List<Elements> searchAssets(@PathVariable String serverName, @RequestParam(value="q") String searchCriteria, @RequestParam(value="types") List<String> types, @RequestParam(name="sequencingProperty", defaultValue="displayName") String sequencingProperty, @RequestParam(name="sequencingOrder", defaultValue="PROPERTY_ASCENDING") SequencingOrder sequencingOrder, @RequestParam(defaultValue="false") boolean caseSensitive, @RequestParam(defaultValue="false") boolean exactMatch, @RequestParam(defaultValue="0") Integer from, @RequestParam(defaultValue="10") Integer pageSize) throws PropertyServerException, UserNotAuthorizedException, InvalidParameterException {
        String methodName = "searchAssets";
        AssetListResponse restResult = this.restAPI.searchAssets(serverName, searchCriteria, types, sequencingProperty, sequencingOrder, caseSensitive, exactMatch, from, pageSize);
        this.exceptionHandler.detectAndThrowStandardExceptions("searchAssets", (FFDCResponse)restResult);
        return restResult.getElementsList();
    }

    @GetMapping(path={"/search-by-type-name/{typeName}"})
    public List<Elements> searchAssetsByTypeName(@PathVariable String serverName, @PathVariable(value="typeName") String typeName) throws PropertyServerException, UserNotAuthorizedException, InvalidParameterException {
        String methodName = "searchAssetsByTypeName";
        AssetListResponse restResult = this.restAPI.searchAssetsByTypeName(serverName, typeName);
        this.exceptionHandler.detectAndThrowStandardExceptions("searchAssetsByTypeName", (FFDCResponse)restResult);
        return restResult.getElementsList();
    }

    @GetMapping(path={"/search-by-type-guid/{typeGUID}"})
    public List<Elements> searchAssetsByTypeGUID(@PathVariable String serverName, @PathVariable(value="typeGUID") String typeGUID) throws PropertyServerException, UserNotAuthorizedException, InvalidParameterException {
        String methodName = "searchAssetsByTypeGUID";
        AssetListResponse restResult = this.restAPI.searchAssetsByTypeGUID(serverName, typeGUID);
        this.exceptionHandler.detectAndThrowStandardExceptions("searchAssetsByTypeGUID", (FFDCResponse)restResult);
        return restResult.getElementsList();
    }

    @GetMapping(path={"/types"})
    public List<Type> getSupportedTypes(@PathVariable String serverName) throws PropertyServerException, UserNotAuthorizedException, InvalidParameterException {
        String methodName = "getSupportedTypes";
        AssetCatalogSupportedTypes restResult = this.restAPI.getSupportedTypes(serverName);
        this.exceptionHandler.detectAndThrowStandardExceptions("getSupportedTypes", (FFDCResponse)restResult);
        return restResult.getTypes();
    }

    @GetMapping(value={"/{guid}"})
    public AssetCatalogBean getAsset(@PathVariable String serverName, @PathVariable(value="guid") String guid) throws PropertyServerException, UserNotAuthorizedException, InvalidParameterException {
        String methodName = "getAsset";
        AssetCatalogResponse restResult = this.restAPI.getAsset(serverName, guid);
        this.exceptionHandler.detectAndThrowStandardExceptions("getAsset", (FFDCResponse)restResult);
        return restResult.getAssetCatalogBean();
    }

    @GetMapping(value={"/{guid}/context"})
    public Elements getAssetContext(@PathVariable String serverName, @PathVariable(value="guid") String guid) throws PropertyServerException, UserNotAuthorizedException, InvalidParameterException {
        String methodName = "getAssetContext";
        AssetResponse restResult = this.restAPI.getAssetContext(serverName, guid);
        this.exceptionHandler.detectAndThrowStandardExceptions("getAssetContext", (FFDCResponse)restResult);
        return restResult.getAsset();
    }
}

