/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.assetcatalog.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.viewservices.assetcatalog.beans.Graph;
import org.odpi.openmetadata.viewservices.assetcatalog.beans.LineageVertex;
import org.odpi.openmetadata.viewservices.assetcatalog.rest.ElementHierarchyRequest;
import org.odpi.openmetadata.viewservices.assetcatalog.rest.LineageNodeNamesResponse;
import org.odpi.openmetadata.viewservices.assetcatalog.rest.LineageResponse;
import org.odpi.openmetadata.viewservices.assetcatalog.rest.LineageSearchRequest;
import org.odpi.openmetadata.viewservices.assetcatalog.rest.LineageSearchResponse;
import org.odpi.openmetadata.viewservices.assetcatalog.rest.LineageTypesResponse;
import org.odpi.openmetadata.viewservices.assetcatalog.rest.LineageVertexResponse;
import org.odpi.openmetadata.viewservices.assetcatalog.server.AssetCatalogUIRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/api/open-metadata/asset-catalog/old/lineage"})
@Tag(name="API: Asset Catalog OMVS", description="Search for assets, retrieve their properties, lineage and related glossary information.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/asset-catalog/overview/"))
@Deprecated
public class OpenLineageController {
    private final RESTExceptionHandler exceptionHandler = new RESTExceptionHandler();
    private final AssetCatalogUIRESTServices restAPI = new AssetCatalogUIRESTServices();

    @GetMapping(value={"/entities/{guid}/ultimate-source"})
    public Graph getUltimateSource(@PathVariable String serverName, @PathVariable(value="guid") String guid, @RequestParam boolean includeProcesses) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getUltimateSource";
        LineageResponse restResult = this.restAPI.getUltimateSource(serverName, guid, includeProcesses);
        this.exceptionHandler.detectAndThrowStandardExceptions("getUltimateSource", (FFDCResponse)restResult);
        return restResult.getGraph();
    }

    @GetMapping(value={"/entities/{guid}/end-to-end", "/entities/{guid}/end2end"})
    public Graph getEndToEndLineage(@PathVariable String serverName, @PathVariable(value="guid") String guid, @RequestParam boolean includeProcesses) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getEndToEndLineage";
        LineageResponse restResult = this.restAPI.getEndToEndLineage(serverName, guid, includeProcesses);
        this.exceptionHandler.detectAndThrowStandardExceptions("getEndToEndLineage", (FFDCResponse)restResult);
        return restResult.getGraph();
    }

    @GetMapping(value={"/entities/{guid}/ultimate-destination"})
    public Graph getUltimateDestination(@PathVariable String serverName, @PathVariable(value="guid") String guid, @RequestParam boolean includeProcesses) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getUltimateDestination";
        LineageResponse restResult = this.restAPI.getUltimateDestination(serverName, guid, includeProcesses);
        this.exceptionHandler.detectAndThrowStandardExceptions("getUltimateDestination", (FFDCResponse)restResult);
        return restResult.getGraph();
    }

    @GetMapping(value={"/entities/{guid}/vertical-lineage", "/entities/{guid}/semantic-lineage"})
    public Graph getSemanticLineage(@PathVariable String serverName, @PathVariable(value="guid") String guid, @RequestParam boolean includeProcesses) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getSemanticLineage";
        LineageResponse restResult = this.restAPI.getSemanticLineage(serverName, guid, includeProcesses);
        this.exceptionHandler.detectAndThrowStandardExceptions("getSemanticLineage", (FFDCResponse)restResult);
        return restResult.getGraph();
    }

    @GetMapping(value={"entities/{guid}/details"})
    public LineageVertex getLineageVertex(@PathVariable String serverName, @PathVariable(value="guid") String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getLineageVertex";
        LineageVertexResponse restResult = this.restAPI.getLineageVertex(serverName, guid);
        this.exceptionHandler.detectAndThrowStandardExceptions("getLineageVertex", (FFDCResponse)restResult);
        return restResult.getLineageVertex();
    }

    @GetMapping(value={"types"})
    public List<String> getTypes(@PathVariable String serverName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getTypes";
        LineageTypesResponse restResult = this.restAPI.getTypes(serverName);
        this.exceptionHandler.detectAndThrowStandardExceptions("getTypes", (FFDCResponse)restResult);
        return restResult.getTypes();
    }

    @GetMapping(value={"nodes"})
    public List<String> getNodes(@PathVariable String serverName, @RequestParam(value="type") String type, @RequestParam(value="name") String searchValue, @RequestParam(value="limit") int limit) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getNodes";
        LineageNodeNamesResponse restResult = this.restAPI.getNodes(serverName, type, searchValue, limit);
        this.exceptionHandler.detectAndThrowStandardExceptions("getNodes", (FFDCResponse)restResult);
        return restResult.getNames();
    }

    @PostMapping(value={"entities/search"})
    public List<LineageVertex> searchForVertices(@PathVariable String serverName, @RequestBody LineageSearchRequest searchRequest) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "searchForVertices";
        LineageSearchResponse restResult = this.restAPI.searchForVertices(serverName, searchRequest);
        this.exceptionHandler.detectAndThrowStandardExceptions("searchForVertices", (FFDCResponse)restResult);
        return restResult.getVertices();
    }

    @PostMapping(value={"elements/hierarchy"})
    public Graph getElementHierarchy(@PathVariable String serverName, @RequestBody ElementHierarchyRequest elementHierarchyRequest) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getElementHierarchy";
        LineageResponse restResult = this.restAPI.getElementHierarchy(serverName, elementHierarchyRequest);
        this.exceptionHandler.detectAndThrowStandardExceptions("getElementHierarchy", (FFDCResponse)restResult);
        return restResult.getGraph();
    }
}

