/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.assetcatalog.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.rest.AssetGraphResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.AssetLineageGraphResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.AssetSearchMatchesListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FilterRequestBody;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.rest.AssetsResponse;
import org.odpi.openmetadata.viewservices.assetcatalog.rest.AssetCatalogSupportedTypes;
import org.odpi.openmetadata.viewservices.assetcatalog.server.AssetCatalogRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/api/open-metadata/asset-catalog"})
@Tag(name="API: Asset Catalog OMVS", description="Search for assets, retrieve their properties, lineage and related glossary information.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/asset-catalog/overview/"))
public class AssetCatalogResource {
    private final AssetCatalogRESTServices restAPI = new AssetCatalogRESTServices();

    @GetMapping(path={"/assets/types"})
    @Operation(summary="getAssetTypes", description="Return the subtypes for asset.", externalDocs=@ExternalDocumentation(description="Assets", url="https://egeria-project.org/concepts/asset/"))
    public AssetCatalogSupportedTypes getAssetTypes(@PathVariable String serverName) {
        return this.restAPI.getSupportedTypes(serverName);
    }

    @GetMapping(path={"/assets/{assetGUID}/as-graph"})
    @Operation(summary="getAssetGraph", description="Return all the elements that are anchored to an asset plus relationships between these elements and to other elements.", externalDocs=@ExternalDocumentation(description="Assets", url="https://egeria-project.org/concepts/asset/"))
    public AssetGraphResponse getAssetGraph(@PathVariable String serverName, @PathVariable String assetGUID, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize) {
        return this.restAPI.getAssetGraph(serverName, assetGUID, startFrom, pageSize);
    }

    @PostMapping(path={"/assets/{assetGUID}/as-lineage-graph"})
    @Operation(summary="getAssetLineageGraph", description="Return all the elements that are linked to an asset using lineage relationships.  The relationships are retrieved both from the asset, and the anchored schema elements.", externalDocs=@ExternalDocumentation(description="Assets", url="https://egeria-project.org/features/lineage-management/overview/"))
    public AssetLineageGraphResponse getAssetLineageGraph(@PathVariable String serverName, @PathVariable String assetGUID, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestBody(required=false) List<String> relationshipTypes) {
        return this.restAPI.getAssetLineageGraph(serverName, assetGUID, relationshipTypes, startFrom, pageSize);
    }

    @PostMapping(path={"/assets/in-domain/by-search-string"})
    @Operation(summary="findInAssetDomain", description="Locate string value in elements that are anchored to assets.  The search string is a regular expression (regEx).", externalDocs=@ExternalDocumentation(description="Assets", url="https://egeria-project.org/concepts/asset/"))
    public AssetSearchMatchesListResponse findInAssetDomain(@PathVariable String serverName, @RequestParam(required=false, defaultValue="true") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="false") boolean ignoreCase, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestBody(required=false) FilterRequestBody requestBody) {
        return this.restAPI.findInAssetDomain(serverName, requestBody, startsWith, endsWith, ignoreCase, startFrom, pageSize);
    }

    @PostMapping(path={"/assets/by-metadata-collection-id/{metadataCollectionId}"})
    @Operation(summary="getAssetsByMetadataCollectionId", description="Return a list of assets that come from the requested metadata collection. The filter in the request body is optional. If specified it is a type name to limit the results passed back.", externalDocs=@ExternalDocumentation(description="Assets", url="https://egeria-project.org/concepts/asset/"))
    public AssetsResponse getAssetsByMetadataCollectionId(@PathVariable String serverName, @PathVariable String metadataCollectionId, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestBody(required=false) FilterRequestBody requestBody) {
        return this.restAPI.getAssetsByMetadataCollectionId(serverName, metadataCollectionId, startFrom, pageSize, requestBody);
    }
}

