/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetcatalog.connectors.outtopic;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetcatalog.api.AssetCatalogEventInterface;
import org.odpi.openmetadata.accessservices.assetcatalog.api.AssetCatalogEventListener;
import org.odpi.openmetadata.accessservices.assetcatalog.connectors.outtopic.AssetCatalogErrorCode;
import org.odpi.openmetadata.accessservices.assetcatalog.model.AssetCatalogEvent;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicListenerConnectorBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetCatalogOutTopicClientConnector
extends OpenMetadataTopicListenerConnectorBase
implements AssetCatalogEventInterface,
AssetCatalogEventListener {
    private static final Logger log = LoggerFactory.getLogger(AssetCatalogOutTopicClientConnector.class);
    private List<AssetCatalogEventListener> internalEventListeners = new ArrayList<AssetCatalogEventListener>();

    public synchronized void registerListener(String userId, AssetCatalogEventListener listener) throws InvalidParameterException {
        String methodName = "registerListener";
        String parameterName = "listener";
        if (listener == null) {
            throw new InvalidParameterException(AssetCatalogErrorCode.NULL_LISTENER.getMessageDefinition(userId, "registerListener"), ((Object)((Object)this)).getClass().getName(), "registerListener", "listener");
        }
        this.internalEventListeners.add(listener);
    }

    public synchronized void processEvent(String event) {
        if (event != null) {
            try {
                AssetCatalogEvent eventObject = (AssetCatalogEvent)super.getEventBean(event, AssetCatalogEvent.class);
                for (AssetCatalogEventListener listener : this.internalEventListeners) {
                    try {
                        listener.processEvent(eventObject);
                    }
                    catch (Exception error) {
                        log.error("Listener: " + listener.getClass().getName() + " is unable to process event: " + event, (Throwable)error);
                    }
                }
            }
            catch (Exception error) {
                log.error("Unable to read event: " + event, (Throwable)error);
            }
        }
    }

    public void processEvent(AssetCatalogEvent event) {
        log.debug("process event " + ((Object)((Object)this)).getClass().getName());
    }
}

