/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions;

import java.util.Objects;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.AssetConsumerCheckedExceptionBase;

public class NoConnectedAssetException
extends AssetConsumerCheckedExceptionBase {
    private String connectionGUID;

    public NoConnectedAssetException(int httpCode, String className, String actionDescription, String errorMessage, String systemAction, String userAction, String connectionGUID) {
        super(httpCode, className, actionDescription, errorMessage, systemAction, userAction);
        this.connectionGUID = connectionGUID;
    }

    public NoConnectedAssetException(int httpCode, String className, String actionDescription, String errorMessage, String systemAction, String userAction, Throwable caughtError, String connectionGUID) {
        super(httpCode, className, actionDescription, errorMessage, systemAction, userAction, caughtError);
        this.connectionGUID = connectionGUID;
    }

    public String getConnectionGUID() {
        return this.connectionGUID;
    }

    @Override
    public String toString() {
        return "NoConnectedAssetException{connectionGUID='" + this.connectionGUID + '\'' + ", reportedHTTPCode=" + this.getReportedHTTPCode() + ", reportingClassName='" + this.getReportingClassName() + '\'' + ", reportingActionDescription='" + this.getReportingActionDescription() + '\'' + ", errorMessage='" + this.getErrorMessage() + '\'' + ", reportedSystemAction='" + this.getReportedSystemAction() + '\'' + ", reportedUserAction='" + this.getReportedUserAction() + '\'' + ", reportedCaughtException=" + this.getReportedCaughtException() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof NoConnectedAssetException)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        NoConnectedAssetException that = (NoConnectedAssetException)objectToCompare;
        return Objects.equals(this.getConnectionGUID(), that.getConnectionGUID());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getConnectionGUID());
    }
}

