/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.AssetConsumerOMASAPIResponse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Comment;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class CommentConversationResponse
extends AssetConsumerOMASAPIResponse {
    private Comment comment = null;
    private List<String> commentReplies = null;

    public CommentConversationResponse() {
    }

    public CommentConversationResponse(CommentConversationResponse template) {
        super(template);
        if (template != null) {
            this.comment = template.getComment();
            this.commentReplies = template.getCommentReplies();
        }
    }

    public Comment getComment() {
        if (this.comment == null) {
            return null;
        }
        return this.comment;
    }

    public void setComment(Comment comment) {
        this.comment = comment;
    }

    public List<String> getCommentReplies() {
        if (this.commentReplies == null) {
            return null;
        }
        if (this.commentReplies.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(this.commentReplies);
    }

    public void setCommentReplies(List<String> commentReplies) {
        this.commentReplies = commentReplies;
    }

    @Override
    public String toString() {
        return "CommentConversationResponse{comment=" + this.comment + ", commentReplies=" + this.commentReplies + ", relatedHTTPCode=" + this.getRelatedHTTPCode() + ", exceptionClassName='" + this.getExceptionClassName() + '\'' + ", exceptionErrorMessage='" + this.getExceptionErrorMessage() + '\'' + ", exceptionSystemAction='" + this.getExceptionSystemAction() + '\'' + ", exceptionUserAction='" + this.getExceptionUserAction() + '\'' + ", exceptionProperties=" + this.getExceptionProperties() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        CommentConversationResponse that = (CommentConversationResponse)objectToCompare;
        return Objects.equals(this.getComment(), that.getComment()) && Objects.equals(this.getCommentReplies(), that.getCommentReplies());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getComment(), this.getCommentReplies());
    }
}

