/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.assetconsumer.events.AssetConsumerEventType;
import org.odpi.openmetadata.accessservices.assetconsumer.events.AssetEvent;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=AssetEvent.class, name="AssetEvent")})
public abstract class AssetConsumerEventHeader
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long eventVersionId = 1L;
    private AssetConsumerEventType eventType = null;

    AssetConsumerEventHeader() {
    }

    AssetConsumerEventHeader(AssetConsumerEventHeader template) {
        if (template != null) {
            this.eventVersionId = template.getEventVersionId();
            this.eventType = template.getEventType();
        }
    }

    public long getEventVersionId() {
        return this.eventVersionId;
    }

    public void setEventVersionId(long eventVersionId) {
        this.eventVersionId = eventVersionId;
    }

    public AssetConsumerEventType getEventType() {
        return this.eventType;
    }

    public void setEventType(AssetConsumerEventType eventType) {
        this.eventType = eventType;
    }

    public String toString() {
        return "AssetConsumerEventHeader{eventVersionId=" + this.eventVersionId + ", eventType=" + this.eventType + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        AssetConsumerEventHeader that = (AssetConsumerEventHeader)objectToCompare;
        return this.getEventVersionId() == that.getEventVersionId() && this.getEventType() == that.getEventType();
    }

    public int hashCode() {
        return Objects.hash(this.getEventVersionId(), this.getEventType());
    }
}

