/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.assetconsumer.events.AssetConsumerEventHeader;
import org.odpi.openmetadata.accessservices.assetconsumer.events.NewAssetEvent;
import org.odpi.openmetadata.accessservices.assetconsumer.events.UpdatedAssetEvent;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.Asset;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=NewAssetEvent.class, name="NewAssetEvent"), @JsonSubTypes.Type(value=UpdatedAssetEvent.class, name="UpdatedAssetEvent")})
public class AssetEvent
extends AssetConsumerEventHeader {
    private Asset asset = null;

    public AssetEvent() {
    }

    public AssetEvent(AssetEvent template) {
        super(template);
        if (template != null) {
            this.asset = template.getAsset();
        }
    }

    public Asset getAsset() {
        return this.asset;
    }

    public void setAsset(Asset asset) {
        this.asset = asset;
    }

    @Override
    public String toString() {
        return "AssetEvent{asset=" + this.asset + ", eventVersionId=" + this.getEventVersionId() + ", eventType=" + this.getEventType() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetEvent that = (AssetEvent)objectToCompare;
        return Objects.equals(this.getAsset(), that.getAsset());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getAsset());
    }
}

