/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.ReferenceableHeader;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=Asset.class, name="AssetCollectionMember")})
public class Asset
extends ReferenceableHeader {
    private String displayName = null;
    private String description = null;
    private String owner = null;
    private List<String> zoneMembership = null;
    private String lastChange = null;

    public Asset() {
    }

    public Asset(Asset template) {
        super(template);
        if (template != null) {
            this.displayName = template.getDisplayName();
            this.description = template.getDescription();
            this.owner = template.getOwner();
            this.zoneMembership = template.getZoneMembership();
            this.lastChange = template.getLastChange();
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public List<String> getZoneMembership() {
        if (this.zoneMembership == null) {
            return null;
        }
        if (this.zoneMembership.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(this.zoneMembership);
    }

    public void setZoneMembership(List<String> zoneMembership) {
        this.zoneMembership = zoneMembership;
    }

    public String getLastChange() {
        return this.lastChange;
    }

    public void setLastChange(String lastChange) {
        this.lastChange = lastChange;
    }

    @Override
    public String toString() {
        return "Asset{displayName='" + this.displayName + '\'' + ", description='" + this.description + '\'' + ", owner='" + this.owner + '\'' + ", zoneMembership=" + this.zoneMembership + ", lastChange='" + this.lastChange + '\'' + ", GUID='" + this.getGUID() + '\'' + ", typeName='" + this.getTypeName() + '\'' + ", typeDescription='" + this.getTypeDescription() + '\'' + ", qualifiedName='" + this.getQualifiedName() + '\'' + ", additionalProperties=" + this.getAdditionalProperties() + ", classifications=" + this.getClassifications() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        Asset asset = (Asset)objectToCompare;
        return Objects.equals(this.getDisplayName(), asset.getDisplayName()) && Objects.equals(this.getDescription(), asset.getDescription()) && Objects.equals(this.getOwner(), asset.getOwner()) && Objects.equals(this.getZoneMembership(), asset.getZoneMembership()) && Objects.equals(this.getLastChange(), asset.getLastChange());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getDisplayName(), this.getDescription(), this.getOwner(), this.getZoneMembership(), this.getLastChange());
    }
}

