/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.Asset;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.AssetConsumerElementHeader;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.GlossaryTerm;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.ReferenceableClassification;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=Asset.class, name="Asset"), @JsonSubTypes.Type(value=GlossaryTerm.class, name="GlossaryTerm")})
public abstract class ReferenceableHeader
extends AssetConsumerElementHeader {
    private String guid = null;
    private String typeName = null;
    private String typeDescription = null;
    private String originId = null;
    private String originName = null;
    private String originType = null;
    private String originLicense = null;
    private String qualifiedName = null;
    private Map<String, Object> additionalProperties = null;
    private List<ReferenceableClassification> classifications = null;

    public ReferenceableHeader() {
    }

    public ReferenceableHeader(ReferenceableHeader template) {
        super(template);
        if (template != null) {
            this.guid = template.getGUID();
            this.typeName = template.getTypeName();
            this.typeDescription = template.getTypeDescription();
            this.originId = template.getOriginId();
            this.originName = template.getOriginName();
            this.originType = template.getOriginType();
            this.originLicense = template.getOriginLicense();
            this.qualifiedName = template.getQualifiedName();
            this.additionalProperties = template.getAdditionalProperties();
            this.classifications = template.getClassifications();
        }
    }

    public String getGUID() {
        return this.guid;
    }

    public void setGUID(String guid) {
        this.guid = guid;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getTypeDescription() {
        return this.typeDescription;
    }

    public String getOriginId() {
        return this.originId;
    }

    public void setOriginId(String originId) {
        this.originId = originId;
    }

    public String getOriginName() {
        return this.originName;
    }

    public void setOriginName(String originName) {
        this.originName = originName;
    }

    public String getOriginType() {
        return this.originType;
    }

    public void setOriginType(String originType) {
        this.originType = originType;
    }

    public String getOriginLicense() {
        return this.originLicense;
    }

    public void setOriginLicense(String originLicense) {
        this.originLicense = originLicense;
    }

    public void setTypeDescription(String typeDescription) {
        this.typeDescription = typeDescription;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public void setQualifiedName(String qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    public Map<String, Object> getAdditionalProperties() {
        if (this.additionalProperties == null) {
            return null;
        }
        if (this.additionalProperties.isEmpty()) {
            return null;
        }
        return new HashMap<String, Object>(this.additionalProperties);
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public List<ReferenceableClassification> getClassifications() {
        if (this.classifications == null) {
            return null;
        }
        if (this.classifications.isEmpty()) {
            return null;
        }
        ArrayList<ReferenceableClassification> clonedList = new ArrayList<ReferenceableClassification>();
        for (ReferenceableClassification existingElement : this.classifications) {
            clonedList.add(new ReferenceableClassification(existingElement));
        }
        return clonedList;
    }

    public void setClassifications(List<ReferenceableClassification> classifications) {
        this.classifications = classifications;
    }

    public String toString() {
        return "ReferenceableHeader{guid='" + this.guid + '\'' + ", typeName='" + this.typeName + '\'' + ", typeDescription='" + this.typeDescription + '\'' + ", qualifiedName='" + this.qualifiedName + '\'' + ", additionalProperties=" + this.additionalProperties + ", classifications=" + this.classifications + ", GUID='" + this.getGUID() + '\'' + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        ReferenceableHeader that = (ReferenceableHeader)objectToCompare;
        return Objects.equals(this.guid, that.guid) && Objects.equals(this.getTypeName(), that.getTypeName()) && Objects.equals(this.getTypeDescription(), that.getTypeDescription()) && Objects.equals(this.getQualifiedName(), that.getQualifiedName()) && Objects.equals(this.getAdditionalProperties(), that.getAdditionalProperties()) && Objects.equals(this.getClassifications(), that.getClassifications());
    }

    public int hashCode() {
        return Objects.hash(this.guid, this.getTypeName(), this.getTypeDescription(), this.getQualifiedName(), this.getAdditionalProperties(), this.getClassifications());
    }
}

