/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.GlossaryTerm;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.AssetConsumerOMASAPIResponse;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class MeaningListResponse
extends AssetConsumerOMASAPIResponse {
    private List<GlossaryTerm> meanings = null;
    private int startingFromElement = 0;

    public MeaningListResponse() {
    }

    public MeaningListResponse(MeaningListResponse template) {
        super(template);
        if (template != null) {
            this.startingFromElement = template.getStartingFromElement();
            this.meanings = template.getMeanings();
        }
    }

    public List<GlossaryTerm> getMeanings() {
        if (this.meanings == null) {
            return null;
        }
        if (this.meanings.isEmpty()) {
            return null;
        }
        ArrayList<GlossaryTerm> clonedList = new ArrayList<GlossaryTerm>();
        for (GlossaryTerm existingElement : this.meanings) {
            clonedList.add(new GlossaryTerm(existingElement));
        }
        return clonedList;
    }

    public void setMeanings(List<GlossaryTerm> meanings) {
        this.meanings = meanings;
    }

    public int getStartingFromElement() {
        return this.startingFromElement;
    }

    public void setStartingFromElement(int startingFromElement) {
        this.startingFromElement = startingFromElement;
    }

    @Override
    public String toString() {
        return "MeaningListResponse{meanings=" + this.meanings + ", startingFromElement=" + this.startingFromElement + ", relatedHTTPCode=" + this.getRelatedHTTPCode() + ", exceptionClassName='" + this.getExceptionClassName() + '\'' + ", exceptionErrorMessage='" + this.getExceptionErrorMessage() + '\'' + ", exceptionSystemAction='" + this.getExceptionSystemAction() + '\'' + ", exceptionUserAction='" + this.getExceptionUserAction() + '\'' + ", exceptionProperties=" + this.getExceptionProperties() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        MeaningListResponse that = (MeaningListResponse)objectToCompare;
        return this.getStartingFromElement() == that.getStartingFromElement() && Objects.equals(this.getMeanings(), that.getMeanings());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getMeanings(), this.getStartingFromElement());
    }
}

