/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.Tag;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.AssetConsumerOMASAPIResponse;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class TagListResponse
extends AssetConsumerOMASAPIResponse {
    private List<Tag> tags = null;
    private int startingFromElement = 0;

    public TagListResponse() {
    }

    public TagListResponse(TagListResponse template) {
        super(template);
        if (template != null) {
            this.startingFromElement = template.getStartingFromElement();
            this.tags = template.getTags();
        }
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            return null;
        }
        if (this.tags.isEmpty()) {
            return null;
        }
        ArrayList<Tag> clonedList = new ArrayList<Tag>();
        for (Tag existingElement : this.tags) {
            clonedList.add(new Tag(existingElement));
        }
        return clonedList;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public int getStartingFromElement() {
        return this.startingFromElement;
    }

    public void setStartingFromElement(int startingFromElement) {
        this.startingFromElement = startingFromElement;
    }

    @Override
    public String toString() {
        return "TagListResponse{tags=" + this.tags + ", startingFromElement=" + this.startingFromElement + ", relatedHTTPCode=" + this.getRelatedHTTPCode() + ", exceptionClassName='" + this.getExceptionClassName() + '\'' + ", exceptionErrorMessage='" + this.getExceptionErrorMessage() + '\'' + ", exceptionSystemAction='" + this.getExceptionSystemAction() + '\'' + ", exceptionUserAction='" + this.getExceptionUserAction() + '\'' + ", exceptionProperties=" + this.getExceptionProperties() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        TagListResponse that = (TagListResponse)objectToCompare;
        return this.getStartingFromElement() == that.getStartingFromElement() && Objects.equals(this.getTags(), that.getTags());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getTags(), this.getStartingFromElement());
    }
}

