/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.CommentType;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.ReferenceableProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class CommentProperties
extends ReferenceableProperties {
    private static final long serialVersionUID = 1L;
    private CommentType commentType = null;
    private String commentText = null;
    private String user = null;
    private boolean isPublic = false;

    public CommentProperties() {
    }

    public CommentProperties(CommentProperties template) {
        super(template);
        if (template != null) {
            this.commentType = template.getCommentType();
            this.user = template.getUser();
            this.commentText = template.getCommentText();
            this.isPublic = template.getIsPublic();
        }
    }

    public CommentType getCommentType() {
        return this.commentType;
    }

    public void setCommentType(CommentType commentType) {
        this.commentType = commentType;
    }

    public String getCommentText() {
        return this.commentText;
    }

    public void setCommentText(String commentText) {
        this.commentText = commentText;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public boolean getIsPublic() {
        return this.isPublic;
    }

    public void setIsPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    @Override
    public String toString() {
        return "CommentProperties{commentType=" + this.commentType + ", commentText='" + this.commentText + '\'' + ", user='" + this.user + '\'' + ", isPublic=" + this.isPublic + ", public=" + this.getIsPublic() + ", typeName='" + this.getTypeName() + '\'' + ", qualifiedName='" + this.getQualifiedName() + '\'' + ", additionalProperties=" + this.getAdditionalProperties() + ", extendedProperties=" + this.getExtendedProperties() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        CommentProperties that = (CommentProperties)objectToCompare;
        return this.isPublic == that.isPublic && this.commentType == that.commentType && Objects.equals(this.commentText, that.commentText) && Objects.equals(this.user, that.user);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.commentType, this.commentText, this.user, this.isPublic);
    }
}

