/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.assetconsumer.elements.ElementHeader;
import org.odpi.openmetadata.accessservices.assetconsumer.elements.MetadataElement;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.AssetProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AssetElement
implements MetadataElement,
Serializable {
    private static final long serialVersionUID = 1L;
    private ElementHeader elementHeader = null;
    private AssetProperties assetProperties = null;

    public AssetElement() {
    }

    public AssetElement(AssetElement template) {
        if (template != null) {
            this.elementHeader = template.getElementHeader();
            this.assetProperties = template.getAssetProperties();
        }
    }

    @Override
    public ElementHeader getElementHeader() {
        return this.elementHeader;
    }

    @Override
    public void setElementHeader(ElementHeader elementHeader) {
        this.elementHeader = elementHeader;
    }

    public AssetProperties getAssetProperties() {
        return this.assetProperties;
    }

    public void setAssetProperties(AssetProperties assetProperties) {
        this.assetProperties = assetProperties;
    }

    public String toString() {
        return "AssetElement{elementHeader=" + this.elementHeader + ", assetProperties=" + this.assetProperties + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        AssetElement that = (AssetElement)objectToCompare;
        return Objects.equals(this.elementHeader, that.elementHeader) && Objects.equals(this.assetProperties, that.assetProperties);
    }

    public int hashCode() {
        return Objects.hash(this.elementHeader, this.assetProperties);
    }
}

