/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.StarRating;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RatingProperties
implements Serializable {
    private static final long serialVersionUID = 1L;
    private StarRating starRating = null;
    private String review = null;
    private String user = null;
    private boolean isPublic = false;

    public RatingProperties() {
    }

    public RatingProperties(RatingProperties template) {
        if (template != null) {
            this.user = template.getUser();
            this.starRating = template.getStarRating();
            this.review = template.getReview();
            this.isPublic = template.isPublic;
        }
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public StarRating getStarRating() {
        return this.starRating;
    }

    public void setStarRating(StarRating starRating) {
        this.starRating = starRating;
    }

    public String getReview() {
        return this.review;
    }

    public void setReview(String review) {
        this.review = review;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public void setPublic(boolean aPublic) {
        this.isPublic = aPublic;
    }

    public String toString() {
        return "RatingProperties{starRating=" + this.starRating + ", review='" + this.review + '\'' + ", user='" + this.user + '\'' + ", isPublic='" + this.isPublic + '\'' + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        RatingProperties rating = (RatingProperties)objectToCompare;
        return this.isPublic() == rating.isPublic() && this.getStarRating() == rating.getStarRating() && Objects.equals(this.getReview(), rating.getReview()) && Objects.equals(this.getUser(), rating.getUser());
    }

    public int hashCode() {
        return Objects.hash(this.starRating, this.review, this.user, this.isPublic);
    }
}

