/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.assetconsumer.elements.MetadataElement;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.MeaningProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class MeaningElement
implements MetadataElement,
Serializable {
    private static final long serialVersionUID = 1L;
    private ElementHeader elementHeader = null;
    private MeaningProperties meaningProperties = null;

    public MeaningElement() {
    }

    public MeaningElement(MeaningElement template) {
        if (template != null) {
            this.elementHeader = template.getElementHeader();
            this.meaningProperties = template.getMeaningProperties();
        }
    }

    @Override
    public ElementHeader getElementHeader() {
        return this.elementHeader;
    }

    @Override
    public void setElementHeader(ElementHeader elementHeader) {
        this.elementHeader = elementHeader;
    }

    public MeaningProperties getMeaningProperties() {
        return this.meaningProperties;
    }

    public void setMeaningProperties(MeaningProperties meaningProperties) {
        this.meaningProperties = meaningProperties;
    }

    public String toString() {
        return "MeaningElement{elementHeader=" + this.elementHeader + ", meaningProperties=" + this.meaningProperties + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        MeaningElement that = (MeaningElement)objectToCompare;
        return Objects.equals(this.elementHeader, that.elementHeader) && Objects.equals(this.meaningProperties, that.meaningProperties);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.elementHeader, this.meaningProperties);
    }
}

