/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStub;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class TaggedElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ElementHeader relationshipHeader = null;
    private ElementStub relatedElement = null;
    private boolean isPublic = false;

    public TaggedElement() {
    }

    public TaggedElement(TaggedElement template) {
        if (template != null) {
            this.relationshipHeader = template.getRelationshipHeader();
            this.relatedElement = template.getRelatedElement();
            this.isPublic = template.getIsPublic();
        }
    }

    public boolean getIsPublic() {
        return this.isPublic;
    }

    public void setIsPublic(boolean aPublic) {
        this.isPublic = aPublic;
    }

    public ElementHeader getRelationshipHeader() {
        return this.relationshipHeader;
    }

    public void setRelationshipHeader(ElementHeader relationshipHeader) {
        this.relationshipHeader = relationshipHeader;
    }

    public ElementStub getRelatedElement() {
        return this.relatedElement;
    }

    public void setRelatedElement(ElementStub relatedElement) {
        this.relatedElement = relatedElement;
    }

    public String toString() {
        return "TaggedElement{relationshipHeader=" + this.relationshipHeader + ", relatedElement=" + this.relatedElement + ", isPublic=" + this.isPublic + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof TaggedElement)) {
            return false;
        }
        TaggedElement that = (TaggedElement)objectToCompare;
        if (this.isPublic != that.isPublic) {
            return false;
        }
        if (this.relationshipHeader != null ? !this.relationshipHeader.equals((Object)that.relationshipHeader) : that.relationshipHeader != null) {
            return false;
        }
        return this.relatedElement != null ? this.relatedElement.equals((Object)that.relatedElement) : that.relatedElement == null;
    }

    public int hashCode() {
        int result = this.relationshipHeader != null ? this.relationshipHeader.hashCode() : 0;
        result = 31 * result + (this.relatedElement != null ? this.relatedElement.hashCode() : 0);
        result = 31 * result + (this.isPublic ? 1 : 0);
        return result;
    }
}

