/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.assetconsumer.elements.MeaningElement;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.PagedResponse;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class GlossaryTermListResponse
extends PagedResponse {
    private List<MeaningElement> meanings = null;

    public GlossaryTermListResponse() {
    }

    public GlossaryTermListResponse(GlossaryTermListResponse template) {
        super(template);
        if (template != null) {
            this.meanings = template.getMeanings();
        }
    }

    public List<MeaningElement> getMeanings() {
        if (this.meanings == null) {
            return null;
        }
        if (this.meanings.isEmpty()) {
            return null;
        }
        ArrayList<MeaningElement> clonedList = new ArrayList<MeaningElement>();
        for (MeaningElement existingElement : this.meanings) {
            clonedList.add(new MeaningElement(existingElement));
        }
        return clonedList;
    }

    public void setMeanings(List<MeaningElement> meanings) {
        this.meanings = meanings;
    }

    @Override
    public String toString() {
        return "GlossaryTermListResponse{meanings=" + this.meanings + ", startingFromElement=" + this.getStartingFromElement() + ", exceptionClassName='" + this.getExceptionClassName() + "', exceptionCausedBy='" + this.getExceptionCausedBy() + "', actionDescription='" + this.getActionDescription() + "', relatedHTTPCode=" + this.getRelatedHTTPCode() + ", exceptionErrorMessage='" + this.getExceptionErrorMessage() + "', exceptionErrorMessageId='" + this.getExceptionErrorMessageId() + "', exceptionErrorMessageParameters=" + Arrays.toString(this.getExceptionErrorMessageParameters()) + ", exceptionSystemAction='" + this.getExceptionSystemAction() + "', exceptionUserAction='" + this.getExceptionUserAction() + "', exceptionProperties=" + this.getExceptionProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || ((Object)((Object)this)).getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        GlossaryTermListResponse that = (GlossaryTermListResponse)((Object)objectToCompare);
        return Objects.equals(this.getMeanings(), that.getMeanings());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getMeanings());
    }
}

