/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;

public enum AssetConsumerAuditCode implements AuditLogMessageSet
{
    SERVICE_INITIALIZING("OMAS-ASSET-CONSUMER-0001", OMRSAuditLogRecordSeverity.STARTUP, "The Asset Consumer Open Metadata Access Service (OMAS) is initializing a new server instance", "The local server has started up a new instance of the Asset Consumer OMAS.  This service enables tools to locate assets in the catalog, retrieve information about themand create open connectors to access the content of the assets.  It also sends events on its out topic each time a new asset is created or updated.", "No action is required as long as this service is expected to be started for this server.  If it is not required, then remove the configuration for this service from the access service list in this server's configuration document."),
    SERVICE_PUBLISHING("OMAS-ASSET-CONSUMER-0002", OMRSAuditLogRecordSeverity.STARTUP, "The Asset Consumer Open Metadata Access Service (OMAS) is ready to publish asset notifications to topic {0}", "The local server has started up the event publisher for the Asset Consumer OMAS.  It will begin publishing asset configuration changes to its out topic.", "This is part of the normal start up of the service. Check that there are no errors from the event bus."),
    SERVICE_INITIALIZED("OMAS-ASSET-CONSUMER-0003", OMRSAuditLogRecordSeverity.STARTUP, "The Asset Consumer Open Metadata Access Service (OMAS) has initialized a new instance for server {0}", "The access service has completed initialization of a new instance.", "Verify that this service has initialized successfully and has the correct set of supported zones defined.  Investigate any reported errors.  Also ensure that the enterprise repository services and the OCF metadata management services are initialized."),
    SERVICE_SHUTDOWN("OMAS-ASSET-CONSUMER-0004", OMRSAuditLogRecordSeverity.SHUTDOWN, "The Asset Consumer Open Metadata Access Service (OMAS) is shutting down its instance for server {0}", "The local administrator has requested shut down of an Asset Consumer OMAS instance.", "No action is required if the server shutdown was intentional."),
    SERVICE_INSTANCE_FAILURE("OMAS-ASSET-CONSUMER-0005", OMRSAuditLogRecordSeverity.EXCEPTION, "The Asset Consumer Open Metadata Access Service (OMAS) is unable to initialize a new instance in server {0}; the {1} exception occurred with error message: {2}", "The access service detected an error during the start up of a specific server instance.  Its services are not available for the server.", "Review the error message and any other reported failures to determine the cause of the problem.  Once this is resolved, restart the server."),
    ASSET_AUDIT_LOG("OMAS-ASSET-CONSUMER-0008", OMRSAuditLogRecordSeverity.ASSET, "Audit message for asset {0}: {1}", "An asset consumer has logged a message for an asset.", "Review the message to ensure no action is required."),
    PUBLISHING_SHUTDOWN("OMAS-ASSET-CONSUMER-0010", OMRSAuditLogRecordSeverity.SHUTDOWN, "The Asset Consumer Open Metadata Access Service (OMAS) is no longer publishing events to topic {0}", "The local administrator has requested shut down of an Asset Consumer OMAS instance.  No more configuration events will be published to the named topic.", "This is part of the normal shutdown of the service.   No action is required if this is serviceshutdown was intentional."),
    PUBLISHING_SHUTDOWN_ERROR("OMAS-ASSET-CONSUMER-0011", OMRSAuditLogRecordSeverity.SHUTDOWN, "The Asset Consumer Open Metadata Access Service (OMAS) caught an unexpected {0} exception whilst shutting down the out topic {1}. The error message was: {2}", "The local administrator has requested shut down of an Asset Consumer OMAS instance.  No more configuration events will be published to the named topic, although the connection to the event bus may not be released properly.", "This is part of the normal shutdown of the service. However, an exception is not expected at this point unless it is the consequence of a previous error. Review the error message and any other reported failures to determine if this exception needs special attention."),
    OUT_TOPIC_EVENT("OMAS-ASSET-CONSUMER-0012", OMRSAuditLogRecordSeverity.EVENT, "The Asset Consumer Open Metadata Access Service (OMAS) has sent event of type: {0}", "The access service sends out asset notifications to ensure connected tools have the most up to-date knowledge about assets.  This audit log message is to create a record of the events that are being published.", "This event indicates that the metadata for an asset has changed.  This my or may not be significant to the receiving tools."),
    PROCESS_EVENT_EXCEPTION("OMAS-ASSET-CONSUMER-0014", OMRSAuditLogRecordSeverity.EXCEPTION, "Event {0} could not be published due to {1} exception with message: {2}", "The system is unable to publish the event to the Asset Consumer OMAS's OutTopic.", "Verify the topic configuration and that the event broker is running."),
    OUT_TOPIC_FAILURE("OMAS-ASSET-CONSUMER-0018", OMRSAuditLogRecordSeverity.EXCEPTION, "The Asset Consumer Open Metadata Access Service (OMAS) is unable to send an event on its out topic {0}; exception {1} returned error message: {2}", "The access service detected an error during the start up of the out topic.  Its services are not available for the server.", "Review the error message and any other reported failures to determine the cause of the problem.  Check the status of the event bus.  Once this is resolved, restart the server.");

    private final AuditLogMessageDefinition messageDefinition;

    private AssetConsumerAuditCode(String messageId, OMRSAuditLogRecordSeverity severity, String message, String systemAction, String userAction) {
        this.messageDefinition = new AuditLogMessageDefinition(messageId, (AuditLogRecordSeverity)severity, message, systemAction, userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return this.messageDefinition;
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        this.messageDefinition.setMessageParameters(params);
        return this.messageDefinition;
    }

    public String toString() {
        return "AssetConsumerAuditCode{messageDefinition=" + this.messageDefinition + "}";
    }
}

