/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class MetadataElement
extends ElementHeader {
    private Map<String, Object> properties = null;

    public MetadataElement() {
    }

    public MetadataElement(MetadataElement template) {
        super((ElementHeader)template);
        if (template != null) {
            this.properties = template.getProperties();
        }
    }

    public MetadataElement(ElementHeader template) {
        super(template);
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            return null;
        }
        if (this.properties.isEmpty()) {
            return null;
        }
        return new HashMap<String, Object>(this.properties);
    }

    public String toString() {
        return "MetadataElement{properties=" + this.properties + ", status=" + this.getStatus() + ", type=" + this.getType() + ", origin=" + this.getOrigin() + ", versions=" + this.getVersions() + ", headerVersion=" + this.getHeaderVersion() + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || ((Object)((Object)this)).getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        MetadataElement that = (MetadataElement)((Object)objectToCompare);
        return Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.properties);
    }
}

