/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.FeedbackRequestBody;
import org.odpi.openmetadata.frameworks.openmetadata.enums.StarRating;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RatingRequestBody
extends FeedbackRequestBody {
    private StarRating starRating = null;
    private String review = null;
    private String user = null;

    public RatingRequestBody() {
    }

    public RatingRequestBody(RatingRequestBody template) {
        super(template);
        if (template != null) {
            this.user = template.getUser();
            this.starRating = template.getStarRating();
            this.review = template.getReview();
        }
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public StarRating getStarRating() {
        return this.starRating;
    }

    public void setStarRating(StarRating starRating) {
        this.starRating = starRating;
    }

    public String getReview() {
        return this.review;
    }

    public void setReview(String review) {
        this.review = review;
    }

    @Override
    public String toString() {
        return "RatingRequestBody{starRating=" + this.starRating + ", review='" + this.review + "', user='" + this.user + "', isPublic='" + this.getIsPublic() + "'}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        RatingRequestBody rating = (RatingRequestBody)objectToCompare;
        return this.getStarRating() == rating.getStarRating() && Objects.equals(this.getReview(), rating.getReview()) && Objects.equals(this.getUser(), rating.getUser());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.starRating != null ? this.starRating.hashCode() : 0);
        result = 31 * result + (this.review != null ? this.review.hashCode() : 0);
        result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
        return result;
    }
}

