/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageSet;

public enum AssetConsumerErrorCode implements ExceptionMessageSet
{
    OMRS_NOT_INITIALIZED(404, "OMAS-ASSET-CONSUMER-404-002", "The open metadata repository services are not initialized for the {0} operation", "The system is unable to connect to an open metadata repository.", "Check that the server where the Asset Consumer OMAS is running initialized correctly.  Correct any errors discovered and retry the request when the open metadata services are available."),
    NULL_LISTENER(400, "OMAS-ASSET-CONSUMER-400-017", "A null topic listener has been passed by user {0} on method {1}", "There is a coding error in the caller to the Asset Consumer OMAS.", "Correct the caller logic and retry the request."),
    UNABLE_TO_SEND_EVENT(500, "OMAS-ASSET-CONSUMER-500-004", "An unexpected exception occurred when sending an event through connector {0} to the Asset Consumer OMAS out topic.  The failing event was {1}, the exception was {2} with message {3}", "The access service has issued a call to publish an event on its Out Topic and it failed.", "Look for errors in the event bus to understand why this is failing.  When the event bus is operating correctly, event will begin to be published again.  In the meantime, events are being lost."),
    NULL_CONNECTOR_RETURNED(500, "OMAS-ASSET-CONSUMER-500-006", "The requested connector for connection named {0} has not been created.  The connection was provided by the {1} service running in OMAG Server {2} at {3}", "The system is unable to create a connector which means some of its services will not work.", "This problem is likely to be caused by an incorrect connection object.  Check the settings on the Connectionand correct if necessary.  If the connection is correct, contact the Egeria community for help."),
    WRONG_TYPE_OF_CONNECTOR(500, "OMAS-ASSET-CONSUMER-500-007", "The connector generated from the connection named {0} return by the {1} service running in OMAG Server {2} at {3} is not of the required type. It should be an instance of {4}", "The system is unable to create the required connector which means some of its services will not work.", "Verify that the OMAG server is running and the OMAS service is correctly configured.");

    private final int httpErrorCode;
    private final String errorMessageId;
    private final String errorMessage;
    private final String systemAction;
    private final String userAction;

    private AssetConsumerErrorCode(int httpErrorCode, String errorMessageId, String errorMessage, String systemAction, String userAction) {
        this.httpErrorCode = httpErrorCode;
        this.errorMessageId = errorMessageId;
        this.errorMessage = errorMessage;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public ExceptionMessageDefinition getMessageDefinition() {
        return new ExceptionMessageDefinition(this.httpErrorCode, this.errorMessageId, this.errorMessage, this.systemAction, this.userAction);
    }

    public ExceptionMessageDefinition getMessageDefinition(String ... params) {
        ExceptionMessageDefinition messageDefinition = new ExceptionMessageDefinition(this.httpErrorCode, this.errorMessageId, this.errorMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "ErrorCode{httpErrorCode=" + this.httpErrorCode + ", errorMessageId='" + this.errorMessageId + "', errorMessage='" + this.errorMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

