/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.client;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetconsumer.AssetConsumerInterface;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.AssetConsumerErrorCode;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.AmbiguousConnectionNameException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.AssetConsumerRuntimeException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.NoConnectedAssetException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.NoProfileForUserException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.NotAnAssetException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UnrecognizedConnectionGUIDException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UnrecognizedConnectionNameException;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.Asset;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.AssetCollection;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.AssetCollectionMember;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.AssetCollectionOrder;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.MyProfile;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.AssetConsumerOMASAPIResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.AssetListResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.CommentRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.ConnectionResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.GUIDResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.LogRecordRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.MyProfileRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.MyProfileResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.NullRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.RatingRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.TagRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.VoidResponse;
import org.odpi.openmetadata.accessservices.connectedasset.client.ConnectedAsset;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetUniverse;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectedAssetProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.CommentType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.StarRating;
import org.springframework.web.client.RestTemplate;

public class AssetConsumer
implements AssetConsumerInterface {
    private String omasServerURL;
    private NullRequestBody nullRequestBody = new NullRequestBody();

    public AssetConsumer(String newServerURL) {
        this.omasServerURL = newServerURL;
    }

    private Connector getConnectorForConnection(String userId, Connection requestedConnection, String methodName) throws ConnectionCheckedException, ConnectorCheckedException {
        ConnectorBroker connectorBroker = new ConnectorBroker();
        Connector newConnector = connectorBroker.getConnector(requestedConnection);
        if (newConnector == null) {
            AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.NULL_CONNECTOR_RETURNED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]);
            throw new AssetConsumerRuntimeException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), null);
        }
        try {
            String assetGUID = this.getAssetForConnection(userId, requestedConnection.getGUID());
            org.odpi.openmetadata.accessservices.connectedasset.client.ConnectedAssetProperties connectedAssetProperties = new org.odpi.openmetadata.accessservices.connectedasset.client.ConnectedAssetProperties(userId, this.omasServerURL, newConnector.getConnectorInstanceId(), newConnector.getConnection(), assetGUID);
            newConnector.initializeConnectedAssetProperties((ConnectedAssetProperties)connectedAssetProperties);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return newConnector;
    }

    private Connection getConnectionByName(String userId, String name) throws InvalidParameterException, UnrecognizedConnectionNameException, AmbiguousConnectionNameException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "getConnectionByName";
        String urlTemplate = "/open-metadata/access-services/asset-consumer/users/{0}/connection/by-name/{1}";
        this.validateOMASServerURL("getConnectionByName");
        ConnectionResponse restResult = this.callConnectionGetRESTCall("getConnectionByName", this.omasServerURL + "/open-metadata/access-services/asset-consumer/users/{0}/connection/by-name/{1}", userId, name);
        this.detectAndThrowInvalidParameterException("getConnectionByName", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowUnrecognizedConnectionNameException("getConnectionByName", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowAmbiguousConnectionNameException("getConnectionByName", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("getConnectionByName", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowPropertyServerException("getConnectionByName", (AssetConsumerOMASAPIResponse)restResult);
        return restResult.getConnection();
    }

    @Override
    public Connector getConnectorByName(String userId, String connectionName) throws InvalidParameterException, UnrecognizedConnectionNameException, AmbiguousConnectionNameException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "getConnectorByName";
        String nameParameter = "connectionName";
        this.validateOMASServerURL("getConnectorByName");
        this.validateUserId(userId, "getConnectorByName");
        this.validateName(connectionName, "connectionName", "getConnectorByName");
        return this.getConnectorForConnection(userId, this.getConnectionByName(userId, connectionName), "getConnectorByName");
    }

    private Connection getConnectionByGUID(String userId, String guid) throws InvalidParameterException, UnrecognizedConnectionGUIDException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "getConnectionByGUID";
        String urlTemplate = "/open-metadata/access-services/asset-consumer/users/{0}/connection/{1}";
        this.validateOMASServerURL("getConnectionByGUID");
        ConnectionResponse restResult = this.callConnectionGetRESTCall("getConnectionByGUID", this.omasServerURL + "/open-metadata/access-services/asset-consumer/users/{0}/connection/{1}", userId, guid);
        this.detectAndThrowInvalidParameterException("getConnectionByGUID", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowUnrecognizedConnectionGUIDException("getConnectionByGUID", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("getConnectionByGUID", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowPropertyServerException("getConnectionByGUID", (AssetConsumerOMASAPIResponse)restResult);
        return restResult.getConnection();
    }

    @Override
    public Connector getConnectorByGUID(String userId, String connectionGUID) throws InvalidParameterException, UnrecognizedConnectionGUIDException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "getConnectorByGUID";
        String guidParameter = "connectionGUID";
        this.validateOMASServerURL("getConnectorByGUID");
        this.validateUserId(userId, "getConnectorByGUID");
        this.validateGUID(connectionGUID, "connectionGUID", "getConnectorByGUID");
        return this.getConnectorForConnection(userId, this.getConnectionByGUID(userId, connectionGUID), "getConnectorByGUID");
    }

    @Override
    public Connector getConnectorByConnection(String userId, Connection connection) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException {
        String methodName = "getConnectorByConnection";
        this.validateOMASServerURL("getConnectorByConnection");
        this.validateUserId(userId, "getConnectorByConnection");
        return this.getConnectorForConnection(userId, connection, "getConnectorByConnection");
    }

    @Override
    public MyProfile getMyProfile(String userId) throws InvalidParameterException, NoProfileForUserException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "getMyProfile";
        String urlTemplate = "/open-metadata/access-services/asset-consumer/users/{0}/my-profile";
        this.validateOMASServerURL("getMyProfile");
        this.validateUserId(userId, "getMyProfile");
        MyProfileResponse restResult = this.callMyProfileGetRESTCall("getMyProfile", this.omasServerURL + "/open-metadata/access-services/asset-consumer/users/{0}/my-profile", userId);
        this.detectAndThrowInvalidParameterException("getMyProfile", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowNoProfileForUserException("getMyProfile", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("getMyProfile", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowPropertyServerException("getMyProfile", (AssetConsumerOMASAPIResponse)restResult);
        return null;
    }

    @Override
    public void updateMyProfile(String userId, String employeeNumber, String fullName, String knownName, String jobTitle, String jobRoleDescription, Map<String, Object> additionalProperties) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "updateMyProfile";
        String urlTemplate = "/open-metadata/access-services/asset-consumer/users/{0}/my-profile";
        String employeeNumberParameterName = "employeeNumber";
        String knownNameParameterName = "knownName";
        this.validateOMASServerURL("updateMyProfile");
        this.validateUserId(userId, "updateMyProfile");
        this.validateName(employeeNumber, "employeeNumber", "updateMyProfile");
        this.validateName(knownName, "knownName", "updateMyProfile");
        MyProfileRequestBody requestBody = new MyProfileRequestBody();
        requestBody.setEmployeeNumber(employeeNumber);
        requestBody.setFullName(fullName);
        requestBody.setKnownName(knownName);
        requestBody.setJobTitle(jobTitle);
        requestBody.setJobRoleDescription(jobRoleDescription);
        requestBody.setAdditionalProperties(additionalProperties);
        VoidResponse restResult = this.callVoidPostRESTCall("updateMyProfile", this.omasServerURL + "/open-metadata/access-services/asset-consumer/users/{0}/my-profile", requestBody, userId);
        this.detectAndThrowInvalidParameterException("updateMyProfile", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("updateMyProfile", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowPropertyServerException("updateMyProfile", (AssetConsumerOMASAPIResponse)restResult);
    }

    @Override
    public List<AssetCollection> getMyAssetCollections(String userId, int startFrom, int pageSize) throws InvalidParameterException, NoProfileForUserException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        return null;
    }

    @Override
    public AssetCollection getAssetCollection(String userId, String assetCollectionGUID) throws InvalidParameterException, NoProfileForUserException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        return null;
    }

    @Override
    public AssetCollection createAssetCollection(String userId, String qualifiedName, String displayName, String description, String collectionUse, AssetCollectionOrder assetCollectionOrder, Map<String, Object> additionalProperties) throws InvalidParameterException, NoProfileForUserException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        return null;
    }

    @Override
    public AssetCollection attachAssetCollection(String userId, String assetCollectionGUID) throws InvalidParameterException, NoProfileForUserException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        return null;
    }

    @Override
    public void removeAssetCollection(String userId, String assetCollectionGUID) throws InvalidParameterException, NoProfileForUserException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
    }

    @Override
    public List<AssetCollectionMember> getMyAssets(String userId, String assetCollectionGUID, int startFrom, int pageSize) throws InvalidParameterException, NoProfileForUserException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        return null;
    }

    @Override
    public void addToMyAssets(String userId, String assetCollectionGUID, String assetGUID) throws InvalidParameterException, NoProfileForUserException, NotAnAssetException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
    }

    @Override
    public void removeFromMyAssets(String userId, String assetCollectionGUID, String assetGUID) throws InvalidParameterException, NoProfileForUserException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
    }

    @Override
    public String getAssetForConnection(String userId, String connectionGUID) throws InvalidParameterException, UnrecognizedConnectionGUIDException, NoConnectedAssetException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "getAssetForConnection";
        String urlTemplate = "/open-metadata/access-services/asset-consumer/users/{0}/assets/by-connection/{1}";
        this.validateOMASServerURL("getAssetForConnection");
        GUIDResponse restResult = this.callGUIDGetRESTCall("getAssetForConnection", this.omasServerURL + "/open-metadata/access-services/asset-consumer/users/{0}/assets/by-connection/{1}", userId, connectionGUID);
        this.detectAndThrowInvalidParameterException("getAssetForConnection", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowUnrecognizedConnectionGUIDException("getAssetForConnection", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowNoConnectedAssetException("getAssetForConnection", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("getAssetForConnection", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowPropertyServerException("getAssetForConnection", (AssetConsumerOMASAPIResponse)restResult);
        return restResult.getGUID();
    }

    public List<Asset> getMyAssets(String userId, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "getMyAssets";
        String urlTemplate = "/open-metadata/access-services/asset-consumer/users/{0}/my-assets?startFrom{1}&pageSize={2}";
        this.validateOMASServerURL("getMyAssets");
        this.validateUserId(userId, "getMyAssets");
        AssetListResponse restResult = this.callAssetListGetRESTCall("getMyAssets", this.omasServerURL + "/open-metadata/access-services/asset-consumer/users/{0}/my-assets?startFrom{1}&pageSize={2}", userId, startFrom, pageSize);
        this.detectAndThrowInvalidParameterException("getMyAssets", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("getMyAssets", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowPropertyServerException("getMyAssets", (AssetConsumerOMASAPIResponse)restResult);
        return restResult.getAssets();
    }

    public void addToMyAssets(String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "addToMyAssets";
        String guidParameter = "assetGUID";
        String urlTemplate = "/open-metadata/access-services/asset-consumer/users/{0}/my-assets/{1}";
        this.validateOMASServerURL("addToMyAssets");
        this.validateUserId(userId, "addToMyAssets");
        this.validateGUID(assetGUID, "assetGUID", "addToMyAssets");
        VoidResponse restResult = this.callVoidPostRESTCall("addToMyAssets", this.omasServerURL + "/open-metadata/access-services/asset-consumer/users/{0}/my-assets/{1}", this.nullRequestBody, userId, assetGUID);
        this.detectAndThrowInvalidParameterException("addToMyAssets", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("addToMyAssets", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowPropertyServerException("addToMyAssets", (AssetConsumerOMASAPIResponse)restResult);
    }

    public void removeFromMyAssets(String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "removeFromMyAssets";
        String guidParameter = "assetGUID";
        String urlTemplate = "/open-metadata/access-services/asset-consumer/users/{0}/my-assets/{1}/delete";
        this.validateOMASServerURL("removeFromMyAssets");
        this.validateUserId(userId, "removeFromMyAssets");
        this.validateGUID(assetGUID, "assetGUID", "removeFromMyAssets");
        VoidResponse restResult = this.callVoidPostRESTCall("removeFromMyAssets", this.omasServerURL + "/open-metadata/access-services/asset-consumer/users/{0}/my-assets/{1}/delete", this.nullRequestBody, userId, assetGUID);
        this.detectAndThrowInvalidParameterException("removeFromMyAssets", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("removeFromMyAssets", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowPropertyServerException("removeFromMyAssets", (AssetConsumerOMASAPIResponse)restResult);
    }

    @Override
    public AssetUniverse getAssetProperties(String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "getAssetProperties";
        String guidParameter = "assetGUID";
        this.validateOMASServerURL("getAssetProperties");
        this.validateUserId(userId, "getAssetProperties");
        this.validateGUID(assetGUID, "assetGUID", "getAssetProperties");
        try {
            return new ConnectedAsset(this.omasServerURL, userId, assetGUID);
        }
        catch (UserNotAuthorizedException error) {
            throw new org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException(error.getReportedHTTPCode(), this.getClass().getName(), "getAssetProperties", error.getErrorMessage(), error.getReportedSystemAction(), error.getReportedUserAction(), userId);
        }
        catch (Throwable error) {
            AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.NO_CONNECTED_ASSET;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"getAssetProperties"});
            throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getAssetProperties", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    @Override
    public void addLogMessageToAsset(String userId, String assetGUID, String connectorInstanceId, String connectionName, String connectorType, String contextId, String message) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "addLogMessageToAsset";
        String guidParameter = "assetGUID";
        String urlTemplate = "/open-metadata/access-services/asset-consumer/users/{0}/assets/{1}/log-records";
        this.validateOMASServerURL("addLogMessageToAsset");
        this.validateUserId(userId, "addLogMessageToAsset");
        this.validateGUID(assetGUID, "assetGUID", "addLogMessageToAsset");
        LogRecordRequestBody requestBody = new LogRecordRequestBody();
        requestBody.setConnectorInstanceId(connectorInstanceId);
        requestBody.setConnectionName(connectionName);
        requestBody.setConnectorType(connectorType);
        requestBody.setContextId(contextId);
        requestBody.setMessage(message);
        VoidResponse restResult = this.callVoidPostRESTCall("addLogMessageToAsset", this.omasServerURL + "/open-metadata/access-services/asset-consumer/users/{0}/assets/{1}/log-records", requestBody, userId, assetGUID);
        this.detectAndThrowInvalidParameterException("addLogMessageToAsset", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("addLogMessageToAsset", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowPropertyServerException("addLogMessageToAsset", (AssetConsumerOMASAPIResponse)restResult);
    }

    @Override
    public String addTagToAsset(String userId, String assetGUID, String tagName, String tagDescription) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "addTagToAsset";
        String guidParameter = "assetGUID";
        String nameParameter = "tagName";
        String urlTemplate = "/open-metadata/access-services/asset-consumer/users/{0}/assets/{1}/tags";
        this.validateOMASServerURL("addTagToAsset");
        this.validateUserId(userId, "addTagToAsset");
        this.validateGUID(assetGUID, "assetGUID", "addTagToAsset");
        this.validateName(tagName, "tagName", "addTagToAsset");
        TagRequestBody requestBody = new TagRequestBody();
        requestBody.setTagName(tagName);
        requestBody.setTagDescription(tagDescription);
        GUIDResponse restResult = this.callGUIDPostRESTCall("addTagToAsset", this.omasServerURL + "/open-metadata/access-services/asset-consumer/users/{0}/assets/{1}/tags", requestBody, userId, assetGUID);
        this.detectAndThrowInvalidParameterException("addTagToAsset", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("addTagToAsset", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowPropertyServerException("addTagToAsset", (AssetConsumerOMASAPIResponse)restResult);
        return restResult.getGUID();
    }

    @Override
    public String addPrivateTagToAsset(String userId, String assetGUID, String tagName, String tagDescription) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "addPrivateTagToAsset";
        String guidParameter = "assetGUID";
        String nameParameter = "tagName";
        String urlTemplate = "/open-metadata/access-services/asset-consumer/users/{0}/assets/{1}/tags/private";
        this.validateOMASServerURL("addPrivateTagToAsset");
        this.validateUserId(userId, "addPrivateTagToAsset");
        this.validateGUID(assetGUID, "assetGUID", "addPrivateTagToAsset");
        this.validateName(tagName, "tagName", "addPrivateTagToAsset");
        TagRequestBody requestBody = new TagRequestBody();
        requestBody.setTagName(tagName);
        requestBody.setTagDescription(tagDescription);
        GUIDResponse restResult = this.callGUIDPostRESTCall("addPrivateTagToAsset", this.omasServerURL + "/open-metadata/access-services/asset-consumer/users/{0}/assets/{1}/tags/private", requestBody, userId, assetGUID);
        this.detectAndThrowInvalidParameterException("addPrivateTagToAsset", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("addPrivateTagToAsset", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowPropertyServerException("addPrivateTagToAsset", (AssetConsumerOMASAPIResponse)restResult);
        return restResult.getGUID();
    }

    @Override
    public String addRatingToAsset(String userId, String assetGUID, StarRating starRating, String review) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "addRatingToAsset";
        String guidParameter = "assetGUID";
        String urlTemplate = "/open-metadata/access-services/asset-consumer/users/{0}/assets/{1}/ratings";
        this.validateOMASServerURL("addRatingToAsset");
        this.validateUserId(userId, "addRatingToAsset");
        this.validateGUID(assetGUID, "assetGUID", "addRatingToAsset");
        RatingRequestBody requestBody = new RatingRequestBody();
        requestBody.setStarRating(starRating);
        requestBody.setReview(review);
        GUIDResponse restResult = this.callGUIDPostRESTCall("addRatingToAsset", this.omasServerURL + "/open-metadata/access-services/asset-consumer/users/{0}/assets/{1}/ratings", requestBody, userId, assetGUID);
        this.detectAndThrowInvalidParameterException("addRatingToAsset", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("addRatingToAsset", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowPropertyServerException("addRatingToAsset", (AssetConsumerOMASAPIResponse)restResult);
        return restResult.getGUID();
    }

    @Override
    public String addLikeToAsset(String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "addRatingToAsset";
        String guidParameter = "assetGUID";
        String urlTemplate = "/open-metadata/access-services/asset-consumer/users/{0}/assets/{1}/likes";
        this.validateOMASServerURL("addRatingToAsset");
        this.validateUserId(userId, "addRatingToAsset");
        this.validateGUID(assetGUID, "assetGUID", "addRatingToAsset");
        GUIDResponse restResult = this.callGUIDPostRESTCall("addRatingToAsset", this.omasServerURL + "/open-metadata/access-services/asset-consumer/users/{0}/assets/{1}/likes", this.nullRequestBody, userId, assetGUID);
        this.detectAndThrowInvalidParameterException("addRatingToAsset", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("addRatingToAsset", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowPropertyServerException("addRatingToAsset", (AssetConsumerOMASAPIResponse)restResult);
        return restResult.getGUID();
    }

    @Override
    public String addCommentToAsset(String userId, String assetGUID, CommentType commentType, String commentText) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "addCommentToAsset";
        String guidParameter = "assetGUID";
        String urlTemplate = "/open-metadata/access-services/asset-consumer/users/{0}/assets/{1}/comments";
        this.validateOMASServerURL("addCommentToAsset");
        this.validateUserId(userId, "addCommentToAsset");
        this.validateGUID(assetGUID, "assetGUID", "addCommentToAsset");
        CommentRequestBody requestBody = new CommentRequestBody();
        requestBody.setCommentType(commentType);
        requestBody.setCommentText(commentText);
        GUIDResponse restResult = this.callGUIDPostRESTCall("addCommentToAsset", this.omasServerURL + "/open-metadata/access-services/asset-consumer/users/{0}/assets/{1}/comments", requestBody, userId, assetGUID);
        this.detectAndThrowInvalidParameterException("addCommentToAsset", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("addCommentToAsset", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowPropertyServerException("addCommentToAsset", (AssetConsumerOMASAPIResponse)restResult);
        return restResult.getGUID();
    }

    @Override
    public String addCommentReply(String userId, String commentGUID, CommentType commentType, String commentText) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "addCommentReply";
        String commentGUIDParameter = "commentGUID";
        String urlTemplate = "/open-metadata/access-services/asset-consumer/users/{0}/comments/{1}/replies";
        this.validateOMASServerURL("addCommentReply");
        this.validateUserId(userId, "addCommentReply");
        this.validateGUID(commentGUID, "commentGUID", "addCommentReply");
        CommentRequestBody requestBody = new CommentRequestBody();
        requestBody.setCommentType(commentType);
        requestBody.setCommentText(commentText);
        GUIDResponse restResult = this.callGUIDPostRESTCall("addCommentReply", this.omasServerURL + "/open-metadata/access-services/asset-consumer/users/{0}/comments/{1}/replies", requestBody, userId, commentGUID);
        this.detectAndThrowInvalidParameterException("addCommentReply", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("addCommentReply", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowPropertyServerException("addCommentReply", (AssetConsumerOMASAPIResponse)restResult);
        return restResult.getGUID();
    }

    @Override
    public void removeTag(String userId, String tagGUID) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "removeTag";
        String guidParameter = "tagGUID";
        String urlTemplate = "/open-metadata/access-services/asset-consumer/users/{0}/tags/{guid}/delete";
        this.validateOMASServerURL("removeTag");
        this.validateUserId(userId, "removeTag");
        this.validateGUID(tagGUID, "tagGUID", "removeTag");
        VoidResponse restResult = this.callVoidPostRESTCall("removeTag", this.omasServerURL + "/open-metadata/access-services/asset-consumer/users/{0}/tags/{guid}/delete", this.nullRequestBody, userId, tagGUID);
        this.detectAndThrowInvalidParameterException("removeTag", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("removeTag", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowPropertyServerException("removeTag", (AssetConsumerOMASAPIResponse)restResult);
    }

    @Override
    public void removePrivateTag(String userId, String tagGUID) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "removePrivateTag";
        String guidParameter = "tagGUID";
        String urlTemplate = "/open-metadata/access-services/asset-consumer/users/{0}/tags/private/{guid}/delete";
        this.validateOMASServerURL("removePrivateTag");
        this.validateUserId(userId, "removePrivateTag");
        this.validateGUID(tagGUID, "tagGUID", "removePrivateTag");
        VoidResponse restResult = this.callVoidPostRESTCall("removePrivateTag", this.omasServerURL + "/open-metadata/access-services/asset-consumer/users/{0}/tags/private/{guid}/delete", this.nullRequestBody, userId, tagGUID);
        this.detectAndThrowInvalidParameterException("removePrivateTag", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("removePrivateTag", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowPropertyServerException("removePrivateTag", (AssetConsumerOMASAPIResponse)restResult);
    }

    @Override
    public void removeRating(String userId, String ratingGUID) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "removeRating";
        String guidParameter = "ratingGUID";
        String urlTemplate = "/open-metadata/access-services/asset-consumer/users/{0}/ratings/{guid}/delete";
        this.validateOMASServerURL("removeRating");
        this.validateUserId(userId, "removeRating");
        this.validateGUID(ratingGUID, "ratingGUID", "removeRating");
        VoidResponse restResult = this.callVoidPostRESTCall("removeRating", this.omasServerURL + "/open-metadata/access-services/asset-consumer/users/{0}/ratings/{guid}/delete", this.nullRequestBody, userId, ratingGUID);
        this.detectAndThrowInvalidParameterException("removeRating", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("removeRating", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowPropertyServerException("removeRating", (AssetConsumerOMASAPIResponse)restResult);
    }

    @Override
    public void removeLike(String userId, String likeGUID) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "removeLike";
        String guidParameter = "likeGUID";
        String urlTemplate = "/open-metadata/access-services/asset-consumer/users/{0}/likes/{guid}/delete";
        this.validateOMASServerURL("removeLike");
        this.validateUserId(userId, "removeLike");
        this.validateGUID(likeGUID, "likeGUID", "removeLike");
        VoidResponse restResult = this.callVoidPostRESTCall("removeLike", this.omasServerURL + "/open-metadata/access-services/asset-consumer/users/{0}/likes/{guid}/delete", this.nullRequestBody, userId, likeGUID);
        this.detectAndThrowInvalidParameterException("removeLike", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("removeLike", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowPropertyServerException("removeLike", (AssetConsumerOMASAPIResponse)restResult);
    }

    @Override
    public void removeComment(String userId, String commentGUID) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "removeComment";
        String guidParameter = "commentGUID";
        String urlTemplate = "/open-metadata/access-services/asset-consumer/users/{0}/comments/{guid}/delete";
        this.validateOMASServerURL("removeComment");
        this.validateUserId(userId, "removeComment");
        this.validateGUID(commentGUID, "commentGUID", "removeComment");
        VoidResponse restResult = this.callVoidPostRESTCall("removeComment", this.omasServerURL + "/open-metadata/access-services/asset-consumer/users/{0}/comments/{guid}/delete", this.nullRequestBody, userId, commentGUID);
        this.detectAndThrowInvalidParameterException("removeComment", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("removeComment", (AssetConsumerOMASAPIResponse)restResult);
        this.detectAndThrowPropertyServerException("removeComment", (AssetConsumerOMASAPIResponse)restResult);
    }

    private void validateOMASServerURL(String methodName) throws PropertyServerException {
        if (this.omasServerURL == null) {
            AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.SERVER_URL_NOT_SPECIFIED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]);
            throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    private void validateUserId(String userId, String methodName) throws InvalidParameterException {
        if (userId == null) {
            AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.NULL_USER_ID;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "userId");
        }
    }

    private void validateGUID(String guid, String guidParameter, String methodName) throws InvalidParameterException {
        if (guid == null) {
            AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.NULL_GUID;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{guidParameter, methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), guidParameter);
        }
    }

    private void validateName(String name, String nameParameter, String methodName) throws InvalidParameterException {
        if (name == null) {
            AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.NULL_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{nameParameter, methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), nameParameter);
        }
    }

    private ConnectionResponse callConnectionGetRESTCall(String methodName, String urlTemplate, Object ... params) throws PropertyServerException {
        return (ConnectionResponse)this.callGetRESTCall(methodName, GUIDResponse.class, urlTemplate, params);
    }

    private MyProfileResponse callMyProfileGetRESTCall(String methodName, String urlTemplate, Object ... params) throws PropertyServerException {
        return (MyProfileResponse)this.callGetRESTCall(methodName, MyProfileResponse.class, urlTemplate, params);
    }

    private GUIDResponse callGUIDGetRESTCall(String methodName, String urlTemplate, Object ... params) throws PropertyServerException {
        return (GUIDResponse)this.callGetRESTCall(methodName, GUIDResponse.class, urlTemplate, params);
    }

    private AssetListResponse callAssetListGetRESTCall(String methodName, String urlTemplate, Object ... params) throws PropertyServerException {
        return (AssetListResponse)this.callGetRESTCall(methodName, AssetListResponse.class, urlTemplate, params);
    }

    private Object callGetRESTCall(String methodName, Class returnClass, String urlTemplate, Object ... params) throws PropertyServerException {
        try {
            RestTemplate restTemplate = new RestTemplate();
            return restTemplate.getForObject(urlTemplate, returnClass, params);
        }
        catch (Throwable error) {
            AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.CLIENT_SIDE_REST_API_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, this.omasServerURL, error.getMessage()});
            throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }

    private GUIDResponse callGUIDPostRESTCall(String methodName, String urlTemplate, Object requestBody, Object ... params) throws PropertyServerException {
        return (GUIDResponse)this.callPostRESTCall(methodName, GUIDResponse.class, urlTemplate, requestBody, params);
    }

    private VoidResponse callVoidPostRESTCall(String methodName, String urlTemplate, Object requestBody, Object ... params) throws PropertyServerException {
        return (VoidResponse)this.callPostRESTCall(methodName, VoidResponse.class, urlTemplate, requestBody, params);
    }

    private Object callPostRESTCall(String methodName, Class returnClass, String urlTemplate, Object requestBody, Object ... params) throws PropertyServerException {
        try {
            RestTemplate restTemplate = new RestTemplate();
            return restTemplate.postForObject(urlTemplate, requestBody, returnClass, params);
        }
        catch (Throwable error) {
            AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.CLIENT_SIDE_REST_API_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, this.omasServerURL, error.getMessage()});
            throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }

    private void detectAndThrowAmbiguousConnectionNameException(String methodName, AssetConsumerOMASAPIResponse restResult) throws AmbiguousConnectionNameException {
        String exceptionClassName = AmbiguousConnectionNameException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            Object nameObject;
            String connectionName = null;
            Map exceptionProperties = restResult.getExceptionProperties();
            if (exceptionProperties != null && (nameObject = exceptionProperties.get("connectionName")) != null) {
                connectionName = (String)nameObject;
            }
            throw new AmbiguousConnectionNameException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), connectionName);
        }
    }

    private void detectAndThrowInvalidParameterException(String methodName, AssetConsumerOMASAPIResponse restResult) throws InvalidParameterException {
        String exceptionClassName = InvalidParameterException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            Object nameObject;
            String paramName = null;
            Map exceptionProperties = restResult.getExceptionProperties();
            if (exceptionProperties != null && (nameObject = exceptionProperties.get("parameterName")) != null) {
                paramName = (String)nameObject;
            }
            throw new InvalidParameterException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), paramName);
        }
    }

    private void detectAndThrowPropertyServerException(String methodName, AssetConsumerOMASAPIResponse restResult) throws PropertyServerException {
        String exceptionClassName = PropertyServerException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            throw new PropertyServerException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction());
        }
    }

    private void detectAndThrowUnrecognizedConnectionGUIDException(String methodName, AssetConsumerOMASAPIResponse restResult) throws UnrecognizedConnectionGUIDException {
        String exceptionClassName = UnrecognizedConnectionGUIDException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            Object guidObject;
            String connectionGUID = null;
            Map exceptionProperties = restResult.getExceptionProperties();
            if (exceptionProperties != null && (guidObject = exceptionProperties.get("connectionGUID")) != null) {
                connectionGUID = (String)guidObject;
            }
            throw new UnrecognizedConnectionGUIDException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), connectionGUID);
        }
    }

    private void detectAndThrowNoConnectedAssetException(String methodName, AssetConsumerOMASAPIResponse restResult) throws NoConnectedAssetException {
        String exceptionClassName = UnrecognizedConnectionGUIDException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            Object guidObject;
            String connectionGUID = null;
            Map exceptionProperties = restResult.getExceptionProperties();
            if (exceptionProperties != null && (guidObject = exceptionProperties.get("connectionGUID")) != null) {
                connectionGUID = (String)guidObject;
            }
            throw new NoConnectedAssetException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), connectionGUID);
        }
    }

    private void detectAndThrowUnrecognizedConnectionNameException(String methodName, AssetConsumerOMASAPIResponse restResult) throws UnrecognizedConnectionNameException {
        String exceptionClassName = UnrecognizedConnectionNameException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            Object nameObject;
            String connectionName = null;
            Map exceptionProperties = restResult.getExceptionProperties();
            if (exceptionProperties != null && (nameObject = exceptionProperties.get("connectionName")) != null) {
                connectionName = (String)nameObject;
            }
            throw new UnrecognizedConnectionNameException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), connectionName);
        }
    }

    private void detectAndThrowNoProfileForUserException(String methodName, AssetConsumerOMASAPIResponse restResult) throws NoProfileForUserException {
        String exceptionClassName = org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            Object userIdObject;
            String userId = null;
            Map exceptionProperties = restResult.getExceptionProperties();
            if (exceptionProperties != null && (userIdObject = exceptionProperties.get("userId")) != null) {
                userId = (String)userIdObject;
            }
            throw new NoProfileForUserException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), userId);
        }
    }

    private void detectAndThrowUserNotAuthorizedException(String methodName, AssetConsumerOMASAPIResponse restResult) throws org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String exceptionClassName = org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            Object userIdObject;
            String userId = null;
            Map exceptionProperties = restResult.getExceptionProperties();
            if (exceptionProperties != null && (userIdObject = exceptionProperties.get("userId")) != null) {
                userId = (String)userIdObject;
            }
            throw new org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), userId);
        }
    }
}

