/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetconsumer.AssetConsumerAssetInterface;
import org.odpi.openmetadata.accessservices.assetconsumer.AssetConsumerConnectorFactoryInterface;
import org.odpi.openmetadata.accessservices.assetconsumer.AssetConsumerFeedbackInterface;
import org.odpi.openmetadata.accessservices.assetconsumer.AssetConsumerGlossaryInterface;
import org.odpi.openmetadata.accessservices.assetconsumer.AssetConsumerLoggingInterface;
import org.odpi.openmetadata.accessservices.assetconsumer.AssetConsumerTaggingInterface;
import org.odpi.openmetadata.accessservices.assetconsumer.client.InvalidParameterHandler;
import org.odpi.openmetadata.accessservices.assetconsumer.client.RESTClient;
import org.odpi.openmetadata.accessservices.assetconsumer.client.RESTExceptionHandler;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.AssetConsumerErrorCode;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.AmbiguousConnectionNameException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.AssetConsumerRuntimeException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.NoConnectedAssetException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.GlossaryTerm;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.Tag;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.AssetConsumerOMASAPIResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.CommentRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.ConnectionResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.GUIDResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.LogRecordRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.MeaningListResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.MeaningResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.NullRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.ReviewRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.TagListResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.TagRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.TagResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.VoidResponse;
import org.odpi.openmetadata.accessservices.connectedasset.client.ConnectedAssetProperties;
import org.odpi.openmetadata.accessservices.connectedasset.client.ConnectedAssetUniverse;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetUniverse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.CommentType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.StarRating;

public class AssetConsumer
implements AssetConsumerAssetInterface,
AssetConsumerConnectorFactoryInterface,
AssetConsumerFeedbackInterface,
AssetConsumerGlossaryInterface,
AssetConsumerLoggingInterface,
AssetConsumerTaggingInterface {
    private String serverName;
    private String omasServerURL;
    private RESTClient restClient;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private RESTExceptionHandler exceptionHandler = new RESTExceptionHandler();
    private NullRequestBody nullRequestBody = new NullRequestBody();

    public AssetConsumer(String serverName, String newServerURL) {
        this.serverName = serverName;
        this.omasServerURL = newServerURL;
        this.restClient = new RESTClient(serverName, this.omasServerURL);
    }

    public AssetConsumer(String serverName, String omasServerURL, String userId, String password) {
        this.serverName = serverName;
        this.omasServerURL = omasServerURL;
        this.restClient = new RESTClient(serverName, omasServerURL, userId, password);
    }

    public String getAssetForConnection(String userId, String connectionGUID) throws InvalidParameterException, NoConnectedAssetException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "getAssetForConnection";
        String guidParameter = "connectionGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/by-connection/{2}";
        this.invalidParameterHandler.validateOMASServerURL(this.omasServerURL, "getAssetForConnection");
        this.invalidParameterHandler.validateUserId(userId, "getAssetForConnection");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "getAssetForConnection");
        GUIDResponse restResult = this.restClient.callGUIDGetRESTCall("getAssetForConnection", this.omasServerURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/by-connection/{2}", this.serverName, userId, connectionGUID);
        this.exceptionHandler.detectAndThrowInvalidParameterException("getAssetForConnection", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowNoConnectedAssetException("getAssetForConnection", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getAssetForConnection", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getAssetForConnection", (AssetConsumerOMASAPIResponse)restResult);
        return restResult.getGUID();
    }

    public String getAssetForConnectionName(String userId, String connectionName) throws InvalidParameterException, AmbiguousConnectionNameException, NoConnectedAssetException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "getAssetForConnectionName";
        String nameParameter = "connectionName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/by-connection-name/{2}";
        this.invalidParameterHandler.validateOMASServerURL(this.omasServerURL, "getAssetForConnectionName");
        this.invalidParameterHandler.validateUserId(userId, "getAssetForConnectionName");
        this.invalidParameterHandler.validateName(connectionName, "connectionName", "getAssetForConnectionName");
        GUIDResponse restResult = this.restClient.callGUIDGetRESTCall("getAssetForConnectionName", this.omasServerURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/by-connection-name/{2}", this.serverName, userId, connectionName);
        this.exceptionHandler.detectAndThrowAmbiguousConnectionNameException("getAssetForConnectionName", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowInvalidParameterException("getAssetForConnectionName", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowNoConnectedAssetException("getAssetForConnectionName", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getAssetForConnectionName", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getAssetForConnectionName", (AssetConsumerOMASAPIResponse)restResult);
        return restResult.getGUID();
    }

    public AssetUniverse getAssetProperties(String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "getExtendedProperties";
        String guidParameter = "assetGUID";
        this.invalidParameterHandler.validateOMASServerURL(this.omasServerURL, "getExtendedProperties");
        this.invalidParameterHandler.validateUserId(userId, "getExtendedProperties");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "getExtendedProperties");
        try {
            return new ConnectedAssetUniverse(this.serverName, this.omasServerURL, userId, assetGUID);
        }
        catch (UserNotAuthorizedException error) {
            throw new org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException(error.getReportedHTTPCode(), this.getClass().getName(), "getExtendedProperties", error.getErrorMessage(), error.getReportedSystemAction(), error.getReportedUserAction(), userId);
        }
        catch (Throwable error) {
            AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.NO_ASSET_PROPERTIES;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"getExtendedProperties"});
            throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getExtendedProperties", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    private Connector getConnectorForConnection(String userId, Connection requestedConnection, String methodName) throws ConnectionCheckedException, ConnectorCheckedException {
        ConnectorBroker connectorBroker = new ConnectorBroker();
        Connector newConnector = connectorBroker.getConnector(requestedConnection);
        if (newConnector == null) {
            AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.NULL_CONNECTOR_RETURNED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]);
            throw new AssetConsumerRuntimeException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), null);
        }
        try {
            String assetGUID = this.getAssetForConnection(userId, requestedConnection.getGUID());
            ConnectedAssetProperties connectedAssetProperties = new ConnectedAssetProperties(this.serverName, userId, this.omasServerURL, newConnector.getConnectorInstanceId(), newConnector.getConnection(), assetGUID);
            newConnector.initializeConnectedAssetProperties((org.odpi.openmetadata.frameworks.connectors.properties.ConnectedAssetProperties)connectedAssetProperties);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return newConnector;
    }

    private Connection getConnectionByName(String userId, String name) throws InvalidParameterException, AmbiguousConnectionNameException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "getConnectionByName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/connections/by-name/{2}";
        this.invalidParameterHandler.validateOMASServerURL(this.omasServerURL, "getConnectionByName");
        ConnectionResponse restResult = this.restClient.callConnectionGetRESTCall("getConnectionByName", this.omasServerURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/connections/by-name/{2}", this.serverName, userId, name);
        this.exceptionHandler.detectAndThrowInvalidParameterException("getConnectionByName", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowAmbiguousConnectionNameException("getConnectionByName", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getConnectionByName", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getConnectionByName", (AssetConsumerOMASAPIResponse)restResult);
        return restResult.getConnection();
    }

    public Connector getConnectorByName(String userId, String connectionName) throws InvalidParameterException, AmbiguousConnectionNameException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "getConnectorByName";
        String nameParameter = "connectionName";
        this.invalidParameterHandler.validateOMASServerURL(this.omasServerURL, "getConnectorByName");
        this.invalidParameterHandler.validateUserId(userId, "getConnectorByName");
        this.invalidParameterHandler.validateName(connectionName, "connectionName", "getConnectorByName");
        return this.getConnectorForConnection(userId, this.getConnectionByName(userId, connectionName), "getConnectorByName");
    }

    private Connection getConnectionByGUID(String userId, String guid) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "getConnectionByGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/connections/{2}";
        this.invalidParameterHandler.validateOMASServerURL(this.omasServerURL, "getConnectionByGUID");
        ConnectionResponse restResult = this.restClient.callConnectionGetRESTCall("getConnectionByGUID", this.omasServerURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/connections/{2}", this.serverName, userId, guid);
        this.exceptionHandler.detectAndThrowInvalidParameterException("getConnectionByGUID", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getConnectionByGUID", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getConnectionByGUID", (AssetConsumerOMASAPIResponse)restResult);
        return restResult.getConnection();
    }

    public Connector getConnectorByGUID(String userId, String connectionGUID) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "getConnectorByGUID";
        String guidParameter = "connectionGUID";
        this.invalidParameterHandler.validateOMASServerURL(this.omasServerURL, "getConnectorByGUID");
        this.invalidParameterHandler.validateUserId(userId, "getConnectorByGUID");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "getConnectorByGUID");
        return this.getConnectorForConnection(userId, this.getConnectionByGUID(userId, connectionGUID), "getConnectorByGUID");
    }

    public Connector getConnectorByConnection(String userId, Connection connection) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException {
        String methodName = "getConnectorByConnection";
        this.invalidParameterHandler.validateOMASServerURL(this.omasServerURL, "getConnectorByConnection");
        this.invalidParameterHandler.validateUserId(userId, "getConnectorByConnection");
        return this.getConnectorForConnection(userId, connection, "getConnectorByConnection");
    }

    public String addReviewToAsset(String userId, String assetGUID, StarRating starRating, String review) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "addReviewToAsset";
        String guidParameter = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/reviews";
        this.invalidParameterHandler.validateOMASServerURL(this.omasServerURL, "addReviewToAsset");
        this.invalidParameterHandler.validateUserId(userId, "addReviewToAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addReviewToAsset");
        ReviewRequestBody requestBody = new ReviewRequestBody();
        requestBody.setStarRating(starRating);
        requestBody.setReview(review);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("addReviewToAsset", this.omasServerURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/reviews", requestBody, this.serverName, userId, assetGUID);
        this.exceptionHandler.detectAndThrowInvalidParameterException("addReviewToAsset", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("addReviewToAsset", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("addReviewToAsset", (AssetConsumerOMASAPIResponse)restResult);
        return restResult.getGUID();
    }

    public void updateReviewOnAsset(String userId, String reviewGUID, StarRating starRating, String review) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "updateReviewOnAsset";
        String guidParameter = "reviewGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/reviews/{2}/update";
        this.invalidParameterHandler.validateOMASServerURL(this.omasServerURL, "updateReviewOnAsset");
        this.invalidParameterHandler.validateUserId(userId, "updateReviewOnAsset");
        this.invalidParameterHandler.validateGUID(reviewGUID, "reviewGUID", "updateReviewOnAsset");
        ReviewRequestBody requestBody = new ReviewRequestBody();
        requestBody.setStarRating(starRating);
        requestBody.setReview(review);
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("updateReviewOnAsset", this.omasServerURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/reviews/{2}/update", requestBody, this.serverName, userId, reviewGUID);
        this.exceptionHandler.detectAndThrowInvalidParameterException("updateReviewOnAsset", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("updateReviewOnAsset", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("updateReviewOnAsset", (AssetConsumerOMASAPIResponse)restResult);
    }

    public void removeReviewFromAsset(String userId, String reviewGUID) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "removeReviewFromAsset";
        String guidParameter = "reviewGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/reviews/{2}/delete";
        this.invalidParameterHandler.validateOMASServerURL(this.omasServerURL, "removeReviewFromAsset");
        this.invalidParameterHandler.validateUserId(userId, "removeReviewFromAsset");
        this.invalidParameterHandler.validateGUID(reviewGUID, "reviewGUID", "removeReviewFromAsset");
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("removeReviewFromAsset", this.omasServerURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/reviews/{2}/delete", this.nullRequestBody, this.serverName, userId, reviewGUID);
        this.exceptionHandler.detectAndThrowInvalidParameterException("removeReviewFromAsset", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("removeReviewFromAsset", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("removeReviewFromAsset", (AssetConsumerOMASAPIResponse)restResult);
    }

    public String addLikeToAsset(String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "addLikeToAsset";
        String guidParameter = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/likes";
        this.invalidParameterHandler.validateOMASServerURL(this.omasServerURL, "addLikeToAsset");
        this.invalidParameterHandler.validateUserId(userId, "addLikeToAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addLikeToAsset");
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("addLikeToAsset", this.omasServerURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/likes", this.nullRequestBody, this.serverName, userId, assetGUID);
        this.exceptionHandler.detectAndThrowInvalidParameterException("addLikeToAsset", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("addLikeToAsset", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("addLikeToAsset", (AssetConsumerOMASAPIResponse)restResult);
        return restResult.getGUID();
    }

    public void removeLikeFromAsset(String userId, String likeGUID) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "removeLikeFromAsset";
        String guidParameter = "likeGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/likes/{2}/delete";
        this.invalidParameterHandler.validateOMASServerURL(this.omasServerURL, "removeLikeFromAsset");
        this.invalidParameterHandler.validateUserId(userId, "removeLikeFromAsset");
        this.invalidParameterHandler.validateGUID(likeGUID, "likeGUID", "removeLikeFromAsset");
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("removeLikeFromAsset", this.omasServerURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/likes/{2}/delete", this.nullRequestBody, this.serverName, userId, likeGUID);
        this.exceptionHandler.detectAndThrowInvalidParameterException("removeLikeFromAsset", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("removeLikeFromAsset", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("removeLikeFromAsset", (AssetConsumerOMASAPIResponse)restResult);
    }

    public String addCommentToAsset(String userId, String assetGUID, CommentType commentType, String commentText) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "addCommentToAsset";
        String guidParameter = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/comments";
        this.invalidParameterHandler.validateOMASServerURL(this.omasServerURL, "addCommentToAsset");
        this.invalidParameterHandler.validateUserId(userId, "addCommentToAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addCommentToAsset");
        CommentRequestBody requestBody = new CommentRequestBody();
        requestBody.setCommentType(commentType);
        requestBody.setCommentText(commentText);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("addCommentToAsset", this.omasServerURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/comments", requestBody, this.serverName, userId, assetGUID);
        this.exceptionHandler.detectAndThrowInvalidParameterException("addCommentToAsset", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("addCommentToAsset", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("addCommentToAsset", (AssetConsumerOMASAPIResponse)restResult);
        return restResult.getGUID();
    }

    public String addCommentReply(String userId, String commentGUID, CommentType commentType, String commentText) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "addCommentReply";
        String commentGUIDParameter = "commentGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/comments/{2}/replies";
        this.invalidParameterHandler.validateOMASServerURL(this.omasServerURL, "addCommentReply");
        this.invalidParameterHandler.validateUserId(userId, "addCommentReply");
        this.invalidParameterHandler.validateGUID(commentGUID, "commentGUID", "addCommentReply");
        CommentRequestBody requestBody = new CommentRequestBody();
        requestBody.setCommentType(commentType);
        requestBody.setCommentText(commentText);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("addCommentReply", this.omasServerURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/comments/{2}/replies", requestBody, this.serverName, userId, commentGUID);
        this.exceptionHandler.detectAndThrowInvalidParameterException("addCommentReply", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("addCommentReply", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("addCommentReply", (AssetConsumerOMASAPIResponse)restResult);
        return restResult.getGUID();
    }

    public void updateComment(String userId, String commentGUID, CommentType commentType, String commentText) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "updateComment";
        String commentGUIDParameter = "commentGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/comments/{2}/update";
        this.invalidParameterHandler.validateOMASServerURL(this.omasServerURL, "updateComment");
        this.invalidParameterHandler.validateUserId(userId, "updateComment");
        this.invalidParameterHandler.validateGUID(commentGUID, "commentGUID", "updateComment");
        CommentRequestBody requestBody = new CommentRequestBody();
        requestBody.setCommentType(commentType);
        requestBody.setCommentText(commentText);
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("updateComment", this.omasServerURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/comments/{2}/update", requestBody, this.serverName, userId, commentGUID);
        this.exceptionHandler.detectAndThrowInvalidParameterException("updateComment", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("updateComment", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("updateComment", (AssetConsumerOMASAPIResponse)restResult);
    }

    public void removeCommentFromAsset(String userId, String commentGUID) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "removeCommentFromAsset";
        String guidParameter = "commentGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/comments/{2}/delete";
        this.invalidParameterHandler.validateOMASServerURL(this.omasServerURL, "removeCommentFromAsset");
        this.invalidParameterHandler.validateUserId(userId, "removeCommentFromAsset");
        this.invalidParameterHandler.validateGUID(commentGUID, "commentGUID", "removeCommentFromAsset");
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("removeCommentFromAsset", this.omasServerURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/comments/{2}/delete", this.nullRequestBody, this.serverName, userId, commentGUID);
        this.exceptionHandler.detectAndThrowInvalidParameterException("removeCommentFromAsset", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("removeCommentFromAsset", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("removeCommentFromAsset", (AssetConsumerOMASAPIResponse)restResult);
    }

    public GlossaryTerm getMeaning(String userId, String guid) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "getMeaning";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/meanings/{2}";
        String guidParameter = "guid";
        this.invalidParameterHandler.validateOMASServerURL(this.omasServerURL, "getMeaning");
        this.invalidParameterHandler.validateUserId(userId, "getMeaning");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getMeaning");
        MeaningResponse restResult = this.restClient.callMeaningGetRESTCall("getMeaning", this.omasServerURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/meanings/{2}", this.serverName, userId, guid);
        this.exceptionHandler.detectAndThrowInvalidParameterException("getMeaning", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getMeaning", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getMeaning", (AssetConsumerOMASAPIResponse)restResult);
        return restResult.getGlossaryTerm();
    }

    public List<GlossaryTerm> getMeaningByName(String userId, String term, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "getMeaningByName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/meanings/by-name/{2}?elementStart={3}&maxElements={4}";
        String nameParameter = "term";
        this.invalidParameterHandler.validateOMASServerURL(this.omasServerURL, "getMeaningByName");
        this.invalidParameterHandler.validateUserId(userId, "getMeaningByName");
        this.invalidParameterHandler.validateName(term, "term", "getMeaningByName");
        MeaningListResponse restResult = this.restClient.callMeaningListGetRESTCall("getMeaningByName", this.omasServerURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/meanings/by-name/{2}?elementStart={3}&maxElements={4}", this.serverName, userId, term, startFrom, pageSize);
        this.exceptionHandler.detectAndThrowInvalidParameterException("getMeaningByName", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getMeaningByName", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getMeaningByName", (AssetConsumerOMASAPIResponse)restResult);
        return restResult.getMeanings();
    }

    public void addLogMessageToAsset(String userId, String assetGUID, String connectorInstanceId, String connectionName, String connectorType, String contextId, String message) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "addLogMessageToAsset";
        String guidParameter = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/log-records";
        this.invalidParameterHandler.validateOMASServerURL(this.omasServerURL, "addLogMessageToAsset");
        this.invalidParameterHandler.validateUserId(userId, "addLogMessageToAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addLogMessageToAsset");
        LogRecordRequestBody requestBody = new LogRecordRequestBody();
        requestBody.setConnectorInstanceId(connectorInstanceId);
        requestBody.setConnectionName(connectionName);
        requestBody.setConnectorType(connectorType);
        requestBody.setContextId(contextId);
        requestBody.setMessage(message);
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("addLogMessageToAsset", this.omasServerURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/log-records", requestBody, this.serverName, userId, assetGUID);
        this.exceptionHandler.detectAndThrowInvalidParameterException("addLogMessageToAsset", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("addLogMessageToAsset", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("addLogMessageToAsset", (AssetConsumerOMASAPIResponse)restResult);
    }

    private String createTag(String urlTemplate, String methodName, String userId, String tagName, String tagDescription) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        this.invalidParameterHandler.validateOMASServerURL(this.omasServerURL, methodName);
        this.invalidParameterHandler.validateUserId(userId, methodName);
        TagRequestBody tagRequestBody = new TagRequestBody();
        tagRequestBody.setTagName(tagName);
        tagRequestBody.setTagDescription(tagDescription);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall(methodName, this.omasServerURL + urlTemplate, tagRequestBody, this.serverName, userId);
        this.exceptionHandler.detectAndThrowInvalidParameterException(methodName, (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException(methodName, (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException(methodName, (AssetConsumerOMASAPIResponse)restResult);
        return restResult.getGUID();
    }

    public String createPublicTag(String userId, String tagName, String tagDescription) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "createPublicTag";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/tags/public";
        return this.createTag("/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/tags/public", "createPublicTag", userId, tagName, tagDescription);
    }

    public String createPrivateTag(String userId, String tagName, String tagDescription) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "createPrivateTag";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/tags/private";
        return this.createTag("/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/tags/private", "createPrivateTag", userId, tagName, tagDescription);
    }

    public void updateTagDescription(String userId, String tagGUID, String tagDescription) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "updateTagDescription";
        String guidParameter = "tagGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/tags/{2}/update";
        this.invalidParameterHandler.validateOMASServerURL(this.omasServerURL, "updateTagDescription");
        this.invalidParameterHandler.validateUserId(userId, "updateTagDescription");
        this.invalidParameterHandler.validateGUID(tagGUID, "tagGUID", "updateTagDescription");
        TagRequestBody tagRequestBody = new TagRequestBody();
        tagRequestBody.setTagDescription(tagDescription);
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("updateTagDescription", this.omasServerURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/tags/{2}/update", tagRequestBody, this.serverName, userId, tagGUID);
        this.exceptionHandler.detectAndThrowInvalidParameterException("updateTagDescription", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("updateTagDescription", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("updateTagDescription", (AssetConsumerOMASAPIResponse)restResult);
    }

    public void deleteTag(String userId, String tagGUID) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "deleteTag";
        String guidParameter = "tagGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/tags/{2}/delete";
        this.invalidParameterHandler.validateOMASServerURL(this.omasServerURL, "deleteTag");
        this.invalidParameterHandler.validateUserId(userId, "deleteTag");
        this.invalidParameterHandler.validateGUID(tagGUID, "tagGUID", "deleteTag");
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("deleteTag", this.omasServerURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/tags/{2}/delete", this.nullRequestBody, this.serverName, userId, tagGUID);
        this.exceptionHandler.detectAndThrowInvalidParameterException("deleteTag", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("deleteTag", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("deleteTag", (AssetConsumerOMASAPIResponse)restResult);
    }

    public Tag getTag(String userId, String guid) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "getTag";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/tags/{2}";
        String guidParameter = "guid";
        this.invalidParameterHandler.validateOMASServerURL(this.omasServerURL, "getTag");
        this.invalidParameterHandler.validateUserId(userId, "getTag");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getTag");
        TagResponse restResult = this.restClient.callTagGetRESTCall("getTag", this.omasServerURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/tags/{2}", this.serverName, userId, guid);
        this.exceptionHandler.detectAndThrowInvalidParameterException("getTag", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getTag", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getTag", (AssetConsumerOMASAPIResponse)restResult);
        return restResult.getTag();
    }

    public List<Tag> getTagsByName(String userId, String tag, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "getTagsByName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/tags/by-name/{2}?elementStart={3}&maxElements={4}";
        String nameParameter = "tag";
        this.invalidParameterHandler.validateOMASServerURL(this.omasServerURL, "getTagsByName");
        this.invalidParameterHandler.validateUserId(userId, "getTagsByName");
        this.invalidParameterHandler.validateName(tag, "tag", "getTagsByName");
        TagListResponse restResult = this.restClient.callTagListGetRESTCall("getTagsByName", this.omasServerURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/tags/by-name/{2}?elementStart={3}&maxElements={4}", this.serverName, userId, tag, startFrom, pageSize);
        this.exceptionHandler.detectAndThrowInvalidParameterException("getTagsByName", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getTagsByName", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getTagsByName", (AssetConsumerOMASAPIResponse)restResult);
        return restResult.getTags();
    }

    public void addTagToAsset(String userId, String assetGUID, String tagGUID) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "addTagToAsset";
        String assetGUIDParameterName = "assetGUID";
        String tagGUIDParameterName = "tagGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/tags/{3}";
        this.invalidParameterHandler.validateOMASServerURL(this.omasServerURL, "addTagToAsset");
        this.invalidParameterHandler.validateUserId(userId, "addTagToAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addTagToAsset");
        this.invalidParameterHandler.validateGUID(tagGUID, "tagGUID", "addTagToAsset");
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("addTagToAsset", this.omasServerURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/tags/{3}", this.nullRequestBody, this.serverName, userId, assetGUID, tagGUID);
        this.exceptionHandler.detectAndThrowInvalidParameterException("addTagToAsset", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("addTagToAsset", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("addTagToAsset", (AssetConsumerOMASAPIResponse)restResult);
    }

    public void removeTagFromAsset(String userId, String assetGUID, String tagGUID) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "removeTagFromAsset";
        String assetGUIDParameterName = "assetGUID";
        String tagGUIDParameterName = "tagGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/tags/{3}/delete";
        this.invalidParameterHandler.validateOMASServerURL(this.omasServerURL, "removeTagFromAsset");
        this.invalidParameterHandler.validateUserId(userId, "removeTagFromAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "removeTagFromAsset");
        this.invalidParameterHandler.validateGUID(tagGUID, "tagGUID", "removeTagFromAsset");
        NullRequestBody requestBody = new NullRequestBody();
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("removeTagFromAsset", this.omasServerURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/tags/{3}/delete", requestBody, this.serverName, userId, assetGUID, tagGUID);
        this.exceptionHandler.detectAndThrowInvalidParameterException("removeTagFromAsset", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("removeTagFromAsset", (AssetConsumerOMASAPIResponse)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("removeTagFromAsset", (AssetConsumerOMASAPIResponse)restResult);
    }
}

