/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.client;

import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.AssetConsumerErrorCode;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.PropertyServerException;

class InvalidParameterHandler {
    void validateOMASServerURL(String omasServerURL, String methodName) throws PropertyServerException {
        if (omasServerURL == null) {
            AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.SERVER_URL_NOT_SPECIFIED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]);
            throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    void validateUserId(String userId, String methodName) throws InvalidParameterException {
        if (userId == null) {
            AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.NULL_USER_ID;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), "userId");
        }
    }

    void validateGUID(String guid, String guidParameter, String methodName) throws InvalidParameterException {
        if (guid == null) {
            AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.NULL_GUID;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{guidParameter, methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), guidParameter);
        }
    }

    void validateName(String name, String nameParameter, String methodName) throws InvalidParameterException {
        if (name == null) {
            AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.NULL_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{nameParameter, methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), nameParameter);
        }
    }
}

