/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.client;

import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.AssetConsumerErrorCode;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.ConnectionResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.GUIDResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.MeaningListResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.MeaningResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.TagListResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.TagResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.VoidResponse;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.web.client.RestTemplate;

class RESTClient {
    private RestTemplate restTemplate;
    private String serverName;
    private String omasServerURL;

    RESTClient(String serverName, String omasServerURL) {
        this.serverName = serverName;
        this.omasServerURL = omasServerURL;
        this.restTemplate = new RestTemplate();
    }

    RESTClient(String serverName, String omasServerURL, String userId, String password) {
        this.serverName = serverName;
        this.omasServerURL = omasServerURL;
        RestTemplateBuilder restTemplateBuilder = new RestTemplateBuilder(new RestTemplateCustomizer[0]);
        this.restTemplate = restTemplateBuilder.basicAuthentication(userId, password).build();
    }

    ConnectionResponse callConnectionGetRESTCall(String methodName, String urlTemplate, Object ... params) throws PropertyServerException {
        return (ConnectionResponse)this.callGetRESTCall(methodName, ConnectionResponse.class, urlTemplate, params);
    }

    GUIDResponse callGUIDGetRESTCall(String methodName, String urlTemplate, Object ... params) throws PropertyServerException {
        return (GUIDResponse)this.callGetRESTCall(methodName, GUIDResponse.class, urlTemplate, params);
    }

    MeaningResponse callMeaningGetRESTCall(String methodName, String urlTemplate, Object ... params) throws PropertyServerException {
        return (MeaningResponse)this.callGetRESTCall(methodName, MeaningResponse.class, urlTemplate, params);
    }

    MeaningListResponse callMeaningListGetRESTCall(String methodName, String urlTemplate, Object ... params) throws PropertyServerException {
        return (MeaningListResponse)this.callGetRESTCall(methodName, MeaningListResponse.class, urlTemplate, params);
    }

    TagResponse callTagGetRESTCall(String methodName, String urlTemplate, Object ... params) throws PropertyServerException {
        return (TagResponse)this.callGetRESTCall(methodName, TagResponse.class, urlTemplate, params);
    }

    TagListResponse callTagListGetRESTCall(String methodName, String urlTemplate, Object ... params) throws PropertyServerException {
        return (TagListResponse)this.callGetRESTCall(methodName, TagListResponse.class, urlTemplate, params);
    }

    GUIDResponse callGUIDPostRESTCall(String methodName, String urlTemplate, Object requestBody, Object ... params) throws PropertyServerException {
        return (GUIDResponse)this.callPostRESTCall(methodName, GUIDResponse.class, urlTemplate, requestBody, params);
    }

    VoidResponse callVoidPostRESTCall(String methodName, String urlTemplate, Object requestBody, Object ... params) throws PropertyServerException {
        return (VoidResponse)this.callPostRESTCall(methodName, VoidResponse.class, urlTemplate, requestBody, params);
    }

    private Object callGetRESTCall(String methodName, Class returnClass, String urlTemplate, Object ... params) throws PropertyServerException {
        try {
            return this.restTemplate.getForObject(urlTemplate, returnClass, params);
        }
        catch (Throwable error) {
            AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.CLIENT_SIDE_REST_API_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, this.omasServerURL, error.getMessage()});
            throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }

    private Object callPostRESTCall(String methodName, Class returnClass, String urlTemplate, Object requestBody, Object ... params) throws PropertyServerException {
        try {
            return this.restTemplate.postForObject(urlTemplate, requestBody, returnClass, params);
        }
        catch (Throwable error) {
            AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.CLIENT_SIDE_REST_API_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, this.serverName, this.omasServerURL, error.getMessage()});
            throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }
}

