/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.client;

import java.util.Map;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.AmbiguousConnectionNameException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.NoConnectedAssetException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.AssetConsumerOMASAPIResponse;

class RESTExceptionHandler {
    RESTExceptionHandler() {
    }

    void detectAndThrowAmbiguousConnectionNameException(String methodName, AssetConsumerOMASAPIResponse restResult) throws AmbiguousConnectionNameException {
        String exceptionClassName = AmbiguousConnectionNameException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            Object nameObject;
            String connectionName = null;
            Map exceptionProperties = restResult.getExceptionProperties();
            if (exceptionProperties != null && (nameObject = exceptionProperties.get("connectionName")) != null) {
                connectionName = (String)nameObject;
            }
            throw new AmbiguousConnectionNameException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), connectionName);
        }
    }

    void detectAndThrowInvalidParameterException(String methodName, AssetConsumerOMASAPIResponse restResult) throws InvalidParameterException {
        String exceptionClassName = InvalidParameterException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            Object nameObject;
            String paramName = null;
            Map exceptionProperties = restResult.getExceptionProperties();
            if (exceptionProperties != null && (nameObject = exceptionProperties.get("parameterName")) != null) {
                paramName = (String)nameObject;
            }
            throw new InvalidParameterException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), paramName);
        }
    }

    void detectAndThrowNoConnectedAssetException(String methodName, AssetConsumerOMASAPIResponse restResult) throws NoConnectedAssetException {
        String exceptionClassName = NoConnectedAssetException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            Object guidObject;
            String connectionGUID = null;
            Map exceptionProperties = restResult.getExceptionProperties();
            if (exceptionProperties != null && (guidObject = exceptionProperties.get("connectionGUID")) != null) {
                connectionGUID = (String)guidObject;
            }
            throw new NoConnectedAssetException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), connectionGUID);
        }
    }

    void detectAndThrowPropertyServerException(String methodName, AssetConsumerOMASAPIResponse restResult) throws PropertyServerException {
        String exceptionClassName = PropertyServerException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            throw new PropertyServerException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction());
        }
    }

    void detectAndThrowUserNotAuthorizedException(String methodName, AssetConsumerOMASAPIResponse restResult) throws UserNotAuthorizedException {
        String exceptionClassName = UserNotAuthorizedException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            Object userIdObject;
            String userId = null;
            Map exceptionProperties = restResult.getExceptionProperties();
            if (exceptionProperties != null && (userIdObject = exceptionProperties.get("userId")) != null) {
                userId = (String)userIdObject;
            }
            throw new UserNotAuthorizedException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), userId);
        }
    }
}

