/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.client;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetconsumer.api.AssetConsumerAssetInterface;
import org.odpi.openmetadata.accessservices.assetconsumer.api.AssetConsumerConnectorFactoryInterface;
import org.odpi.openmetadata.accessservices.assetconsumer.api.AssetConsumerFeedbackInterface;
import org.odpi.openmetadata.accessservices.assetconsumer.api.AssetConsumerGlossaryInterface;
import org.odpi.openmetadata.accessservices.assetconsumer.api.AssetConsumerLoggingInterface;
import org.odpi.openmetadata.accessservices.assetconsumer.api.AssetConsumerTaggingInterface;
import org.odpi.openmetadata.accessservices.assetconsumer.client.AssetConsumerRESTClient;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.GlossaryTerm;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.GlossaryTermListResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.GlossaryTermResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.LogRecordRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.ConnectedAssetClientBase;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.CommentRequestBody;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ConnectionResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.FeedbackRequestBody;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.RatingRequestBody;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.TagRequestBody;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.TagResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.TagsResponse;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetUniverse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Asset;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.CommentType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.InformalTag;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.StarRating;

public class AssetConsumer
extends ConnectedAssetClientBase
implements AssetConsumerAssetInterface,
AssetConsumerConnectorFactoryInterface,
AssetConsumerFeedbackInterface,
AssetConsumerGlossaryInterface,
AssetConsumerLoggingInterface,
AssetConsumerTaggingInterface {
    private AssetConsumerRESTClient restClient;
    private static final String serviceURLName = "asset-consumer";

    public AssetConsumer(String serverName, String serverPlatformRootURL) throws InvalidParameterException {
        super(serverName, serverPlatformRootURL);
        this.restClient = new AssetConsumerRESTClient(serverName, serverPlatformRootURL);
    }

    public AssetConsumer(String serverName, String serverPlatformRootURL, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformRootURL);
        this.restClient = new AssetConsumerRESTClient(serverName, serverPlatformRootURL, userId, password);
    }

    public String getAssetForConnection(String userId, String connectionGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getAssetForConnection";
        String guidParameter = "connectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "getAssetForConnection");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "getAssetForConnection");
        return super.getAssetForConnection((OCFRESTClient)this.restClient, serviceURLName, userId, connectionGUID);
    }

    public String getAssetForConnectionName(String userId, String connectionName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getAssetForConnectionName";
        String nameParameter = "connectionName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/by-connection-name/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getAssetForConnectionName");
        this.invalidParameterHandler.validateName(connectionName, "connectionName", "getAssetForConnectionName");
        GUIDResponse restResult = this.restClient.callGUIDGetRESTCall("getAssetForConnectionName", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/by-connection-name/{2}", new Object[]{this.serverName, userId, connectionName});
        this.exceptionHandler.detectAndThrowInvalidParameterException("getAssetForConnectionName", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getAssetForConnectionName", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getAssetForConnectionName", (FFDCResponseBase)restResult);
        return restResult.getGUID();
    }

    public AssetUniverse getAssetProperties(String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return super.getAssetProperties(serviceURLName, userId, assetGUID);
    }

    private List<String> getAssetsByName(String userId, String name, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/by-name?startFrom={2}&pageSize={3}";
        GUIDListResponse restResult = this.restClient.callGUIDListPostRESTCall(methodName, this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/by-name?startFrom={2}&pageSize={3}", name, new Object[]{this.serverName, userId, startFrom, pageSize});
        this.exceptionHandler.detectAndThrowInvalidParameterException(methodName, (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException(methodName, (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException(methodName, (FFDCResponseBase)restResult);
        return restResult.getGUIDs();
    }

    public List<String> findAssets(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "findAssets";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/by-search-string?startFrom={2}&pageSize={3}";
        GUIDListResponse restResult = this.restClient.callGUIDListPostRESTCall("findAssets", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/by-search-string?startFrom={2}&pageSize={3}", searchString, new Object[]{this.serverName, userId, startFrom, pageSize});
        this.exceptionHandler.detectAndThrowInvalidParameterException("findAssets", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("findAssets", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("findAssets", (FFDCResponseBase)restResult);
        return restResult.getGUIDs();
    }

    public List<String> getAssetsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getAssetsByName";
        String nameParameter = "name";
        this.invalidParameterHandler.validateUserId(userId, "getAssetsByName");
        this.invalidParameterHandler.validateName(name, "name", "getAssetsByName");
        return this.getAssetsByName(userId, name, startFrom, pageSize, "getAssetsByName");
    }

    public List<String> getAssetsByToken(String userId, String assetToken, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Asset asset;
        String methodName = "getAssetsByToken";
        String tokenParameter = "assetToken";
        this.invalidParameterHandler.validateUserId(userId, "getAssetsByToken");
        this.invalidParameterHandler.validateName(assetToken, "assetToken", "getAssetsByToken");
        try {
            asset = this.getAssetSummary(this.restClient, serviceURLName, userId, assetToken, "getAssetsByToken");
        }
        catch (Throwable error) {
            asset = null;
        }
        if (asset != null) {
            ArrayList<String> retrievedAssets = new ArrayList<String>();
            retrievedAssets.add(asset.getGUID());
            return retrievedAssets;
        }
        return this.getAssetsByName(userId, assetToken, startFrom, pageSize, "getAssetsByToken");
    }

    private Connection getConnectionByName(String userId, String name) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getConnectionByName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/connections/by-name/{2}";
        ConnectionResponse restResult = this.restClient.callConnectionGetRESTCall("getConnectionByName", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/connections/by-name/{2}", new Object[]{this.serverName, userId, name});
        this.exceptionHandler.detectAndThrowInvalidParameterException("getConnectionByName", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getConnectionByName", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getConnectionByName", (FFDCResponseBase)restResult);
        return restResult.getConnection();
    }

    public Connector getConnectorByName(String userId, String connectionName) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getConnectorByName";
        String nameParameter = "connectionName";
        this.invalidParameterHandler.validateUserId(userId, "getConnectorByName");
        this.invalidParameterHandler.validateName(connectionName, "connectionName", "getConnectorByName");
        return this.getConnectorForConnection(this.restClient, serviceURLName, userId, this.getConnectionByName(userId, connectionName), "getConnectorByName");
    }

    public Connector getConnectorForAsset(String userId, String assetGUID) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getConnectorForAsset";
        String guidParameter = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "getConnectorForAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "getConnectorForAsset");
        return this.getConnectorForConnection(this.restClient, serviceURLName, userId, this.getConnectionForAsset(this.restClient, serviceURLName, userId, assetGUID), "getConnectorForAsset");
    }

    public Connector getConnectorByGUID(String userId, String connectionGUID) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getConnectorByGUID";
        String guidParameter = "connectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "getConnectorByGUID");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "getConnectorByGUID");
        return this.getConnectorForConnection(this.restClient, serviceURLName, userId, super.getConnectionByGUID((OCFRESTClient)this.restClient, serviceURLName, userId, connectionGUID), "getConnectorByGUID");
    }

    public Connector getConnectorByConnection(String userId, Connection connection) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException {
        String methodName = "getConnectorByConnection";
        this.invalidParameterHandler.validateUserId(userId, "getConnectorByConnection");
        return this.getConnectorForConnection(this.restClient, serviceURLName, userId, connection, "getConnectorByConnection");
    }

    public void addRatingToAsset(String userId, String assetGUID, StarRating starRating, String review, boolean isPublic) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addRatingToAsset";
        String guidParameter = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/ratings";
        this.invalidParameterHandler.validateUserId(userId, "addRatingToAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addRatingToAsset");
        RatingRequestBody requestBody = new RatingRequestBody();
        requestBody.setStarRating(starRating);
        requestBody.setReview(review);
        requestBody.setPublic(isPublic);
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("addRatingToAsset", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/ratings", requestBody, new Object[]{this.serverName, userId, assetGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("addRatingToAsset", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("addRatingToAsset", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("addRatingToAsset", (FFDCResponseBase)restResult);
    }

    public void removeRatingFromAsset(String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeRatingFromAsset";
        String guidParameter = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/ratings/delete";
        this.invalidParameterHandler.validateUserId(userId, "removeRatingFromAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "removeRatingFromAsset");
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("removeRatingFromAsset", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/ratings/delete", this.nullRequestBody, new Object[]{this.serverName, userId, assetGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("removeRatingFromAsset", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("removeRatingFromAsset", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("removeRatingFromAsset", (FFDCResponseBase)restResult);
    }

    public void addLikeToAsset(String userId, String assetGUID, boolean isPublic) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addLikeToAsset";
        String guidParameter = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/likes";
        this.invalidParameterHandler.validateUserId(userId, "addLikeToAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addLikeToAsset");
        FeedbackRequestBody requestBody = new FeedbackRequestBody();
        requestBody.setPublic(isPublic);
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("addLikeToAsset", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/likes", requestBody, new Object[]{this.serverName, userId, assetGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("addLikeToAsset", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("addLikeToAsset", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("addLikeToAsset", (FFDCResponseBase)restResult);
    }

    public void removeLikeFromAsset(String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeLikeFromAsset";
        String guidParameter = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/likes/delete";
        this.invalidParameterHandler.validateUserId(userId, "removeLikeFromAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "removeLikeFromAsset");
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("removeLikeFromAsset", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/likes/delete", this.nullRequestBody, new Object[]{this.serverName, userId, assetGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("removeLikeFromAsset", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("removeLikeFromAsset", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("removeLikeFromAsset", (FFDCResponseBase)restResult);
    }

    public String addCommentToAsset(String userId, String assetGUID, CommentType commentType, String commentText, boolean isPublic) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addCommentToAsset";
        String guidParameter = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/comments";
        this.invalidParameterHandler.validateUserId(userId, "addCommentToAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addCommentToAsset");
        CommentRequestBody requestBody = new CommentRequestBody();
        requestBody.setCommentType(commentType);
        requestBody.setCommentText(commentText);
        requestBody.setPublic(isPublic);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("addCommentToAsset", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/comments", requestBody, new Object[]{this.serverName, userId, assetGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("addCommentToAsset", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("addCommentToAsset", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("addCommentToAsset", (FFDCResponseBase)restResult);
        return restResult.getGUID();
    }

    public String addCommentReply(String userId, String assetGUID, String commentGUID, CommentType commentType, String commentText, boolean isPublic) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addCommentReply";
        String commentGUIDParameter = "commentGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/comments/{2}/replies";
        this.invalidParameterHandler.validateUserId(userId, "addCommentReply");
        this.invalidParameterHandler.validateGUID(commentGUID, "commentGUID", "addCommentReply");
        CommentRequestBody requestBody = new CommentRequestBody();
        requestBody.setCommentType(commentType);
        requestBody.setCommentText(commentText);
        requestBody.setPublic(isPublic);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("addCommentReply", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/comments/{2}/replies", requestBody, new Object[]{this.serverName, userId, commentGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("addCommentReply", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("addCommentReply", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("addCommentReply", (FFDCResponseBase)restResult);
        return restResult.getGUID();
    }

    public void updateComment(String userId, String assetGUID, String commentGUID, CommentType commentType, String commentText, boolean isPublic) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateComment";
        String assetGUIDParameter = "assetGUID";
        String commentGUIDParameter = "commentGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/comments/{3}/update";
        this.invalidParameterHandler.validateUserId(userId, "updateComment");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "updateComment");
        this.invalidParameterHandler.validateGUID(commentGUID, "commentGUID", "updateComment");
        CommentRequestBody requestBody = new CommentRequestBody();
        requestBody.setCommentType(commentType);
        requestBody.setCommentText(commentText);
        requestBody.setPublic(isPublic);
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("updateComment", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/comments/{3}/update", requestBody, new Object[]{this.serverName, userId, assetGUID, commentGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("updateComment", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("updateComment", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("updateComment", (FFDCResponseBase)restResult);
    }

    public void removeComment(String userId, String assetGUID, String commentGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeComment";
        String assetGUIDParameter = "assetGUID";
        String commentGUIDParameter = "commentGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/comments/{3}/delete";
        this.invalidParameterHandler.validateUserId(userId, "removeComment");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "removeComment");
        this.invalidParameterHandler.validateGUID(commentGUID, "commentGUID", "removeComment");
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("removeComment", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/comments/{3}/delete", this.nullRequestBody, new Object[]{this.serverName, userId, assetGUID, commentGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("removeComment", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("removeComment", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("removeComment", (FFDCResponseBase)restResult);
    }

    public GlossaryTerm getMeaning(String userId, String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getMeaning";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/meanings/{2}";
        String guidParameter = "guid";
        this.invalidParameterHandler.validateUserId(userId, "getMeaning");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getMeaning");
        GlossaryTermResponse restResult = this.restClient.callGlossaryTermGetRESTCall("getMeaning", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/meanings/{2}", this.serverName, userId, guid);
        this.exceptionHandler.detectAndThrowInvalidParameterException("getMeaning", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getMeaning", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getMeaning", (FFDCResponseBase)restResult);
        return restResult.getGlossaryTerm();
    }

    public List<GlossaryTerm> getMeaningByName(String userId, String term, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getMeaningByName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/meanings/by-name/{2}?startFrom={3}&pageSize={4}";
        String nameParameter = "term";
        this.invalidParameterHandler.validateUserId(userId, "getMeaningByName");
        this.invalidParameterHandler.validateName(term, "term", "getMeaningByName");
        GlossaryTermListResponse restResult = this.restClient.callGlossaryTermListGetRESTCall("getMeaningByName", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/meanings/by-name/{2}?startFrom={3}&pageSize={4}", this.serverName, userId, term, startFrom, pageSize);
        this.exceptionHandler.detectAndThrowInvalidParameterException("getMeaningByName", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getMeaningByName", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getMeaningByName", (FFDCResponseBase)restResult);
        return restResult.getMeanings();
    }

    public void addLogMessageToAsset(String userId, String assetGUID, String connectorInstanceId, String connectionName, String connectorType, String contextId, String message) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addLogMessageToAsset";
        String guidParameter = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/log-records";
        this.invalidParameterHandler.validateUserId(userId, "addLogMessageToAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addLogMessageToAsset");
        LogRecordRequestBody requestBody = new LogRecordRequestBody();
        requestBody.setConnectorInstanceId(connectorInstanceId);
        requestBody.setConnectionName(connectionName);
        requestBody.setConnectorType(connectorType);
        requestBody.setContextId(contextId);
        requestBody.setMessage(message);
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("addLogMessageToAsset", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/log-records", requestBody, new Object[]{this.serverName, userId, assetGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("addLogMessageToAsset", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("addLogMessageToAsset", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("addLogMessageToAsset", (FFDCResponseBase)restResult);
    }

    private String createTag(boolean isPublic, String methodName, String userId, String tagName, String tagDescription) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/tags";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        TagRequestBody tagRequestBody = new TagRequestBody();
        tagRequestBody.setPublic(isPublic);
        tagRequestBody.setTagName(tagName);
        tagRequestBody.setTagDescription(tagDescription);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall(methodName, this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/tags", tagRequestBody, new Object[]{this.serverName, userId});
        this.exceptionHandler.detectAndThrowInvalidParameterException(methodName, (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException(methodName, (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException(methodName, (FFDCResponseBase)restResult);
        return restResult.getGUID();
    }

    public String createPublicTag(String userId, String tagName, String tagDescription) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createPublicTag";
        return this.createTag(true, "createPublicTag", userId, tagName, tagDescription);
    }

    public String createPrivateTag(String userId, String tagName, String tagDescription) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createPrivateTag";
        return this.createTag(false, "createPrivateTag", userId, tagName, tagDescription);
    }

    public void updateTagDescription(String userId, String tagGUID, String tagDescription) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateTagDescription";
        String guidParameter = "tagGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/tags/{2}/update";
        this.invalidParameterHandler.validateUserId(userId, "updateTagDescription");
        this.invalidParameterHandler.validateGUID(tagGUID, "tagGUID", "updateTagDescription");
        TagRequestBody tagRequestBody = new TagRequestBody();
        tagRequestBody.setTagDescription(tagDescription);
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("updateTagDescription", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/tags/{2}/update", tagRequestBody, new Object[]{this.serverName, userId, tagGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("updateTagDescription", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("updateTagDescription", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("updateTagDescription", (FFDCResponseBase)restResult);
    }

    public void deleteTag(String userId, String tagGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "deleteTag";
        String guidParameter = "tagGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/tags/{2}/delete";
        this.invalidParameterHandler.validateUserId(userId, "deleteTag");
        this.invalidParameterHandler.validateGUID(tagGUID, "tagGUID", "deleteTag");
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("deleteTag", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/tags/{2}/delete", this.nullRequestBody, new Object[]{this.serverName, userId, tagGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("deleteTag", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("deleteTag", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("deleteTag", (FFDCResponseBase)restResult);
    }

    public InformalTag getTag(String userId, String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getTag";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/tags/{2}";
        String guidParameter = "guid";
        this.invalidParameterHandler.validateUserId(userId, "getTag");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getTag");
        TagResponse restResult = this.restClient.callTagGetRESTCall("getTag", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/tags/{2}", new Object[]{this.serverName, userId, guid});
        this.exceptionHandler.detectAndThrowInvalidParameterException("getTag", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getTag", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getTag", (FFDCResponseBase)restResult);
        return restResult.getTag();
    }

    public List<InformalTag> getTagsByName(String userId, String tag, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getTagsByName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/tags/by-name?startFrom={2}&pageSize={3}";
        String nameParameter = "tag";
        this.invalidParameterHandler.validateUserId(userId, "getTagsByName");
        this.invalidParameterHandler.validateName(tag, "tag", "getTagsByName");
        TagsResponse restResult = this.restClient.callTagListPostRESTCall("getTagsByName", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/tags/by-name?startFrom={2}&pageSize={3}", tag, new Object[]{this.serverName, userId, startFrom, pageSize});
        this.exceptionHandler.detectAndThrowInvalidParameterException("getTagsByName", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getTagsByName", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getTagsByName", (FFDCResponseBase)restResult);
        return restResult.getTags();
    }

    public void addTagToAsset(String userId, String assetGUID, String tagGUID, boolean isPublic) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addTagToAsset";
        String assetGUIDParameterName = "assetGUID";
        String tagGUIDParameterName = "tagGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/tags/{3}";
        this.invalidParameterHandler.validateUserId(userId, "addTagToAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addTagToAsset");
        this.invalidParameterHandler.validateGUID(tagGUID, "tagGUID", "addTagToAsset");
        FeedbackRequestBody requestBody = new FeedbackRequestBody();
        requestBody.setPublic(isPublic);
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("addTagToAsset", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/tags/{3}", requestBody, new Object[]{this.serverName, userId, assetGUID, tagGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("addTagToAsset", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("addTagToAsset", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("addTagToAsset", (FFDCResponseBase)restResult);
    }

    public void removeTagFromAsset(String userId, String assetGUID, String tagGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeTagFromAsset";
        String assetGUIDParameterName = "assetGUID";
        String tagGUIDParameterName = "tagGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/tags/{3}/delete";
        this.invalidParameterHandler.validateUserId(userId, "removeTagFromAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "removeTagFromAsset");
        this.invalidParameterHandler.validateGUID(tagGUID, "tagGUID", "removeTagFromAsset");
        NullRequestBody requestBody = new NullRequestBody();
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("removeTagFromAsset", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/tags/{3}/delete", requestBody, new Object[]{this.serverName, userId, assetGUID, tagGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("removeTagFromAsset", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("removeTagFromAsset", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("removeTagFromAsset", (FFDCResponseBase)restResult);
    }
}

