/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.client;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.assetconsumer.api.AssetConsumerAssetInterface;
import org.odpi.openmetadata.accessservices.assetconsumer.api.AssetConsumerFeedbackInterface;
import org.odpi.openmetadata.accessservices.assetconsumer.api.AssetConsumerGlossaryInterface;
import org.odpi.openmetadata.accessservices.assetconsumer.api.AssetConsumerLoggingInterface;
import org.odpi.openmetadata.accessservices.assetconsumer.api.AssetConsumerTaggingInterface;
import org.odpi.openmetadata.accessservices.assetconsumer.client.rest.AssetConsumerRESTClient;
import org.odpi.openmetadata.accessservices.assetconsumer.elements.InformalTagElement;
import org.odpi.openmetadata.accessservices.assetconsumer.elements.MeaningElement;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.CommentRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.FeedbackRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.GlossaryTermListResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.GlossaryTermResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.LogRecordRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.RatingRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.TagRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.TagResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.TagUpdateRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.TagsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetUniverse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Asset;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.CommentType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.StarRating;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.ConnectedAssetClientBase;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.OCFRESTClient;

public class AssetConsumer
extends ConnectedAssetClientBase
implements AssetConsumerAssetInterface,
AssetConsumerFeedbackInterface,
AssetConsumerGlossaryInterface,
AssetConsumerLoggingInterface,
AssetConsumerTaggingInterface {
    private final AssetConsumerRESTClient restClient;
    private static final String serviceURLName = "asset-consumer";

    public AssetConsumer(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, serviceURLName, auditLog);
        this.restClient = new AssetConsumerRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public AssetConsumer(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, serviceURLName);
        this.restClient = new AssetConsumerRESTClient(serverName, serverPlatformURLRoot);
    }

    public AssetConsumer(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, serviceURLName, auditLog);
        this.restClient = new AssetConsumerRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public AssetConsumer(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, serviceURLName, userId, password);
        this.restClient = new AssetConsumerRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public AssetConsumer(String serverName, String serverPlatformURLRoot, AssetConsumerRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, serviceURLName, maxPageSize, auditLog);
        this.invalidParameterHandler.validateObject((Object)restClient, "this.restClient", "Asset Consumer client constructor");
        this.restClient = restClient;
    }

    public String getAssetForConnection(String userId, String connectionGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getAssetForConnection";
        String guidParameter = "connectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "getAssetForConnection");
        this.invalidParameterHandler.validateGUID(connectionGUID, "connectionGUID", "getAssetForConnection");
        return super.getAssetForConnection((OCFRESTClient)this.restClient, serviceURLName, userId, connectionGUID);
    }

    public String getAssetForConnectionName(String userId, String connectionName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getAssetForConnectionName";
        String nameParameter = "connectionName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/by-connection-name/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getAssetForConnectionName");
        this.invalidParameterHandler.validateName(connectionName, "connectionName", "getAssetForConnectionName");
        GUIDResponse restResult = this.restClient.callGUIDGetRESTCall("getAssetForConnectionName", urlTemplate, new Object[]{this.serverName, userId, connectionName});
        return restResult.getGUID();
    }

    private List<String> getAssetsByName(String userId, String name, int startFrom, int pageSize, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        GUIDListResponse restResult = this.restClient.callGUIDListPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, startFrom, pageSize});
        return restResult.getGUIDs();
    }

    public List<String> findAssets(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "findAssets";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/by-search-string?startFrom={2}&pageSize={3}";
        String nameParameter = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findAssets");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findAssets");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        GUIDListResponse restResult = this.restClient.callGUIDListPostRESTCall("findAssets", urlTemplate, requestBody, new Object[]{this.serverName, userId, startFrom, pageSize});
        return restResult.getGUIDs();
    }

    public List<String> getAssetsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getAssetsByName";
        String nameParameter = "name";
        this.invalidParameterHandler.validateUserId(userId, "getAssetsByName");
        this.invalidParameterHandler.validateName(name, "name", "getAssetsByName");
        return this.getAssetsByName(userId, name, startFrom, pageSize, "getAssetsByName");
    }

    public List<String> getAssetsByToken(String userId, String assetToken, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Asset asset;
        String methodName = "getAssetsByToken";
        String tokenParameter = "assetToken";
        this.invalidParameterHandler.validateUserId(userId, "getAssetsByToken");
        this.invalidParameterHandler.validateName(assetToken, "assetToken", "getAssetsByToken");
        try {
            asset = this.getAssetSummary(userId, assetToken, "getAssetsByToken");
        }
        catch (Exception error) {
            asset = null;
        }
        if (asset != null) {
            ArrayList<String> retrievedAssets = new ArrayList<String>();
            retrievedAssets.add(asset.getGUID());
            return retrievedAssets;
        }
        return this.getAssetsByName(userId, assetToken, startFrom, pageSize, "getAssetsByToken");
    }

    public AssetUniverse getAssetProperties(String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return super.getAssetProperties(serviceURLName, userId, assetGUID);
    }

    public void addRatingToAsset(String userId, String assetGUID, StarRating starRating, String review, boolean isPublic) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addRatingToAsset";
        String guidParameter = "assetGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/ratings";
        this.invalidParameterHandler.validateUserId(userId, "addRatingToAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addRatingToAsset");
        RatingRequestBody requestBody = new RatingRequestBody();
        requestBody.setStarRating(starRating);
        requestBody.setReview(review);
        requestBody.setIsPublic(isPublic);
        this.restClient.callVoidPostRESTCall("addRatingToAsset", urlTemplate, requestBody, new Object[]{this.serverName, userId, assetGUID});
    }

    public void removeRatingFromAsset(String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeRatingFromAsset";
        String guidParameter = "assetGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/ratings/delete";
        this.invalidParameterHandler.validateUserId(userId, "removeRatingFromAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "removeRatingFromAsset");
        this.restClient.callVoidPostRESTCall("removeRatingFromAsset", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, assetGUID});
    }

    public void addLikeToAsset(String userId, String assetGUID, boolean isPublic) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addLikeToAsset";
        String guidParameter = "assetGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/likes";
        this.invalidParameterHandler.validateUserId(userId, "addLikeToAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addLikeToAsset");
        FeedbackRequestBody requestBody = new FeedbackRequestBody();
        requestBody.setIsPublic(isPublic);
        this.restClient.callVoidPostRESTCall("addLikeToAsset", urlTemplate, requestBody, new Object[]{this.serverName, userId, assetGUID});
    }

    public void removeLikeFromAsset(String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeLikeFromAsset";
        String guidParameter = "assetGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/likes/delete";
        this.invalidParameterHandler.validateUserId(userId, "removeLikeFromAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "removeLikeFromAsset");
        this.restClient.callVoidPostRESTCall("removeLikeFromAsset", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, assetGUID});
    }

    public String addCommentToAsset(String userId, String assetGUID, CommentType commentType, String commentText, boolean isPublic) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addCommentToAsset";
        String guidParameter = "assetGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/comments";
        this.invalidParameterHandler.validateUserId(userId, "addCommentToAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addCommentToAsset");
        CommentRequestBody requestBody = new CommentRequestBody();
        requestBody.setCommentType(commentType);
        requestBody.setCommentText(commentText);
        requestBody.setIsPublic(isPublic);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("addCommentToAsset", urlTemplate, requestBody, new Object[]{this.serverName, userId, assetGUID});
        return restResult.getGUID();
    }

    public String addCommentReply(String userId, String assetGUID, String commentGUID, CommentType commentType, String commentText, boolean isPublic) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addCommentReply";
        String commentGUIDParameter = "commentGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/comments/{2}/replies";
        this.invalidParameterHandler.validateUserId(userId, "addCommentReply");
        this.invalidParameterHandler.validateGUID(commentGUID, "commentGUID", "addCommentReply");
        CommentRequestBody requestBody = new CommentRequestBody();
        requestBody.setCommentType(commentType);
        requestBody.setCommentText(commentText);
        requestBody.setIsPublic(isPublic);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("addCommentReply", urlTemplate, requestBody, new Object[]{this.serverName, userId, commentGUID});
        return restResult.getGUID();
    }

    public void updateComment(String userId, String assetGUID, String commentGUID, CommentType commentType, String commentText, boolean isPublic) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateComment";
        String assetGUIDParameter = "assetGUID";
        String commentGUIDParameter = "commentGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/comments/{3}/update";
        this.invalidParameterHandler.validateUserId(userId, "updateComment");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "updateComment");
        this.invalidParameterHandler.validateGUID(commentGUID, "commentGUID", "updateComment");
        CommentRequestBody requestBody = new CommentRequestBody();
        requestBody.setCommentType(commentType);
        requestBody.setCommentText(commentText);
        requestBody.setIsPublic(isPublic);
        this.restClient.callVoidPostRESTCall("updateComment", urlTemplate, requestBody, new Object[]{this.serverName, userId, assetGUID, commentGUID});
    }

    public void removeComment(String userId, String assetGUID, String commentGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeComment";
        String assetGUIDParameter = "assetGUID";
        String commentGUIDParameter = "commentGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/comments/{3}/delete";
        this.invalidParameterHandler.validateUserId(userId, "removeComment");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "removeComment");
        this.invalidParameterHandler.validateGUID(commentGUID, "commentGUID", "removeComment");
        this.restClient.callVoidPostRESTCall("removeComment", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, assetGUID, commentGUID});
    }

    public MeaningElement getMeaning(String userId, String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getMeaning";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/meanings/{2}";
        String guidParameter = "guid";
        this.invalidParameterHandler.validateUserId(userId, "getMeaning");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getMeaning");
        GlossaryTermResponse restResult = this.restClient.callGlossaryTermGetRESTCall("getMeaning", urlTemplate, this.serverName, userId, guid);
        return restResult.getMeaning();
    }

    public List<MeaningElement> getMeaningByName(String userId, String term, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getMeaningByName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/meanings/by-name/{2}?startFrom={3}&pageSize={4}";
        String nameParameter = "term";
        this.invalidParameterHandler.validateUserId(userId, "getMeaningByName");
        this.invalidParameterHandler.validateName(term, "term", "getMeaningByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(term);
        requestBody.setNameParameterName("term");
        GlossaryTermListResponse restResult = this.restClient.callGlossaryTermListPostRESTCall("getMeaningByName", urlTemplate, requestBody, this.serverName, userId, startFrom, pageSize);
        return restResult.getMeanings();
    }

    public List<MeaningElement> findMeanings(String userId, String term, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "findMeanings";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/meanings/by-search-string/{2}?startFrom={3}&pageSize={4}";
        String nameParameter = "term";
        this.invalidParameterHandler.validateUserId(userId, "findMeanings");
        this.invalidParameterHandler.validateSearchString(term, "term", "findMeanings");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(term);
        requestBody.setSearchStringParameterName("term");
        GlossaryTermListResponse restResult = this.restClient.callGlossaryTermListPostRESTCall("findMeanings", urlTemplate, requestBody, this.serverName, userId, startFrom, pageSize);
        return restResult.getMeanings();
    }

    public List<String> getAssetsByMeaning(String userId, String termGUID, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getAssetsByMeaning";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/by-meaning/{2}?startFrom={3}&pageSize={4}";
        String termGUIDParameterName = "termGUID";
        this.invalidParameterHandler.validateUserId(userId, "getAssetsByMeaning");
        this.invalidParameterHandler.validateGUID(termGUID, "termGUID", "getAssetsByMeaning");
        GUIDListResponse restResult = this.restClient.callGUIDListGetRESTCall("getAssetsByMeaning", urlTemplate, new Object[]{this.serverName, userId, termGUID, startFrom, pageSize});
        return restResult.getGUIDs();
    }

    public void addLogMessageToAsset(String userId, String assetGUID, String connectorInstanceId, String connectionName, String connectorType, String contextId, String message) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addLogMessageToAsset";
        String guidParameter = "assetGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/log-records";
        this.invalidParameterHandler.validateUserId(userId, "addLogMessageToAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addLogMessageToAsset");
        LogRecordRequestBody requestBody = new LogRecordRequestBody();
        requestBody.setConnectorInstanceId(connectorInstanceId);
        requestBody.setConnectionName(connectionName);
        requestBody.setConnectorType(connectorType);
        requestBody.setContextId(contextId);
        requestBody.setMessage(message);
        this.restClient.callVoidPostRESTCall("addLogMessageToAsset", urlTemplate, requestBody, new Object[]{this.serverName, userId, assetGUID});
    }

    private String createTag(boolean isPublic, String methodName, String userId, String tagName, String tagDescription) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/tags";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        TagRequestBody tagRequestBody = new TagRequestBody();
        tagRequestBody.setIsPrivateTag(!isPublic);
        tagRequestBody.setName(tagName);
        tagRequestBody.setDescription(tagDescription);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall(methodName, urlTemplate, tagRequestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public String createPublicTag(String userId, String tagName, String tagDescription) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createPublicTag";
        return this.createTag(true, "createPublicTag", userId, tagName, tagDescription);
    }

    public String createPrivateTag(String userId, String tagName, String tagDescription) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createPrivateTag";
        return this.createTag(false, "createPrivateTag", userId, tagName, tagDescription);
    }

    public void updateTagDescription(String userId, String tagGUID, String tagDescription) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateTagDescription";
        String guidParameter = "tagGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/tags/{2}/update";
        this.invalidParameterHandler.validateUserId(userId, "updateTagDescription");
        this.invalidParameterHandler.validateGUID(tagGUID, "tagGUID", "updateTagDescription");
        TagUpdateRequestBody tagRequestBody = new TagUpdateRequestBody();
        tagRequestBody.setDescription(tagDescription);
        this.restClient.callVoidPostRESTCall("updateTagDescription", urlTemplate, tagRequestBody, new Object[]{this.serverName, userId, tagGUID});
    }

    public void deleteTag(String userId, String tagGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "deleteTag";
        String guidParameter = "tagGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/tags/{2}/delete";
        this.invalidParameterHandler.validateUserId(userId, "deleteTag");
        this.invalidParameterHandler.validateGUID(tagGUID, "tagGUID", "deleteTag");
        this.restClient.callVoidPostRESTCall("deleteTag", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, tagGUID});
    }

    public InformalTagElement getTag(String userId, String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getTag";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/tags/{2}";
        String guidParameter = "guid";
        this.invalidParameterHandler.validateUserId(userId, "getTag");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getTag");
        TagResponse restResult = this.restClient.callInformalTagGetRESTCall("getTag", urlTemplate, this.serverName, userId, guid);
        return restResult.getTag();
    }

    public List<InformalTagElement> getTagsByName(String userId, String tag, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getTagsByName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/tags/by-name?startFrom={2}&pageSize={3}";
        String nameParameter = "tag";
        this.invalidParameterHandler.validateUserId(userId, "getTagsByName");
        this.invalidParameterHandler.validateName(tag, "tag", "getTagsByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(tag);
        requestBody.setNameParameterName("tag");
        TagsResponse restResult = this.restClient.callInformalTagListPostRESTCall("getTagsByName", urlTemplate, requestBody, this.serverName, userId, startFrom, pageSize);
        return restResult.getTags();
    }

    public List<InformalTagElement> getMyTagsByName(String userId, String tag, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getTagsByName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/tags/private/by-name?startFrom={2}&pageSize={3}";
        String nameParameter = "tag";
        this.invalidParameterHandler.validateUserId(userId, "getTagsByName");
        this.invalidParameterHandler.validateName(tag, "tag", "getTagsByName");
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(tag);
        requestBody.setNameParameterName("tag");
        TagsResponse restResult = this.restClient.callInformalTagListPostRESTCall("getTagsByName", urlTemplate, requestBody, this.serverName, userId, startFrom, pageSize);
        return restResult.getTags();
    }

    public List<InformalTagElement> findTags(String userId, String tag, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "findTags";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/tags/by-search-string?startFrom={2}&pageSize={3}";
        String nameParameter = "tag";
        this.invalidParameterHandler.validateUserId(userId, "findTags");
        this.invalidParameterHandler.validateName(tag, "tag", "findTags");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(tag);
        requestBody.setSearchStringParameterName("tag");
        TagsResponse restResult = this.restClient.callInformalTagListPostRESTCall("findTags", urlTemplate, requestBody, this.serverName, userId, startFrom, pageSize);
        return restResult.getTags();
    }

    public List<InformalTagElement> findMyTags(String userId, String tag, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "findTags";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/tags/private/by-search-string?startFrom={2}&pageSize={3}";
        String nameParameter = "tag";
        this.invalidParameterHandler.validateUserId(userId, "findTags");
        this.invalidParameterHandler.validateName(tag, "tag", "findTags");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(tag);
        requestBody.setSearchStringParameterName("tag");
        TagsResponse restResult = this.restClient.callInformalTagListPostRESTCall("findTags", urlTemplate, requestBody, this.serverName, userId, startFrom, pageSize);
        return restResult.getTags();
    }

    public void addTagToAsset(String userId, String assetGUID, String tagGUID, boolean isPublic) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addTagToAsset";
        String assetGUIDParameterName = "assetGUID";
        String tagGUIDParameterName = "tagGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/tags/{3}";
        this.invalidParameterHandler.validateUserId(userId, "addTagToAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "addTagToAsset");
        this.invalidParameterHandler.validateGUID(tagGUID, "tagGUID", "addTagToAsset");
        FeedbackRequestBody requestBody = new FeedbackRequestBody();
        requestBody.setIsPublic(isPublic);
        this.restClient.callVoidPostRESTCall("addTagToAsset", urlTemplate, requestBody, new Object[]{this.serverName, userId, assetGUID, tagGUID});
    }

    public void addTagToElement(String userId, String elementGUID, String tagGUID, boolean isPublic) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addTagToElement";
        String elementGUIDParameterName = "elementGUID";
        String tagGUIDParameterName = "tagGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/elements/{2}/tags/{3}";
        this.invalidParameterHandler.validateUserId(userId, "addTagToElement");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "addTagToElement");
        this.invalidParameterHandler.validateGUID(tagGUID, "tagGUID", "addTagToElement");
        FeedbackRequestBody requestBody = new FeedbackRequestBody();
        requestBody.setIsPublic(isPublic);
        this.restClient.callVoidPostRESTCall("addTagToElement", urlTemplate, requestBody, new Object[]{this.serverName, userId, elementGUID, tagGUID});
    }

    public void removeTagFromAsset(String userId, String assetGUID, String tagGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeTagFromAsset";
        String assetGUIDParameterName = "assetGUID";
        String tagGUIDParameterName = "tagGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/{2}/tags/{3}/delete";
        this.invalidParameterHandler.validateUserId(userId, "removeTagFromAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "removeTagFromAsset");
        this.invalidParameterHandler.validateGUID(tagGUID, "tagGUID", "removeTagFromAsset");
        this.restClient.callVoidPostRESTCall("removeTagFromAsset", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, assetGUID, tagGUID});
    }

    public void removeTagFromElement(String userId, String elementGUID, String tagGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeTagFromElement";
        String elementGUIDParameterName = "elementGUID";
        String tagGUIDParameterName = "tagGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/elements/{2}/tags/{3}/delete";
        this.invalidParameterHandler.validateUserId(userId, "removeTagFromElement");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "removeTagFromElement");
        this.invalidParameterHandler.validateGUID(tagGUID, "tagGUID", "removeTagFromElement");
        this.restClient.callVoidPostRESTCall("removeTagFromElement", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, elementGUID, tagGUID});
    }

    public List<String> getAssetsByTag(String userId, String tagGUID, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getAssetsByTag";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-consumer/users/{1}/assets/by-tag/{2}?startFrom={3}&pageSize={4}";
        String tagGUIDParameterName = "tagGUID";
        this.invalidParameterHandler.validateUserId(userId, "getAssetsByTag");
        this.invalidParameterHandler.validateGUID(tagGUID, "tagGUID", "getAssetsByTag");
        GUIDListResponse restResult = this.restClient.callGUIDListGetRESTCall("getAssetsByTag", urlTemplate, new Object[]{this.serverName, userId, tagGUID, startFrom, pageSize});
        return restResult.getGUIDs();
    }
}

