/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.fvt.tagging;

import java.util.List;
import org.odpi.openmetadata.accessservices.assetconsumer.client.AssetConsumer;
import org.odpi.openmetadata.accessservices.assetconsumer.client.rest.AssetConsumerRESTClient;
import org.odpi.openmetadata.accessservices.assetconsumer.elements.InformalTagElement;
import org.odpi.openmetadata.accessservices.assetconsumer.fvt.setup.AssetOwnerFactory;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.InformalTagProperties;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

public class CreateTagTest {
    private static final String testCaseName = "CreateTagTest";
    private static final int maxPageSize = 100;
    private static final String publicTag1Name = "TestPublicTag1";
    private static final String publicTag1Description = "PublicTag1 description";
    private static final String publicTag2Name = "TestPublicTag2";
    private static final String publicTag2Description = "PublicTag2 description";
    private static final String privateTagName = "TestPrivateTag";
    private static final String privateTagDescription1 = "PrivateTag description1";
    private static final String privateTagDescription2 = "PrivateTag description2";
    private static final String differentUser = "newUserId";
    private static final String searchStringGetAll = "PrivateTag description";
    private static final String searchStringGetNone = "PrivateTag description";
    private static final String searchStringGetPrivate = "PrivateTag description";

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL, String userId) {
        FVTResults results = new FVTResults(testCaseName);
        results.incrementNumberOfTests();
        try {
            CreateTagTest.runIt(serverPlatformRootURL, serverName, userId, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        System.out.println(results.toString());
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, String userId, FVTAuditLogDestination auditLogDestination) throws FVTUnexpectedCondition {
        CreateTagTest thisTest = new CreateTagTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.ASSET_CONSUMER_OMAS.getAccessServiceCode(), AccessServiceDescription.ASSET_CONSUMER_OMAS.getAccessServiceName(), AccessServiceDescription.ASSET_CONSUMER_OMAS.getAccessServiceDescription(), AccessServiceDescription.ASSET_CONSUMER_OMAS.getAccessServiceWiki());
        AssetConsumer client = thisTest.getAssetConsumerClient(serverName, serverPlatformRootURL, auditLog);
        AssetOwnerFactory factory = new AssetOwnerFactory(testCaseName, serverName, serverPlatformRootURL, auditLog);
        String assetGUID = factory.getAsset(userId);
        System.out.println("AssetGUID: " + assetGUID);
        String schemaTypeGUID = factory.getSchemaType(userId, assetGUID);
        System.out.println("SchemaTypeGUID: " + schemaTypeGUID);
        String asset2GUID = factory.getAssetFromTemplate(userId, assetGUID);
        System.out.println("Asset2GUID: " + asset2GUID);
        String publicTagGUID = thisTest.getPublicTag(client, userId);
        System.out.println("PublicTagGUID: " + publicTagGUID);
    }

    private AssetConsumer getAssetConsumerClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "getAssetConsumerClient";
        try {
            AssetConsumerRESTClient restClient = new AssetConsumerRESTClient(serverName, serverPlatformRootURL);
            return new AssetConsumer(serverName, serverPlatformRootURL, restClient, 100, auditLog);
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getAssetConsumerClient", unexpectedError);
        }
    }

    private String getPublicTag(AssetConsumer client, String userId) throws FVTUnexpectedCondition {
        String methodName = "getPublicTag";
        try {
            String activityName = "getPublicTag::createPrivateTag";
            System.out.println();
            String privateTagGUID = client.createPrivateTag(userId, privateTagName, privateTagDescription1);
            if (privateTagGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no GUID for create of private tag)");
            }
            activityName = "getPublicTag::getAfterCreatePrivateTag";
            InformalTagElement retrievedElement = client.getTag(userId, privateTagGUID);
            InformalTagProperties retrievedTag = retrievedElement.getInformalTagProperties();
            if (retrievedTag == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no PrivateTag from Retrieve of private tag)");
            }
            if (!privateTagName.equals(retrievedTag.getName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad tag name from Retrieve of private tag)");
            }
            if (!privateTagDescription1.equals(retrievedTag.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from Retrieve of private tag)");
            }
            if (!retrievedTag.getIsPrivateTag()) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Returned as public tag by Retrieve of private tag)");
            }
            if (!userId.equals(retrievedTag.getUser())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad user from Retrieve of private tag)");
            }
            activityName = "getPublicTag::getByNameAfterCreatePrivateTag";
            List privateTagList = client.getTagsByName(userId, privateTagName, 0, 100);
            if (privateTagList == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no PrivateTag for RetrieveByName of private tag)");
            }
            if (privateTagList.isEmpty()) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Empty list for RetrieveByName of private tag)");
            }
            if (privateTagList.size() != 1) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(PrivateTag list for RetrieveByName contains" + privateTagList.size() + " elements)");
            }
            retrievedElement = (InformalTagElement)privateTagList.get(0);
            retrievedTag = retrievedElement.getInformalTagProperties();
            if (!privateTagName.equals(retrievedTag.getName())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad tag name from RetrieveByName of private tag)");
            }
            if (!privateTagDescription1.equals(retrievedTag.getDescription())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from RetrieveByName of private tag)");
            }
            if (!retrievedTag.getIsPrivateTag()) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Returned as public tag by RetrieveByName of private tag)");
            }
            if (!userId.equals(retrievedTag.getUser())) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad user from RetrieveByName of private tag)");
            }
            activityName = "getPublicTag::getHiddenPrivateTag";
            try {
                retrievedElement = client.getTag(differentUser, privateTagGUID);
                if (retrievedElement == null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Null Private tag returned to wrong user");
                }
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Private tag returned to wrong user: " + retrievedElement.toString() + ")");
            }
            catch (InvalidParameterException invalidParameterException) {
                activityName = "getPublicTag::createPublicTag1";
                String publicTag1GUID = client.createPublicTag(userId, publicTag1Name, publicTag1Description);
                if (publicTag1GUID == null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(no GUID for create of public tag 1)");
                }
                activityName = "getPublicTag::getTagAfterCreatePublicTag1";
                retrievedElement = client.getTag(userId, publicTag1GUID);
                retrievedTag = retrievedElement.getInformalTagProperties();
                if (retrievedTag == null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(no PublicTag from Retrieve of public tag 1)");
                }
                if (!publicTag1Name.equals(retrievedTag.getName())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad tag name from Retrieve of public tag 1)");
                }
                if (!publicTag1Description.equals(retrievedTag.getDescription())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from Retrieve of public tag 1)");
                }
                if (!userId.equals(retrievedTag.getUser())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad user from Retrieve of public tag 1)");
                }
                activityName = "getPublicTag::getTagByNameAfterCreatePublicTag1";
                List retrievedTagList = client.getTagsByName(userId, publicTag1Name, 0, 100);
                if (retrievedTagList == null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Null result for RetrieveByName of public tag 1)");
                }
                if (retrievedTagList.isEmpty()) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Empty list for RetrieveByName of public tag 1)");
                }
                if (retrievedTagList.size() != 1) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Public tag 1 list for RetrieveByName contains" + retrievedTagList.size() + " elements)");
                }
                retrievedElement = (InformalTagElement)retrievedTagList.get(0);
                retrievedTag = retrievedElement.getInformalTagProperties();
                if (!publicTag1Name.equals(retrievedTag.getName())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad tag name from RetrieveByName of public tag 1)");
                }
                if (!publicTag1Description.equals(retrievedTag.getDescription())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description from RetrieveByName of public tag 1)");
                }
                if (!userId.equals(retrievedTag.getUser())) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad user from RetrieveByName of public tag 1)");
                }
                activityName = "getPublicTag::getTagAfterCreatePublicTag2";
                String publicTag2GUID = client.createPublicTag(userId, publicTag2Name, publicTag2Description);
                if (publicTag2GUID == null) {
                    throw new FVTUnexpectedCondition(testCaseName, activityName + "(no GUID for create of public tag 2)");
                }
                return publicTag1GUID;
            }
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Throwable unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getPublicTag", unexpectedError);
        }
    }
}

