/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.fvt;

import java.io.IOException;
import org.odpi.openmetadata.accessservices.assetconsumer.fvt.clientconstructors.ClientConstructorTest;
import org.odpi.openmetadata.accessservices.assetconsumer.fvt.errorhandling.InvalidParameterTest;
import org.odpi.openmetadata.accessservices.assetconsumer.fvt.tagging.CreateTagTest;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.FVTSuiteBase;
import org.odpi.openmetadata.http.HttpHelper;

public class AssetConsumerOMASFVTSuite
extends FVTSuiteBase {
    public static void main(String[] args) {
        int exitCode;
        try {
            String url = AssetConsumerOMASFVTSuite.getUrl((String[])args);
            String serverName = AssetConsumerOMASFVTSuite.getServerName((String[])args);
            String userId = AssetConsumerOMASFVTSuite.getUserId((String[])args);
            AssetConsumerOMASFVTSuite fvtSuite = new AssetConsumerOMASFVTSuite();
            exitCode = fvtSuite.performFVT(serverName, url, userId);
        }
        catch (IOException error) {
            System.out.println("Error getting user input");
            error.printStackTrace();
            exitCode = -99;
        }
        System.exit(exitCode);
    }

    public int performFVT(String serverName, String serverPlatformRootURL, String userId) {
        HttpHelper.noStrictSSL();
        int returnCode = 0;
        FVTResults results = ClientConstructorTest.performFVT(serverName, serverPlatformRootURL);
        if (!results.isSuccessful()) {
            --returnCode;
        }
        results.printResults(serverName);
        results = InvalidParameterTest.performFVT(serverName, serverPlatformRootURL, userId);
        if (!results.isSuccessful()) {
            --returnCode;
        }
        results.printResults(serverName);
        results = CreateTagTest.performFVT(serverName, serverPlatformRootURL, userId);
        if (!results.isSuccessful()) {
            --returnCode;
        }
        results.printResults(serverName);
        return returnCode;
    }
}

