/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.fvt.errorhandling;

import org.odpi.openmetadata.accessservices.assetconsumer.client.AssetConsumer;
import org.odpi.openmetadata.accessservices.assetconsumer.client.rest.AssetConsumerRESTClient;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

public class InvalidParameterTest {
    private static final String testCaseName = "InvalidParameterTest";
    private static final int maxPageSize = 100;

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL, String userId) {
        FVTResults results = new FVTResults(testCaseName);
        results.incrementNumberOfTests();
        try {
            InvalidParameterTest.runIt(serverPlatformRootURL, serverName, userId, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, String userId, FVTAuditLogDestination auditLogDestination) throws FVTUnexpectedCondition {
        InvalidParameterTest thisTest = new InvalidParameterTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.ASSET_CONSUMER_OMAS.getAccessServiceCode(), AccessServiceDescription.ASSET_CONSUMER_OMAS.getAccessServiceName(), AccessServiceDescription.ASSET_CONSUMER_OMAS.getAccessServiceDescription(), AccessServiceDescription.ASSET_CONSUMER_OMAS.getAccessServiceWiki());
        thisTest.testAssetConsumerClient(serverName, serverPlatformRootURL, userId, auditLog);
    }

    private void testAssetConsumerClient(String serverName, String serverPlatformRootURL, String userId, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "testAssetConsumerClient";
        try {
            AssetConsumerRESTClient restClient = new AssetConsumerRESTClient(serverName, serverPlatformRootURL);
            AssetConsumer client = new AssetConsumer(serverName, serverPlatformRootURL, restClient, 100, auditLog);
            this.testGetAssetForConnection(userId, client);
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testAssetConsumerClient", (Throwable)unexpectedError);
        }
    }

    private void testGetAssetForConnection(String userId, AssetConsumer client) throws FVTUnexpectedCondition {
        String activityName = "testGetAssetForConnection";
        try {
            this.testGetAssetForConnectionNoUserId(client);
            this.testGetAssetForConnectionNoConnection(client, userId);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testGetAssetForConnection", (Throwable)unexpectedError);
        }
    }

    private void testGetAssetForConnectionNoUserId(AssetConsumer client) throws FVTUnexpectedCondition {
        String activityName = "testGetAssetForConnectionNoUserId";
        try {
            client.getAssetForConnection(null, "guid");
            throw new FVTUnexpectedCondition(testCaseName, "testGetAssetForConnectionNoUserId");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testGetAssetForConnectionNoUserId", (Throwable)unexpectedError);
        }
    }

    private void testGetAssetForConnectionNoConnection(AssetConsumer client, String userId) throws FVTUnexpectedCondition {
        String activityName = "testGetAssetForConnectionNoConnection";
        try {
            client.getAssetForConnection(userId, null);
            throw new FVTUnexpectedCondition(testCaseName, "testGetAssetForConnectionNoConnection");
        }
        catch (InvalidParameterException invalidParameterException) {
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "testGetAssetForConnectionNoConnection", (Throwable)unexpectedError);
        }
    }
}

