/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.fvt.clientconstructors;

import org.odpi.openmetadata.accessservices.assetconsumer.client.AssetConsumer;
import org.odpi.openmetadata.accessservices.assetconsumer.client.rest.AssetConsumerRESTClient;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;

public class ClientConstructorTest {
    private static final String testCaseName = "ClientConstructorTest";
    private static final String serverUserId = "TestNPA";
    private static final String serverPassword = "TestNPAPassword";
    private static final int maxPageSize = 100;

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL) {
        FVTResults results = new FVTResults(testCaseName);
        results.incrementNumberOfTests();
        try {
            ClientConstructorTest.runIt(serverPlatformRootURL, serverName, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, FVTAuditLogDestination auditLogDestination) throws InvalidParameterException {
        ClientConstructorTest thisTest = new ClientConstructorTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.ASSET_CONSUMER_OMAS.getAccessServiceCode(), AccessServiceDescription.ASSET_CONSUMER_OMAS.getAccessServiceDevelopmentStatus(), AccessServiceDescription.ASSET_CONSUMER_OMAS.getAccessServiceName(), AccessServiceDescription.ASSET_CONSUMER_OMAS.getAccessServiceDescription(), AccessServiceDescription.ASSET_CONSUMER_OMAS.getAccessServiceWiki());
        thisTest.testAssetConsumerClient(serverName, serverPlatformRootURL, auditLog);
    }

    private void testAssetConsumerClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws InvalidParameterException {
        new AssetConsumer(serverName, serverPlatformRootURL, auditLog);
        new AssetConsumer(serverName, serverPlatformRootURL);
        new AssetConsumer(serverName, serverPlatformRootURL, serverUserId, serverPassword, auditLog);
        new AssetConsumer(serverName, serverPlatformRootURL, serverUserId, serverPassword);
        AssetConsumerRESTClient restClient = new AssetConsumerRESTClient(serverName, serverPlatformRootURL);
        new AssetConsumer(serverName, serverPlatformRootURL, restClient, 100, auditLog);
    }
}

