/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.fvt;

import org.odpi.openmetadata.accessservices.assetconsumer.client.AssetConsumer;
import org.odpi.openmetadata.accessservices.assetconsumer.client.rest.AssetConsumerRESTClient;
import org.odpi.openmetadata.accessservices.assetconsumer.fvt.AssetOwnerFactory;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetFeedback;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetUniverse;
import org.odpi.openmetadata.frameworks.connectors.properties.Comments;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Comment;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.CommentType;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

public class CommentLifecycleTest {
    private static final String testCaseName = "CommentLifecycleTest";
    private static final int maxPageSize = 100;
    private static final String publicComment1Name = "TestPublicComment1";
    private static final String publicComment1Description1 = "PublicComment1 description1";
    private static final String publicComment1Description2 = "PublicComment1 description2";
    private static final String publicComment2Name = "TestPublicComment2";
    private static final String publicComment2Description1 = "PublicComment2 description1";
    private static final String publicComment2Description2 = "PublicComment2 description2";
    private static final String privateCommentName = "TestPrivateComment";
    private static final String privateCommentDescription1 = "PrivateComment description1";
    private static final String privateCommentDescription2 = "PrivateComment description2";
    private static final String differentUser = "newUserId";
    private static final String searchStringGetAll = "Comment";
    private static final String searchStringGetNone = "Blah";
    private static final String searchStringGetPrivate = "Private";

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL, String userId) {
        FVTResults results = new FVTResults(testCaseName);
        results.incrementNumberOfTests();
        try {
            CommentLifecycleTest.runIt(serverPlatformRootURL, serverName, userId, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        System.out.println(results);
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, String userId, FVTAuditLogDestination auditLogDestination) throws FVTUnexpectedCondition {
        CommentLifecycleTest thisTest = new CommentLifecycleTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.ASSET_CONSUMER_OMAS.getAccessServiceCode(), AccessServiceDescription.ASSET_CONSUMER_OMAS.getAccessServiceDevelopmentStatus(), AccessServiceDescription.ASSET_CONSUMER_OMAS.getAccessServiceName(), AccessServiceDescription.ASSET_CONSUMER_OMAS.getAccessServiceDescription(), AccessServiceDescription.ASSET_CONSUMER_OMAS.getAccessServiceWiki());
        AssetConsumer client = thisTest.getAssetConsumerClient(serverName, serverPlatformRootURL, auditLog);
        AssetOwnerFactory factory = new AssetOwnerFactory(testCaseName, serverName, serverPlatformRootURL, auditLog);
        String assetGUID = factory.getAsset(userId);
        System.out.println("AssetGUID: " + assetGUID);
        String schemaTypeGUID = factory.getSchemaType(userId, assetGUID);
        System.out.println("SchemaTypeGUID: " + schemaTypeGUID);
        String asset2GUID = factory.getAssetFromTemplate(userId, assetGUID);
        System.out.println("Asset2GUID: " + asset2GUID);
        String publicComment1GUID = thisTest.getCommentTest(client, userId, assetGUID, CommentType.QUESTION, publicComment1Description1, true, "getPublicComment", publicComment1Name);
        System.out.println("PublicComment1GUID: " + publicComment1GUID);
        String publicComment2GUID = thisTest.getCommentTest(client, userId, asset2GUID, CommentType.USAGE_EXPERIENCE, publicComment2Description1, true, "getPublicComment", publicComment2Name);
        System.out.println("PublicComment2GUID: " + publicComment2GUID);
        String privateCommentGUID = thisTest.getCommentTest(client, userId, assetGUID, CommentType.SUGGESTION, privateCommentDescription1, false, "getPrivateComment", privateCommentName);
        System.out.println("PrivateCommentGUID: " + privateCommentGUID);
        thisTest.updateCommentTest(client, userId, assetGUID, publicComment1GUID, CommentType.STANDARD_COMMENT, publicComment1Description2, false, "updatePublicComment1", publicComment1Name);
        thisTest.updateCommentTest(client, userId, asset2GUID, publicComment2GUID, CommentType.STANDARD_COMMENT, publicComment2Description2, false, "updatePublicComment2", publicComment2Name);
        thisTest.updateCommentTest(client, userId, assetGUID, privateCommentGUID, CommentType.STANDARD_COMMENT, privateCommentDescription2, true, "updatePrivateComment", privateCommentName);
    }

    private AssetConsumer getAssetConsumerClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "getAssetConsumerClient";
        try {
            AssetConsumerRESTClient restClient = new AssetConsumerRESTClient(serverName, serverPlatformRootURL);
            return new AssetConsumer(serverName, serverPlatformRootURL, restClient, 100, auditLog);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getAssetConsumerClient", (Throwable)unexpectedError);
        }
    }

    private String getCommentTest(AssetConsumer client, String userId, String assetGUID, CommentType commentType, String commentText, boolean isPublic, String testCaseName, String commentTypeName) throws FVTUnexpectedCondition {
        try {
            String activityName = testCaseName + "::create" + commentTypeName;
            System.out.println();
            String commentGUID = client.addCommentToAsset(userId, assetGUID, commentType, commentText, isPublic);
            if (commentGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(no GUID for create of " + commentTypeName + ")");
            }
            AssetUniverse assetProperties = client.getAssetProperties(userId, assetGUID);
            AssetFeedback feedback = assetProperties.getFeedback();
            Comments comments = feedback.getComments();
            while (comments.hasNext()) {
                Comment nextComment = comments.next();
                if (!nextComment.getGUID().equals(commentGUID)) continue;
                if (commentType.equals((Object)nextComment.getCommentType())) {
                    this.validateComment(nextComment, userId, commentType, commentText, isPublic, activityName, commentTypeName);
                }
                return commentGUID;
            }
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(Comment " + commentTypeName + " not attached to asset: " + assetGUID + ")");
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, testCaseName, (Throwable)unexpectedError);
        }
    }

    private void updateCommentTest(AssetConsumer client, String userId, String assetGUID, String commentGUID, CommentType commentType, String newCommentDescription, boolean isPublic, String testCaseName, String commentTypeName) throws FVTUnexpectedCondition {
        try {
            String activityName = testCaseName + "::update" + commentTypeName;
            System.out.println();
            client.updateComment(userId, assetGUID, commentGUID, commentType, newCommentDescription, isPublic);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, testCaseName, (Throwable)unexpectedError);
        }
    }

    private void validateComment(Comment retrievedComment, String userId, CommentType commentType, String commentDescription, boolean isPublic, String activityName, String commentTypeName) throws FVTUnexpectedCondition {
        if (!commentDescription.equals(retrievedComment.getCommentText())) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad description <" + retrievedComment.getCommentText() + "> from Retrieve of " + commentTypeName + ")");
        }
        if (!commentType.equals((Object)retrievedComment.getCommentType())) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad commentType <" + retrievedComment.getCommentText() + "> from Retrieve of " + commentTypeName + ")");
        }
        if (isPublic) {
            if (!retrievedComment.getIsPublic()) {
                throw new FVTUnexpectedCondition(testCaseName, activityName + "(Returned as private comment by Retrieve of " + commentTypeName + ")");
            }
        } else if (retrievedComment.getIsPublic()) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(Returned as public comment by Retrieve of " + commentTypeName + ")");
        }
        if (!userId.equals(retrievedComment.getUser())) {
            throw new FVTUnexpectedCondition(testCaseName, activityName + "(Bad user from Retrieve of " + commentTypeName + ")");
        }
    }
}

