/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.fvt;

import java.util.HashMap;
import org.odpi.openmetadata.accessservices.assetowner.client.AssetOwner;
import org.odpi.openmetadata.accessservices.assetowner.client.rest.AssetOwnerRESTClient;
import org.odpi.openmetadata.accessservices.assetowner.properties.AssetProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.SchemaTypeProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.TemplateProperties;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

public class AssetOwnerFactory {
    private static final String assetName = "TestAssetAnchor";
    private static final String assetDisplayName = "Asset displayName";
    private static final String assetDescription = "Asset description";
    private static final String assetAdditionalPropertyName = "TestAsset additionalPropertyName";
    private static final String assetAdditionalPropertyValue = "TestAsset additionalPropertyValue";
    private static final String schemaTypeName = "TestSchemaType";
    private static final String schemaTypeDisplayName = "SchemaType displayName";
    private static final String schemaTypeDescription = "SchemaType description";
    private static final String schemaTypeType = "SchemaType type";
    private static final String schemaTypeDefaultValue = "SchemaType defaultValue";
    private final String testCaseName;
    private final AssetOwner client;

    public AssetOwnerFactory(String testCaseName, String serverName, String serverPlatformRootURL, AuditLog auditLog) throws FVTUnexpectedCondition {
        this.testCaseName = testCaseName;
        this.client = this.getAssetOwnerClient(serverName, serverPlatformRootURL, auditLog);
    }

    private AssetOwner getAssetOwnerClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "getAssetOwnerClient";
        try {
            AssetOwnerRESTClient restClient = new AssetOwnerRESTClient(serverName, serverPlatformRootURL);
            int maxPageSize = 100;
            return new AssetOwner(serverName, serverPlatformRootURL, restClient, 100, auditLog);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(this.testCaseName, "getAssetOwnerClient", (Throwable)unexpectedError);
        }
    }

    public String getAsset(String userId) throws FVTUnexpectedCondition {
        String activityName = "getAsset";
        try {
            HashMap<String, String> additionalProperties = new HashMap<String, String>();
            additionalProperties.put(assetAdditionalPropertyName, assetAdditionalPropertyValue);
            AssetProperties properties = new AssetProperties();
            properties.setTypeName("Asset");
            properties.setQualifiedName(this.testCaseName + ":TestAssetAnchor");
            properties.setDisplayName(assetDisplayName);
            properties.setDescription(assetDescription);
            properties.setAdditionalProperties(additionalProperties);
            String assetGUID = this.client.addAssetToCatalog(userId, properties);
            if (assetGUID == null) {
                throw new FVTUnexpectedCondition(this.testCaseName, "getAsset(no GUID for Create)");
            }
            return assetGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(this.testCaseName, "getAsset", (Throwable)unexpectedError);
        }
    }

    public String getAssetFromTemplate(String userId, String templateGUID) throws FVTUnexpectedCondition {
        String activityName = "getAsset";
        try {
            HashMap<String, String> additionalProperties = new HashMap<String, String>();
            additionalProperties.put(assetAdditionalPropertyName, assetAdditionalPropertyValue);
            TemplateProperties properties = new TemplateProperties();
            properties.setQualifiedName(this.testCaseName + ":TestAssetAnchor-2");
            properties.setDisplayName("Asset displayName-2");
            properties.setDescription("Asset description-2");
            String assetGUID = this.client.addAssetToCatalogUsingTemplate(userId, templateGUID, properties);
            if (assetGUID == null) {
                throw new FVTUnexpectedCondition(this.testCaseName, "getAsset(no GUID for Create)");
            }
            return assetGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(this.testCaseName, "getAsset", (Throwable)unexpectedError);
        }
    }

    public String getSchemaType(String userId, String assetGUID) throws FVTUnexpectedCondition {
        String activityName = "getSchemaType";
        try {
            SchemaTypeProperties properties = new SchemaTypeProperties();
            properties.setQualifiedName(this.testCaseName + ":TestSchemaType");
            properties.setDisplayName(schemaTypeDisplayName);
            properties.setDescription(schemaTypeDescription);
            properties.setTypeName("PrimitiveSchemaType");
            HashMap<String, String> extendedProperties = new HashMap<String, String>();
            extendedProperties.put("dataType", schemaTypeType);
            extendedProperties.put("defaultValue", schemaTypeDefaultValue);
            properties.setExtendedProperties(extendedProperties);
            String schemaTypeGUID = this.client.addSchemaTypeToAsset(userId, assetGUID, properties);
            if (schemaTypeGUID == null) {
                throw new FVTUnexpectedCondition(this.testCaseName, "getSchemaType(no GUID for Create)");
            }
            return schemaTypeGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(this.testCaseName, "getSchemaType", (Throwable)unexpectedError);
        }
    }
}

