/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.admin;

import org.odpi.openmetadata.accessservices.assetconsumer.auditlog.AssetConsumerAuditCode;
import org.odpi.openmetadata.accessservices.assetconsumer.listener.AssetConsumerOMRSTopicListener;
import org.odpi.openmetadata.accessservices.assetconsumer.server.AssetConsumerRESTServices;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceAdmin;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class AssetConsumerAdmin
implements AccessServiceAdmin {
    private OMRSRepositoryConnector repositoryConnector = null;
    private OMRSTopicConnector omrsTopicConnector = null;
    private AccessServiceConfig accessServiceConfig = null;
    private OMRSAuditLog auditLog = null;
    private String serverUserName = null;
    private AssetConsumerOMRSTopicListener omrsTopicListener = null;

    public void initialize(AccessServiceConfig accessServiceConfigurationProperties, OMRSTopicConnector enterpriseOMRSTopicConnector, OMRSRepositoryConnector enterpriseOMRSRepositoryConnector, OMRSAuditLog auditLog, String serverUserName) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        AssetConsumerAuditCode auditCode = AssetConsumerAuditCode.SERVICE_INITIALIZING;
        auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
        this.repositoryConnector = enterpriseOMRSRepositoryConnector;
        AssetConsumerRESTServices.setRepositoryConnector(accessServiceConfigurationProperties.getAccessServiceName(), this.repositoryConnector);
        this.accessServiceConfig = accessServiceConfigurationProperties;
        this.omrsTopicConnector = enterpriseOMRSTopicConnector;
        if (this.omrsTopicConnector != null) {
            auditCode = AssetConsumerAuditCode.SERVICE_REGISTERED_WITH_TOPIC;
            auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
            this.omrsTopicListener = new AssetConsumerOMRSTopicListener(this.accessServiceConfig.getAccessServiceOutTopic(), this.repositoryConnector.getRepositoryHelper(), this.repositoryConnector.getRepositoryValidator(), this.accessServiceConfig.getAccessServiceName());
            this.omrsTopicConnector.registerListener((OMRSTopicListener)this.omrsTopicListener);
        }
        this.auditLog = auditLog;
        this.serverUserName = serverUserName;
        auditCode = AssetConsumerAuditCode.SERVICE_INITIALIZED;
        auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        AssetConsumerAuditCode auditCode = AssetConsumerAuditCode.SERVICE_SHUTDOWN;
        this.auditLog.logRecord("shutdown", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
    }
}

