/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.server;

import java.util.HashMap;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetconsumer.admin.AssetConsumerAdmin;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.AssetConsumerErrorCode;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.AmbiguousConnectionNameException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.AssetConsumerCheckedExceptionBase;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UnrecognizedConnectionGUIDException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UnrecognizedConnectionNameException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.AssetConsumerOMASAPIResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.CommentRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.ConnectionResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.GUIDResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.LogRecordRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.NullRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.RatingRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.TagRequestBody;
import org.odpi.openmetadata.accessservices.assetconsumer.rest.VoidResponse;
import org.odpi.openmetadata.accessservices.assetconsumer.server.AuditLogHandler;
import org.odpi.openmetadata.accessservices.assetconsumer.server.ConnectionHandler;
import org.odpi.openmetadata.accessservices.assetconsumer.server.FeedbackHandler;
import org.odpi.openmetadata.adminservices.OMAGAccessServiceRegistration;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceOperationalStatus;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceRegistration;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.CommentType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.StarRating;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetConsumerRESTServices {
    private static String accessServiceName = null;
    private static OMRSRepositoryConnector repositoryConnector = null;
    private static final Logger log = LoggerFactory.getLogger(AssetConsumerRESTServices.class);

    public static void setRepositoryConnector(String accessServiceName, OMRSRepositoryConnector repositoryConnector) {
        AssetConsumerRESTServices.accessServiceName = accessServiceName;
        AssetConsumerRESTServices.repositoryConnector = repositoryConnector;
    }

    public AssetConsumerRESTServices() {
        AccessServiceDescription myDescription = AccessServiceDescription.ASSET_CONSUMER_OMAS;
        AccessServiceRegistration myRegistration = new AccessServiceRegistration(myDescription.getAccessServiceCode(), myDescription.getAccessServiceName(), myDescription.getAccessServiceDescription(), myDescription.getAccessServiceWiki(), AccessServiceOperationalStatus.ENABLED, AssetConsumerAdmin.class.getName());
        OMAGAccessServiceRegistration.registerAccessService((AccessServiceRegistration)myRegistration);
    }

    public ConnectionResponse getConnectionByName(String userId, String name) {
        String methodName = "getConnectionByName";
        log.debug("Calling method: getConnectionByName");
        ConnectionResponse response = new ConnectionResponse();
        try {
            this.validateInitialization("getConnectionByName");
            ConnectionHandler connectionHandler = new ConnectionHandler(accessServiceName, repositoryConnector);
            response.setConnection(connectionHandler.getConnectionByName(userId, name));
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (UnrecognizedConnectionNameException error) {
            this.captureUnrecognizedConnectionNameException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (AmbiguousConnectionNameException error) {
            this.captureAmbiguousConnectionNameException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((AssetConsumerOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getConnectionByName with response: " + response.toString());
        return response;
    }

    public ConnectionResponse getConnectionByGUID(String userId, String guid) {
        String methodName = "getConnectionByGUID";
        log.debug("Calling method: getConnectionByGUID");
        ConnectionResponse response = new ConnectionResponse();
        try {
            this.validateInitialization("getConnectionByGUID");
            ConnectionHandler connectionHandler = new ConnectionHandler(accessServiceName, repositoryConnector);
            response.setConnection(connectionHandler.getConnectionByGUID(userId, guid));
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (UnrecognizedConnectionGUIDException error) {
            this.captureUnrecognizedConnectionGUIDException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((AssetConsumerOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: getConnectionByGUID with response: " + response.toString());
        return response;
    }

    public VoidResponse addLogMessageToAsset(String userId, String guid, LogRecordRequestBody requestBody) {
        String methodName = "addLogMessageToAsset";
        log.debug("Calling method: addLogMessageToAsset");
        VoidResponse response = new VoidResponse();
        try {
            this.validateInitialization("addLogMessageToAsset");
            String connectorInstanceId = null;
            String connectionName = null;
            String connectorType = null;
            String contextId = null;
            String message = null;
            if (requestBody != null) {
                connectorInstanceId = requestBody.getConnectorInstanceId();
                connectionName = requestBody.getConnectionName();
                connectorType = requestBody.getConnectorType();
                contextId = requestBody.getContextId();
                message = requestBody.getMessage();
            }
            AuditLogHandler auditLogHandler = new AuditLogHandler(accessServiceName, repositoryConnector);
            auditLogHandler.addLogMessageToAsset(userId, guid, connectorInstanceId, connectionName, connectorType, contextId, message);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((AssetConsumerOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: addLogMessageToAsset with response: " + response.toString());
        return response;
    }

    public GUIDResponse addTagToAsset(String userId, String guid, TagRequestBody requestBody) {
        String methodName = "addTagToAsset";
        log.debug("Calling method: addTagToAsset");
        GUIDResponse response = new GUIDResponse();
        try {
            this.validateInitialization("addTagToAsset");
            String tagName = null;
            String tagDescription = null;
            if (requestBody != null) {
                tagName = requestBody.getTagName();
                tagDescription = requestBody.getTagDescription();
            }
            FeedbackHandler feedbackHandler = new FeedbackHandler(accessServiceName, repositoryConnector);
            response.setGUID(feedbackHandler.addTagToAsset(userId, guid, tagName, tagDescription));
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((AssetConsumerOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: addTagToAsset with response: " + response.toString());
        return response;
    }

    public GUIDResponse addPrivateTagToAsset(String userId, String guid, TagRequestBody requestBody) {
        String methodName = "addPrivateTagToAsset";
        log.debug("Calling method: addPrivateTagToAsset");
        GUIDResponse response = new GUIDResponse();
        try {
            this.validateInitialization("addPrivateTagToAsset");
            String tagName = null;
            String tagDescription = null;
            if (requestBody != null) {
                tagName = requestBody.getTagName();
                tagDescription = requestBody.getTagDescription();
            }
            FeedbackHandler feedbackHandler = new FeedbackHandler(accessServiceName, repositoryConnector);
            response.setGUID(feedbackHandler.addPrivateTagToAsset(userId, guid, tagName, tagDescription));
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((AssetConsumerOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: addPrivateTagToAsset with response: " + response.toString());
        return response;
    }

    public GUIDResponse addRatingToAsset(String userId, String guid, RatingRequestBody requestBody) {
        String methodName = "addRatingToAsset";
        log.debug("Calling method: addRatingToAsset");
        GUIDResponse response = new GUIDResponse();
        try {
            this.validateInitialization("addRatingToAsset");
            StarRating starRating = null;
            String review = null;
            if (requestBody != null) {
                starRating = requestBody.getStarRating();
                review = requestBody.getReview();
            }
            FeedbackHandler feedbackHandler = new FeedbackHandler(accessServiceName, repositoryConnector);
            response.setGUID(feedbackHandler.addRatingToAsset(userId, guid, starRating, review));
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((AssetConsumerOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: addRatingToAsset with response: " + response.toString());
        return response;
    }

    public GUIDResponse addLikeToAsset(String userId, String guid, NullRequestBody requestBody) {
        String methodName = "addLikeToAsset";
        log.debug("Calling method: addLikeToAsset");
        GUIDResponse response = new GUIDResponse();
        try {
            this.validateInitialization("addLikeToAsset");
            FeedbackHandler feedbackHandler = new FeedbackHandler(accessServiceName, repositoryConnector);
            response.setGUID(feedbackHandler.addLikeToAsset(userId, guid));
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((AssetConsumerOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: addLikeToAsset with response: " + response.toString());
        return response;
    }

    public GUIDResponse addCommentToAsset(String userId, String guid, CommentRequestBody requestBody) {
        String methodName = "addCommentToAsset";
        log.debug("Calling method: addCommentToAsset");
        GUIDResponse response = new GUIDResponse();
        try {
            this.validateInitialization("addCommentToAsset");
            CommentType commentType = null;
            String commentText = null;
            if (requestBody != null) {
                commentType = requestBody.getCommentType();
                commentText = requestBody.getCommentText();
            }
            FeedbackHandler feedbackHandler = new FeedbackHandler(accessServiceName, repositoryConnector);
            response.setGUID(feedbackHandler.addCommentToAsset(userId, guid, commentType, commentText));
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((AssetConsumerOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: addCommentToAsset with response: " + response.toString());
        return response;
    }

    public GUIDResponse addCommentReply(String userId, String commentGUID, CommentRequestBody requestBody) {
        String methodName = "addCommentReply";
        log.debug("Calling method: addCommentReply");
        GUIDResponse response = new GUIDResponse();
        try {
            this.validateInitialization("addCommentReply");
            CommentType commentType = null;
            String commentText = null;
            if (requestBody != null) {
                commentType = requestBody.getCommentType();
                commentText = requestBody.getCommentText();
            }
            FeedbackHandler feedbackHandler = new FeedbackHandler(accessServiceName, repositoryConnector);
            response.setGUID(feedbackHandler.addCommentReply(userId, commentGUID, commentType, commentText));
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((AssetConsumerOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: addCommentReply with response: " + response.toString());
        return response;
    }

    public VoidResponse removeTag(String userId, String guid, NullRequestBody requestBody) {
        String methodName = "removeTag";
        log.debug("Calling method: removeTag");
        VoidResponse response = new VoidResponse();
        try {
            this.validateInitialization("removeTag");
            FeedbackHandler feedbackHandler = new FeedbackHandler(accessServiceName, repositoryConnector);
            feedbackHandler.removeTagFromAsset(userId, guid);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((AssetConsumerOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: removeTag with response: " + response.toString());
        return response;
    }

    public VoidResponse removePrivateTag(String userId, String guid, NullRequestBody requestBody) {
        String methodName = "removePrivateTag";
        log.debug("Calling method: removePrivateTag");
        VoidResponse response = new VoidResponse();
        try {
            this.validateInitialization("removePrivateTag");
            FeedbackHandler feedbackHandler = new FeedbackHandler(accessServiceName, repositoryConnector);
            feedbackHandler.removePrivateTagFromAsset(userId, guid);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((AssetConsumerOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: removePrivateTag with response: " + response.toString());
        return response;
    }

    public VoidResponse removeRating(String userId, String guid, NullRequestBody requestBody) {
        String methodName = "removeRating";
        log.debug("Calling method: removeRating");
        VoidResponse response = new VoidResponse();
        try {
            this.validateInitialization("removeRating");
            FeedbackHandler feedbackHandler = new FeedbackHandler(accessServiceName, repositoryConnector);
            feedbackHandler.removeRatingFromAsset(userId, guid);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((AssetConsumerOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: removeRating with response: " + response.toString());
        return response;
    }

    public VoidResponse removeLike(String userId, String guid, NullRequestBody requestBody) {
        String methodName = "removeLike";
        log.debug("Calling method: removeLike");
        VoidResponse response = new VoidResponse();
        try {
            this.validateInitialization("removeLike");
            FeedbackHandler feedbackHandler = new FeedbackHandler(accessServiceName, repositoryConnector);
            feedbackHandler.removeLikeFromAsset(userId, guid);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((AssetConsumerOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: removeLike with response: " + response.toString());
        return response;
    }

    public VoidResponse removeComment(String userId, String guid, NullRequestBody requestBody) {
        String methodName = "removeComment";
        log.debug("Calling method: removeComment");
        VoidResponse response = new VoidResponse();
        try {
            this.validateInitialization("removeComment");
            FeedbackHandler feedbackHandler = new FeedbackHandler(accessServiceName, repositoryConnector);
            feedbackHandler.removeCommentFromAsset(userId, guid);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.capturePropertyServerException((AssetConsumerOMASAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((AssetConsumerOMASAPIResponse)response, error);
        }
        log.debug("Returning from method: removeComment with response: " + response.toString());
        return response;
    }

    private void captureCheckedException(AssetConsumerOMASAPIResponse response, AssetConsumerCheckedExceptionBase error, String exceptionClassName) {
        response.setRelatedHTTPCode(error.getReportedHTTPCode());
        response.setExceptionClassName(exceptionClassName);
        response.setExceptionErrorMessage(error.getErrorMessage());
        response.setExceptionSystemAction(error.getReportedSystemAction());
        response.setExceptionUserAction(error.getReportedUserAction());
    }

    private void captureCheckedException(AssetConsumerOMASAPIResponse response, AssetConsumerCheckedExceptionBase error, String exceptionClassName, Map<String, Object> exceptionProperties) {
        response.setRelatedHTTPCode(error.getReportedHTTPCode());
        response.setExceptionClassName(exceptionClassName);
        response.setExceptionErrorMessage(error.getErrorMessage());
        response.setExceptionSystemAction(error.getReportedSystemAction());
        response.setExceptionUserAction(error.getReportedUserAction());
        response.setExceptionProperties(exceptionProperties);
    }

    private void captureAmbiguousConnectionNameException(AssetConsumerOMASAPIResponse response, AmbiguousConnectionNameException error) {
        String connectionName = error.getConnectionName();
        if (connectionName != null) {
            HashMap<String, Object> exceptionProperties = new HashMap<String, Object>();
            exceptionProperties.put("connectionName", connectionName);
            this.captureCheckedException(response, (AssetConsumerCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName(), exceptionProperties);
        } else {
            this.captureCheckedException(response, (AssetConsumerCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
        }
    }

    private void captureInvalidParameterException(AssetConsumerOMASAPIResponse response, InvalidParameterException error) {
        String parameterName = error.getParameterName();
        if (parameterName != null) {
            HashMap<String, Object> exceptionProperties = new HashMap<String, Object>();
            exceptionProperties.put("parameterName", parameterName);
            this.captureCheckedException(response, (AssetConsumerCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName(), exceptionProperties);
        } else {
            this.captureCheckedException(response, (AssetConsumerCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
        }
    }

    private void capturePropertyServerException(AssetConsumerOMASAPIResponse response, PropertyServerException error) {
        this.captureCheckedException(response, (AssetConsumerCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureUnrecognizedConnectionGUIDException(AssetConsumerOMASAPIResponse response, UnrecognizedConnectionGUIDException error) {
        String connectionGUID = error.getConnectionGUID();
        if (connectionGUID != null) {
            HashMap<String, Object> exceptionProperties = new HashMap<String, Object>();
            exceptionProperties.put("connectionGUID", connectionGUID);
            this.captureCheckedException(response, (AssetConsumerCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName(), exceptionProperties);
        } else {
            this.captureCheckedException(response, (AssetConsumerCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
        }
    }

    private void captureUnrecognizedConnectionNameException(AssetConsumerOMASAPIResponse response, UnrecognizedConnectionNameException error) {
        String connectionName = error.getConnectionName();
        if (connectionName != null) {
            HashMap<String, Object> exceptionProperties = new HashMap<String, Object>();
            exceptionProperties.put("connectionName", connectionName);
            this.captureCheckedException(response, (AssetConsumerCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName(), exceptionProperties);
        } else {
            this.captureCheckedException(response, (AssetConsumerCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
        }
    }

    private void captureUserNotAuthorizedException(AssetConsumerOMASAPIResponse response, UserNotAuthorizedException error) {
        String userId = error.getUserId();
        if (userId != null) {
            HashMap<String, Object> exceptionProperties = new HashMap<String, Object>();
            exceptionProperties.put("userId", userId);
            this.captureCheckedException(response, (AssetConsumerCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName(), exceptionProperties);
        } else {
            this.captureCheckedException(response, (AssetConsumerCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
        }
    }

    private void validateInitialization(String methodName) throws PropertyServerException {
        if (repositoryConnector == null) {
            AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.SERVICE_NOT_INITIALIZED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }
}

