/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.server;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.AssetConsumerErrorCode;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.AmbiguousConnectionNameException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UnrecognizedConnectionGUIDException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UnrecognizedConnectionNameException;
import org.odpi.openmetadata.accessservices.assetconsumer.server.ErrorHandler;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementOrigin;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

class ConnectionHandler {
    private static final String connectionTypeGUID = "114e9f8f-5ff3-4c32-bd37-a7eb42712253";
    private static final String connectionConnectorTypeRelationshipGUID = "e542cfc1-0b4b-42b9-9921-f0a5a88aaf96";
    private static final String connectionEndpointRelationshipGUID = "887a7132-d6bc-4b92-a483-e80b60c86fb2";
    private static final String qualifiedNamePropertyName = "qualifiedName";
    private static final String displayNamePropertyName = "displayName";
    private static final String additionalPropertiesName = "additionalProperties";
    private static final String securePropertiesName = "securedProperties";
    private static final String descriptionPropertyName = "description";
    private static final String connectorProviderPropertyName = "connectorProviderClassName";
    private static final String endpointPropertyName = "name";
    private static final String endpointAddressPropertyName = "networkAddress";
    private static final String endpointProtocolPropertyName = "protocol";
    private static final String endpointEncryptionPropertyName = "encryptionMethod";
    private String serviceName;
    private OMRSRepositoryHelper repositoryHelper = null;
    private String serverName = null;
    private ErrorHandler errorHandler = null;

    ConnectionHandler(String serviceName, OMRSRepositoryConnector repositoryConnector) {
        this.serviceName = serviceName;
        if (repositoryConnector != null) {
            this.repositoryHelper = repositoryConnector.getRepositoryHelper();
            this.serverName = repositoryConnector.getServerName();
            this.errorHandler = new ErrorHandler(repositoryConnector);
        }
    }

    Connection getConnectionByName(String userId, String name) throws InvalidParameterException, UnrecognizedConnectionNameException, AmbiguousConnectionNameException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "getConnectionByName";
        String nameParameter = endpointPropertyName;
        this.errorHandler.validateUserId(userId, "getConnectionByName");
        this.errorHandler.validateName(name, endpointPropertyName, "getConnectionByName");
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector("getConnectionByName");
        try {
            InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, qualifiedNamePropertyName, name, "getConnectionByName");
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, displayNamePropertyName, name, "getConnectionByName");
            List connections = metadataCollection.findEntitiesByProperty(userId, connectionTypeGUID, properties, MatchCriteria.ANY, 0, null, null, null, null, null, 2);
            if (connections == null) {
                AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.CONNECTION_NOT_FOUND;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, this.serverName, null});
                throw new UnrecognizedConnectionNameException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getConnectionByName", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), name);
            }
            if (connections.isEmpty()) {
                AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.CONNECTION_NOT_FOUND;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, this.serverName, null});
                throw new UnrecognizedConnectionNameException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getConnectionByName", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), name);
            }
            if (connections.size() > 1) {
                AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.TOO_MANY_CONNECTIONS;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{name, this.serverName, Integer.toString(connections.size())});
                throw new AmbiguousConnectionNameException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getConnectionByName", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), name);
            }
            return this.getConnectionFromRepository(userId, metadataCollection, (EntityDetail)connections.get(0));
        }
        catch (UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, "getConnectionByName", this.serverName, this.serviceName);
        }
        catch (AmbiguousConnectionNameException | UnrecognizedConnectionNameException error) {
            throw error;
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, "getConnectionByName", this.serverName, this.serviceName);
        }
        return null;
    }

    Connection getConnectionByGUID(String userId, String guid) throws InvalidParameterException, UnrecognizedConnectionGUIDException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "getConnectionByGUID";
        String guidParameter = "guid";
        this.errorHandler.validateUserId(userId, "getConnectionByGUID");
        this.errorHandler.validateGUID(guid, "guid", "getConnectionByGUID");
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector("getConnectionByGUID");
        EntityDetail connectionEntity = null;
        try {
            connectionEntity = metadataCollection.getEntityDetail(userId, guid);
        }
        catch (EntityNotKnownException error) {
            AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.CONNECTION_NOT_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{guid, this.serverName, error.getErrorMessage()});
            throw new UnrecognizedConnectionGUIDException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getConnectionByGUID", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), guid);
        }
        catch (EntityProxyOnlyException error) {
            AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.PROXY_CONNECTION_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{guid, this.serverName, error.getErrorMessage()});
            throw new UnrecognizedConnectionGUIDException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getConnectionByGUID", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), guid);
        }
        catch (UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, "getConnectionByGUID", this.serverName, this.serviceName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, "getConnectionByGUID", this.serverName, this.serviceName);
        }
        if (connectionEntity != null) {
            return this.getConnectionFromRepository(userId, metadataCollection, connectionEntity);
        }
        return null;
    }

    private Connection getConnectionFromRepository(String userId, OMRSMetadataCollection metadataCollection, EntityDetail connectionEntity) throws PropertyServerException {
        String methodName = "getConnectionFromRepository";
        ConnectorType connectorType = this.getConnectorTypeFromRepository(userId, metadataCollection, connectionEntity);
        Endpoint endpoint = this.getEndpointFromRepository(userId, metadataCollection, connectionEntity);
        Connection connection = new Connection();
        connection.setGUID(connectionEntity.getGUID());
        connection.setURL(connectionEntity.getInstanceURL());
        connection.setType(this.getElementType((InstanceHeader)connectionEntity));
        connection.setQualifiedName(this.repositoryHelper.getStringProperty(this.serviceName, qualifiedNamePropertyName, connectionEntity.getProperties(), "getConnectionFromRepository"));
        connection.setDisplayName(this.repositoryHelper.getStringProperty(this.serviceName, displayNamePropertyName, connectionEntity.getProperties(), "getConnectionFromRepository"));
        connection.setDescription(this.repositoryHelper.getStringProperty(this.serviceName, descriptionPropertyName, connectionEntity.getProperties(), "getConnectionFromRepository"));
        connection.setConnectorType(connectorType);
        connection.setEndpoint(endpoint);
        connection.setAdditionalProperties(this.getAdditionalPropertiesFromEntity(additionalPropertiesName, connectionEntity.getProperties(), "getConnectionFromRepository"));
        connection.setSecuredProperties(this.getAdditionalPropertiesFromEntity(securePropertiesName, connectionEntity.getProperties(), "getConnectionFromRepository"));
        return connection;
    }

    private ConnectorType getConnectorTypeFromRepository(String userId, OMRSMetadataCollection metadataCollection, EntityDetail connectionEntity) throws PropertyServerException {
        String methodName = "getConnectorTypeFromRepository";
        ConnectorType connectorType = null;
        EntityDetail endpointEntity = this.getEntityForRelationshipType(userId, connectionEntity, connectionConnectorTypeRelationshipGUID, metadataCollection, "getConnectorTypeFromRepository");
        if (endpointEntity != null) {
            connectorType = new ConnectorType();
            connectorType.setGUID(connectionEntity.getGUID());
            connectorType.setURL(connectionEntity.getInstanceURL());
            connectorType.setType(this.getElementType((InstanceHeader)connectionEntity));
            connectorType.setQualifiedName(this.repositoryHelper.getStringProperty(this.serviceName, qualifiedNamePropertyName, connectionEntity.getProperties(), "getConnectorTypeFromRepository"));
            connectorType.setDisplayName(this.repositoryHelper.getStringProperty(this.serviceName, displayNamePropertyName, connectionEntity.getProperties(), "getConnectorTypeFromRepository"));
            connectorType.setDescription(this.repositoryHelper.getStringProperty(this.serviceName, descriptionPropertyName, connectionEntity.getProperties(), "getConnectorTypeFromRepository"));
            connectorType.setConnectorProviderClassName(this.repositoryHelper.getStringProperty(this.serviceName, connectorProviderPropertyName, connectionEntity.getProperties(), "getConnectorTypeFromRepository"));
            connectorType.setAdditionalProperties(this.getAdditionalPropertiesFromEntity(additionalPropertiesName, connectionEntity.getProperties(), "getConnectorTypeFromRepository"));
        }
        return connectorType;
    }

    private Endpoint getEndpointFromRepository(String userId, OMRSMetadataCollection metadataCollection, EntityDetail connectionEntity) throws PropertyServerException {
        String methodName = "getEndpointFromRepository";
        Endpoint endpoint = null;
        EntityDetail endpointEntity = this.getEntityForRelationshipType(userId, connectionEntity, connectionEndpointRelationshipGUID, metadataCollection, "getEndpointFromRepository");
        if (endpointEntity != null) {
            endpoint = new Endpoint();
            endpoint.setGUID(connectionEntity.getGUID());
            endpoint.setURL(connectionEntity.getInstanceURL());
            endpoint.setType(this.getElementType((InstanceHeader)connectionEntity));
            endpoint.setQualifiedName(this.repositoryHelper.getStringProperty(this.serviceName, qualifiedNamePropertyName, connectionEntity.getProperties(), "getEndpointFromRepository"));
            endpoint.setDisplayName(this.repositoryHelper.getStringProperty(this.serviceName, endpointPropertyName, connectionEntity.getProperties(), "getEndpointFromRepository"));
            endpoint.setDescription(this.repositoryHelper.getStringProperty(this.serviceName, descriptionPropertyName, connectionEntity.getProperties(), "getEndpointFromRepository"));
            endpoint.setAddress(this.repositoryHelper.getStringProperty(this.serviceName, endpointAddressPropertyName, connectionEntity.getProperties(), "getEndpointFromRepository"));
            endpoint.setProtocol(this.repositoryHelper.getStringProperty(this.serviceName, endpointProtocolPropertyName, connectionEntity.getProperties(), "getEndpointFromRepository"));
            endpoint.setEncryptionMethod(this.repositoryHelper.getStringProperty(this.serviceName, endpointEncryptionPropertyName, connectionEntity.getProperties(), "getEndpointFromRepository"));
            endpoint.setAdditionalProperties(this.getAdditionalPropertiesFromEntity(additionalPropertiesName, connectionEntity.getProperties(), "getEndpointFromRepository"));
        }
        return endpoint;
    }

    private ElementType getElementType(InstanceHeader instance) {
        ElementType elementType = null;
        InstanceType instanceType = instance.getType();
        if (instanceType != null) {
            elementType = new ElementType();
            elementType.setElementTypeId(instanceType.getTypeDefGUID());
            elementType.setElementTypeName(instanceType.getTypeDefName());
            elementType.setElementTypeDescription(instanceType.getTypeDefDescription());
            elementType.setElementTypeVersion(instanceType.getTypeDefVersion());
            elementType.setElementSourceServer(this.serverName);
            elementType.setElementHomeMetadataCollectionId(instance.getMetadataCollectionId());
            switch (instance.getInstanceProvenanceType()) {
                case UNKNOWN: {
                    elementType.setElementOrigin(null);
                    break;
                }
                case CONTENT_PACK: {
                    elementType.setElementOrigin(ElementOrigin.CONTENT_PACK);
                    break;
                }
                case LOCAL_COHORT: {
                    elementType.setElementOrigin(ElementOrigin.LOCAL_COHORT);
                    break;
                }
                case EXPORT_ARCHIVE: {
                    elementType.setElementOrigin(ElementOrigin.EXPORT_ARCHIVE);
                    break;
                }
                case DEREGISTERED_REPOSITORY: {
                    elementType.setElementOrigin(ElementOrigin.DEREGISTERED_REPOSITORY);
                }
            }
        }
        return elementType;
    }

    private Map<String, Object> getAdditionalPropertiesFromEntity(String propertyName, InstanceProperties properties, String methodName) {
        Iterator additionalPropertyNames;
        InstanceProperties mapProperty = this.repositoryHelper.getMapProperty(this.serviceName, propertyName, properties, methodName);
        if (mapProperty != null && (additionalPropertyNames = mapProperty.getPropertyNames()) != null) {
            HashMap<String, Object> additionalPropertiesMap = new HashMap<String, Object>();
            while (additionalPropertyNames.hasNext()) {
                String additionalPropertyName = (String)additionalPropertyNames.next();
                InstancePropertyValue additionalPropertyValue = mapProperty.getPropertyValue(additionalPropertyName);
                if (additionalPropertyValue == null || additionalPropertyValue.getInstancePropertyCategory() != InstancePropertyCategory.PRIMITIVE) continue;
                PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)additionalPropertyValue;
                additionalPropertiesMap.put(additionalPropertyName, primitivePropertyValue.getPrimitiveValue());
            }
            if (additionalPropertiesMap.isEmpty()) {
                return null;
            }
            return additionalPropertiesMap;
        }
        return null;
    }

    private EntityDetail getEntityForRelationshipType(String userId, EntityDetail anchorEntity, String relationshipTypeGUID, OMRSMetadataCollection metadataCollection, String methodName) throws PropertyServerException {
        try {
            List relationships = metadataCollection.getRelationshipsForEntity(userId, anchorEntity.getGUID(), relationshipTypeGUID, 0, null, null, null, null, 100);
            if (relationships != null && relationships.size() == 1) {
                Relationship relationship = (Relationship)relationships.get(0);
                EntityProxy requiredEnd = relationship.getEntityOneProxy();
                if (anchorEntity.getGUID().equals(requiredEnd.getGUID())) {
                    requiredEnd = relationship.getEntityTwoProxy();
                }
                return metadataCollection.getEntityDetail(userId, requiredEnd.getGUID());
            }
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName, this.serverName, this.serviceName);
        }
        return null;
    }
}

