/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.server;

import java.util.Date;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.assetconsumer.server.ErrorHandler;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.CommentType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.StarRating;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;

class FeedbackHandler {
    private static final String informalTagTypeName = "InformalTag";
    private static final String informalTagTypeGUID = "ba846a7b-2955-40bf-952b-2793ceca090a";
    private static final String privateTagTypeName = "PrivateTag";
    private static final String privateTagTypeGUID = "9b3f5443-2475-4522-bfda-8f1f17e9a6c3";
    private static final String tagNamePropertyName = "TagName";
    private static final String tagDescriptionPropertyName = "TagDescription";
    private static final String attachedTagTypeGUID = "4b1641c4-3d1a-4213-86b2-d6968b6c65ab";
    private static final String likeTypeName = "Like";
    private static final String likeTypeGUID = "deaa5ca0-47a0-483d-b943-d91c76744e01";
    private static final String attachedLikeTypeGUID = "e2509715-a606-415d-a995-61d00503dad4";
    private static final String ratingTypeName = "Rating";
    private static final String ratingTypeGUID = "7299d721-d17f-4562-8286-bcd451814478";
    private static final String starsPropertyName = "stars";
    private static final String reviewPropertyName = "review";
    private static final String attachedRatingTypeGUID = "0aaad9e9-9cc5-4ad8-bc2e-c1099bab6344";
    private static final String commentTypeName = "Comment";
    private static final String commentTypeGUID = "1a226073-9c84-40e4-a422-fbddb9b84278";
    private static final String qualifiedNamePropertyName = "qualifiedName";
    private static final String commentPropertyName = "comment";
    private static final String commentTypePropertyName = "commentType";
    private static final String attachedCommentTypeGUID = "0d90501b-bf29-4621-a207-0c8c953bdac9";
    private String serviceName;
    private String serverName = null;
    private OMRSRepositoryHelper repositoryHelper = null;
    private ErrorHandler errorHandler = null;

    FeedbackHandler(String serviceName, OMRSRepositoryConnector repositoryConnector) {
        this.serviceName = serviceName;
        if (repositoryConnector != null) {
            this.repositoryHelper = repositoryConnector.getRepositoryHelper();
            this.serverName = repositoryConnector.getServerName();
            this.errorHandler = new ErrorHandler(repositoryConnector);
        }
    }

    String addTagToAsset(String userId, String assetGUID, String tagName, String tagDescription) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addTagToAsset";
        return this.addTagToAsset(informalTagTypeGUID, userId, assetGUID, tagName, tagDescription, "addTagToAsset");
    }

    String addPrivateTagToAsset(String userId, String assetGUID, String tagName, String tagDescription) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addPrivateTagToAsset";
        return this.addTagToAsset(privateTagTypeGUID, userId, assetGUID, tagName, tagDescription, "addPrivateTagToAsset");
    }

    private String addTagToAsset(String tagTypeGUID, String userId, String assetGUID, String tagName, String tagDescription, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameter = "assetGUID";
        String nameParameter = "tagName";
        this.errorHandler.validateUserId(userId, methodName);
        this.errorHandler.validateGUID(assetGUID, "assetGUID", methodName);
        this.errorHandler.validateName(tagName, "tagName", methodName);
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector(methodName);
        this.validateEntity(userId, assetGUID, metadataCollection, methodName);
        try {
            InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, tagNamePropertyName, tagName, methodName);
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, tagDescriptionPropertyName, tagDescription, methodName);
            EntityDetail feedbackEntity = metadataCollection.addEntity(userId, tagTypeGUID, properties, null, InstanceStatus.ACTIVE);
            String feedbackGUID = null;
            if (feedbackEntity != null) {
                feedbackGUID = feedbackEntity.getGUID();
                metadataCollection.addRelationship(userId, attachedTagTypeGUID, null, assetGUID, feedbackGUID, InstanceStatus.ACTIVE);
            }
            return feedbackGUID;
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName, this.serverName, this.serviceName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName, this.serverName, this.serviceName);
        }
        return null;
    }

    String addRatingToAsset(String userId, String assetGUID, StarRating starRating, String review) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addRatingToAsset";
        String guidParameter = "assetGUID";
        String ratingParameter = "starRating";
        this.errorHandler.validateUserId(userId, "addRatingToAsset");
        this.errorHandler.validateGUID(assetGUID, "assetGUID", "addRatingToAsset");
        this.errorHandler.validateEnum(starRating, "starRating", "addRatingToAsset");
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector("addRatingToAsset");
        this.validateEntity(userId, assetGUID, metadataCollection, "addRatingToAsset");
        try {
            InstanceProperties properties = this.addStarRatingPropertyToInstance(null, starRating, "addRatingToAsset");
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, reviewPropertyName, review, "addRatingToAsset");
            EntityDetail feedbackEntity = metadataCollection.addEntity(userId, ratingTypeGUID, properties, null, InstanceStatus.ACTIVE);
            String feedbackGUID = null;
            if (feedbackEntity != null) {
                feedbackGUID = feedbackEntity.getGUID();
                metadataCollection.addRelationship(userId, attachedRatingTypeGUID, null, assetGUID, feedbackGUID, InstanceStatus.ACTIVE);
            }
            return feedbackGUID;
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, "addRatingToAsset", this.serverName, this.serviceName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, "addRatingToAsset", this.serverName, this.serviceName);
        }
        return null;
    }

    private InstanceProperties addStarRatingPropertyToInstance(InstanceProperties properties, StarRating starRating, String methodName) {
        int ordinal = 99;
        String symbolicName = null;
        String description = null;
        boolean element1Ordinal = false;
        String element1Value = "NotRecommended";
        String element1Description = "This content is not recommended.";
        boolean element2Ordinal = true;
        String element2Value = "OneStar";
        String element2Description = "One star rating.";
        int element3Ordinal = 2;
        String element3Value = "TwoStar";
        String element3Description = "Two star rating.";
        int element4Ordinal = 3;
        String element4Value = "ThreeStar";
        String element4Description = "Three star rating.";
        int element5Ordinal = 4;
        String element5Value = "FourStar";
        String element5Description = "Four star rating.";
        int element6Ordinal = 5;
        String element6Value = "FiveStar";
        String element6Description = "Five star rating.";
        switch (starRating) {
            case NOT_RECOMMENDED: {
                ordinal = 0;
                symbolicName = "NotRecommended";
                description = "This content is not recommended.";
                break;
            }
            case ONE_STAR: {
                ordinal = 1;
                symbolicName = "OneStar";
                description = "One star rating.";
                break;
            }
            case TWO_STARS: {
                ordinal = 2;
                symbolicName = "TwoStar";
                description = "Two star rating.";
                break;
            }
            case THREE_STARS: {
                ordinal = 3;
                symbolicName = "ThreeStar";
                description = "Three star rating.";
                break;
            }
            case FOUR_STARS: {
                ordinal = 4;
                symbolicName = "FourStar";
                description = "Four star rating.";
                break;
            }
            case FIVE_STARS: {
                ordinal = 5;
                symbolicName = "FiveStar";
                description = "Five star rating.";
            }
        }
        return this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, starsPropertyName, ordinal, symbolicName, description, methodName);
    }

    String addLikeToAsset(String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addLikeToAsset";
        String guidParameter = "assetGUID";
        this.errorHandler.validateUserId(userId, "addLikeToAsset");
        this.errorHandler.validateGUID(assetGUID, "assetGUID", "addLikeToAsset");
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector("addLikeToAsset");
        this.validateEntity(userId, assetGUID, metadataCollection, "addLikeToAsset");
        try {
            EntityDetail feedbackEntity = metadataCollection.addEntity(userId, likeTypeGUID, null, null, InstanceStatus.ACTIVE);
            String feedbackGUID = null;
            if (feedbackEntity != null) {
                feedbackGUID = feedbackEntity.getGUID();
                metadataCollection.addRelationship(userId, attachedLikeTypeGUID, null, assetGUID, feedbackEntity.getGUID(), InstanceStatus.ACTIVE);
            }
            return feedbackGUID;
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, "addLikeToAsset", this.serverName, this.serviceName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, "addLikeToAsset", this.serverName, this.serviceName);
        }
        return null;
    }

    String addCommentToAsset(String userId, String assetGUID, CommentType commentType, String commentText) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addCommentToAsset";
        String guidParameter = "assetGUID";
        return this.addCommentToEntity(userId, assetGUID, "assetGUID", commentType, commentText, "addCommentToAsset");
    }

    String addCommentReply(String userId, String commentGUID, CommentType commentType, String commentText) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addCommentReply";
        String guidParameter = "assetGUID";
        return this.addCommentToEntity(userId, commentGUID, "assetGUID", commentType, commentText, "addCommentReply");
    }

    private InstanceProperties addCommentTypePropertyToInstance(InstanceProperties properties, CommentType commentType, String methodName) {
        int ordinal = 99;
        String symbolicName = null;
        String description = null;
        boolean element1Ordinal = false;
        String element1Value = "GeneralComment";
        String element1Description = "General comment.";
        boolean element2Ordinal = true;
        String element2Value = "Question";
        String element2Description = "A question.";
        int element3Ordinal = 2;
        String element3Value = "Answer";
        String element3Description = "An answer to a previously asked question.";
        int element4Ordinal = 3;
        String element4Value = "Suggestion";
        String element4Description = "A suggestion for improvement.";
        int element5Ordinal = 3;
        String element5Value = "Experience";
        String element5Description = "An account of an experience.";
        switch (commentType) {
            case STANDARD_COMMENT: {
                ordinal = 0;
                symbolicName = "GeneralComment";
                description = "General comment.";
                break;
            }
            case QUESTION: {
                ordinal = 1;
                symbolicName = "Question";
                description = "A question.";
                break;
            }
            case ANSWER: {
                ordinal = 2;
                symbolicName = "Answer";
                description = "An answer to a previously asked question.";
                break;
            }
            case SUGGESTION: {
                ordinal = 3;
                symbolicName = "Suggestion";
                description = "A suggestion for improvement.";
                break;
            }
            case USAGE_EXPERIENCE: {
                ordinal = 3;
                symbolicName = "Experience";
                description = "An account of an experience.";
            }
        }
        return this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, commentTypePropertyName, ordinal, symbolicName, description, methodName);
    }

    private String addCommentToEntity(String userId, String entityGUID, String guidParameter, CommentType commentType, String commentText, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String typeParameter = commentTypePropertyName;
        String textParameter = "commentText";
        this.errorHandler.validateUserId(userId, methodName);
        this.errorHandler.validateGUID(entityGUID, guidParameter, methodName);
        this.errorHandler.validateEnum(commentType, commentTypePropertyName, methodName);
        this.errorHandler.validateText(commentText, "commentText", methodName);
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector(methodName);
        this.validateEntity(userId, entityGUID, metadataCollection, methodName);
        try {
            InstanceProperties properties = this.addCommentTypePropertyToInstance(null, commentType, methodName);
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, qualifiedNamePropertyName, "Comment:" + userId + ":" + new Date().toString(), methodName);
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, commentPropertyName, commentText, methodName);
            EntityDetail feedbackEntity = metadataCollection.addEntity(userId, commentTypeGUID, properties, null, InstanceStatus.ACTIVE);
            String feedbackGUID = null;
            if (feedbackEntity != null) {
                feedbackGUID = feedbackEntity.getGUID();
                metadataCollection.addRelationship(userId, attachedCommentTypeGUID, null, entityGUID, feedbackEntity.getGUID(), InstanceStatus.ACTIVE);
            }
            return feedbackGUID;
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName, this.serverName, this.serviceName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName, this.serverName, this.serviceName);
        }
        return null;
    }

    void removeTagFromAsset(String userId, String tagGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeTagFromAsset";
        String guidParameter = "tagGUID";
        this.errorHandler.validateUserId(userId, "removeTagFromAsset");
        this.errorHandler.validateGUID(tagGUID, "tagGUID", "removeTagFromAsset");
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector("removeTagFromAsset");
        try {
            metadataCollection.deleteEntity(userId, informalTagTypeGUID, informalTagTypeName, tagGUID);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, "removeTagFromAsset", this.serverName, this.serviceName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, "removeTagFromAsset", this.serverName, this.serviceName);
        }
    }

    void removePrivateTagFromAsset(String userId, String tagGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removePrivateTagFromAsset";
        String guidParameter = "tagGUID";
        this.errorHandler.validateUserId(userId, "removePrivateTagFromAsset");
        this.errorHandler.validateGUID(tagGUID, "tagGUID", "removePrivateTagFromAsset");
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector("removePrivateTagFromAsset");
        try {
            metadataCollection.deleteEntity(userId, privateTagTypeGUID, privateTagTypeName, tagGUID);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, "removePrivateTagFromAsset", this.serverName, this.serviceName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, "removePrivateTagFromAsset", this.serverName, this.serviceName);
        }
    }

    void removeRatingFromAsset(String userId, String ratingGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeRatingFromAsset";
        String guidParameter = "ratingGUID";
        this.errorHandler.validateUserId(userId, "removeRatingFromAsset");
        this.errorHandler.validateGUID(ratingGUID, "ratingGUID", "removeRatingFromAsset");
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector("removeRatingFromAsset");
        try {
            metadataCollection.deleteEntity(userId, ratingTypeGUID, ratingTypeName, ratingGUID);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, "removeRatingFromAsset", this.serverName, this.serviceName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, "removeRatingFromAsset", this.serverName, this.serviceName);
        }
    }

    void removeLikeFromAsset(String userId, String likeGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeLikeFromAsset";
        String guidParameter = "likeGUID";
        this.errorHandler.validateUserId(userId, "removeLikeFromAsset");
        this.errorHandler.validateGUID(likeGUID, "likeGUID", "removeLikeFromAsset");
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector("removeLikeFromAsset");
        try {
            metadataCollection.deleteEntity(userId, likeTypeGUID, likeTypeName, likeGUID);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, "removeLikeFromAsset", this.serverName, this.serviceName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, "removeLikeFromAsset", this.serverName, this.serviceName);
        }
    }

    void removeCommentFromAsset(String userId, String commentGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeCommentFromAsset";
        String guidParameter = "commentGUID";
        this.errorHandler.validateUserId(userId, "removeCommentFromAsset");
        this.errorHandler.validateGUID(commentGUID, "commentGUID", "removeCommentFromAsset");
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector("removeCommentFromAsset");
        try {
            metadataCollection.deleteEntity(userId, commentTypeGUID, commentTypeName, commentGUID);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, "removeCommentFromAsset", this.serverName, this.serviceName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, "removeCommentFromAsset", this.serverName, this.serviceName);
        }
    }

    private void validateEntity(String userId, String assetGUID, OMRSMetadataCollection metadataCollection, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        try {
            metadataCollection.getEntitySummary(userId, assetGUID);
        }
        catch (EntityNotKnownException error) {
            this.errorHandler.handleUnknownAsset(error, assetGUID, methodName, this.serverName, this.serviceName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName, this.serverName, this.serviceName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName, this.serverName, this.serviceName);
        }
    }
}

