/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.outtopic;

import org.odpi.openmetadata.accessservices.assetconsumer.properties.Asset;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetConsumerPublisher {
    private static final String assetTypeName = "Asset";
    private static final String assetPropertyNameQualifiedName = "qualifiedName";
    private static final String assetPropertyNameDisplayName = "name";
    private static final String assetPropertyNameOwner = "owner";
    private static final String assetPropertyNameDescription = "description";
    private static final Logger log = LoggerFactory.getLogger(AssetConsumerPublisher.class);
    private Connection assetConsumerOutTopic;
    private OMRSRepositoryHelper repositoryHelper;
    private OMRSRepositoryValidator repositoryValidator;
    private String componentName;

    public AssetConsumerPublisher(Connection assetConsumerOutTopic, OMRSRepositoryHelper repositoryHelper, OMRSRepositoryValidator repositoryValidator, String componentName) {
        this.assetConsumerOutTopic = assetConsumerOutTopic;
        this.repositoryHelper = repositoryHelper;
        this.repositoryValidator = repositoryValidator;
        this.componentName = componentName;
    }

    public void processNewEntity(EntityDetail entity) {
        String assetType = this.getAssetType(entity);
        if (assetType != null) {
            this.processNewAsset(this.getAsset(entity));
        }
    }

    public void processUpdatedEntity(EntityDetail entity) {
        String assetType = this.getAssetType(entity);
        if (assetType != null) {
            this.processUpdatedAsset(this.getAsset(entity));
        }
    }

    public void processUpdatedEntity(EntityDetail originalEntity, EntityDetail newEntity) {
        String assetType = this.getAssetType(newEntity);
        if (assetType != null) {
            this.processUpdatedAsset(this.getAsset(originalEntity), this.getAsset(newEntity));
        }
    }

    public void processDeletedEntity(EntityDetail entity) {
        String assetType = this.getAssetType(entity);
        if (assetType != null) {
            this.processDeletedAsset(this.getAsset(entity));
        }
    }

    public void processRestoredEntity(EntityDetail entity) {
        String assetType = this.getAssetType(entity);
        if (assetType != null) {
            this.processRestoredAsset(this.getAsset(entity));
        }
    }

    public void processNewRelationship(Relationship relationship) {
    }

    public void processUpdatedRelationship(Relationship relationship) {
    }

    public void processUpdatedRelationship(Relationship originalRelationship, Relationship newRelationship) {
    }

    public void processDeletedRelationship(Relationship relationship) {
    }

    public void processRestoredRelationship(Relationship relationship) {
    }

    private String getAssetType(EntityDetail entity) {
        InstanceType entityType;
        String methodName = "getAssetType";
        if (this.repositoryValidator.isATypeOf(this.componentName, (InstanceAuditHeader)entity, assetTypeName, "getAssetType") && (entityType = entity.getType()) != null) {
            return entityType.getTypeDefName();
        }
        return null;
    }

    private Asset getAsset(EntityDetail entity) {
        Asset asset = new Asset();
        if (entity != null) {
            InstanceProperties instanceProperties;
            asset.setGUID(entity.getGUID());
            InstanceType instanceType = entity.getType();
            if (instanceType != null) {
                asset.setTypeName(instanceType.getTypeDefName());
                asset.setTypeDescription(instanceType.getTypeDefDescription());
            }
            if ((instanceProperties = entity.getProperties()) != null) {
                PrimitivePropertyValue primitivePropertyValue;
                InstancePropertyValue instancePropertyValue = instanceProperties.getPropertyValue(assetPropertyNameQualifiedName);
                if (instancePropertyValue != null) {
                    primitivePropertyValue = (PrimitivePropertyValue)instancePropertyValue;
                    asset.setQualifiedName(primitivePropertyValue.toString());
                }
                if ((instancePropertyValue = instanceProperties.getPropertyValue(assetPropertyNameDisplayName)) != null) {
                    primitivePropertyValue = (PrimitivePropertyValue)instancePropertyValue;
                    asset.setDisplayName(primitivePropertyValue.toString());
                }
                if ((instancePropertyValue = instanceProperties.getPropertyValue(assetPropertyNameOwner)) != null) {
                    primitivePropertyValue = (PrimitivePropertyValue)instancePropertyValue;
                    asset.setOwner(primitivePropertyValue.toString());
                }
                if ((instancePropertyValue = instanceProperties.getPropertyValue(assetPropertyNameDescription)) != null) {
                    primitivePropertyValue = (PrimitivePropertyValue)instancePropertyValue;
                    asset.setDescription(primitivePropertyValue.toString());
                }
            }
        }
        return asset;
    }

    private void processNewAsset(Asset asset) {
        log.info("Asset Consumer Event => New Asset: " + asset.toString());
    }

    private void processUpdatedAsset(Asset asset) {
        log.info("Asset Consumer Event => Updated Asset: " + asset.toString());
    }

    private void processUpdatedAsset(Asset originalAsset, Asset newAsset) {
        log.info("Asset Consumer Event => Original Asset: " + originalAsset.toString());
        log.info("Asset Consumer Event => Updated Asset: " + newAsset.toString());
    }

    private void processDeletedAsset(Asset asset) {
        log.info("Asset Consumer Event => Deleted Asset: " + asset.toString());
    }

    private void processRestoredAsset(Asset asset) {
        log.info("Asset Consumer Event => Restored Asset: " + asset.toString());
    }
}

