/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.server;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.NoProfileForUserException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.NotAnAssetException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.AssetCollection;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.AssetCollectionMember;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.AssetCollectionOrder;
import org.odpi.openmetadata.accessservices.assetconsumer.server.ErrorHandler;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class MyAssetsHandler {
    private String serviceName;
    private OMRSRepositoryHelper repositoryHelper = null;
    private String serverName = null;
    private ErrorHandler errorHandler = null;

    MyAssetsHandler(String serviceName, OMRSRepositoryConnector repositoryConnector) {
        this.serviceName = serviceName;
        if (repositoryConnector != null) {
            this.repositoryHelper = repositoryConnector.getRepositoryHelper();
            this.serverName = repositoryConnector.getServerName();
            this.errorHandler = new ErrorHandler(repositoryConnector);
        }
    }

    public List<AssetCollection> getMyAssetCollections(String userId, int startFrom, int pageSize) throws InvalidParameterException, NoProfileForUserException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getMyAssetCollections";
        this.errorHandler.validateUserId(userId, "getMyAssetCollections");
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector("getMyAssetCollections");
        return null;
    }

    public AssetCollection getAssetCollection(String userId, String assetCollectionGUID) throws InvalidParameterException, NoProfileForUserException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getAssetCollection";
        this.errorHandler.validateUserId(userId, "getAssetCollection");
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector("getAssetCollection");
        return null;
    }

    public AssetCollection createAssetCollection(String userId, String qualifiedName, String displayName, String description, String collectionUse, AssetCollectionOrder assetCollectionOrder, Map<String, Object> additionalProperties) throws InvalidParameterException, NoProfileForUserException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createAssetCollection";
        this.errorHandler.validateUserId(userId, "createAssetCollection");
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector("createAssetCollection");
        return null;
    }

    public AssetCollection attachAssetCollection(String userId, String assetCollectionGUID) throws InvalidParameterException, NoProfileForUserException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "attachAssetCollection";
        this.errorHandler.validateUserId(userId, "attachAssetCollection");
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector("attachAssetCollection");
        return null;
    }

    public void removeAssetCollection(String userId, String assetCollectionGUID) throws InvalidParameterException, NoProfileForUserException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeAssetCollection";
        this.errorHandler.validateUserId(userId, "removeAssetCollection");
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector("removeAssetCollection");
    }

    public List<AssetCollectionMember> getMyAssets(String userId, String assetCollectionGUID, int startFrom, int pageSize) throws InvalidParameterException, NoProfileForUserException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getMyAssets";
        this.errorHandler.validateUserId(userId, "getMyAssets");
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector("getMyAssets");
        return null;
    }

    public void addToMyAssets(String userId, String assetCollectionGUID, String assetGUID) throws InvalidParameterException, NoProfileForUserException, NotAnAssetException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addToMyAssets";
        this.errorHandler.validateUserId(userId, "addToMyAssets");
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector("addToMyAssets");
    }

    public void removeFromMyAssets(String userId, String assetCollectionGUID, String assetGUID) throws InvalidParameterException, NoProfileForUserException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeFromMyAssets";
        this.errorHandler.validateUserId(userId, "removeFromMyAssets");
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector("removeFromMyAssets");
    }
}

