/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.server;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.AssetConsumerErrorCode;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.NoProfileForUserException;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.PropertyServerException;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.MyProfile;
import org.odpi.openmetadata.accessservices.assetconsumer.server.ErrorHandler;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MyProfileHandler {
    private static final String userIdentityTypeGUID = "fbe95779-1f3c-4ac6-aa9d-24963ff16282";
    private static final String userIdentityTypeName = "UserIdentity";
    private static final String userIdPropertyName = "qualifiedName";
    private static final String userIdentityProfileLinkTypeGUID = "01664609-e777-4079-b543-6baffe910ff1";
    private static final String personalDetailsTypeGUID = "ac406bf8-e53e-49f1-9088-2af28bbbd285";
    private static final String personalDetailsTypeName = "Person";
    private static final String employeeNumberPropertyName = "qualifiedName";
    private static final String fullNamePropertyName = "fullName";
    private static final String knownNamePropertyName = "name";
    private static final String jobTitlePropertyName = "jobTitle";
    private static final String jobDescriptionPropertyName = "description";
    private static final String karmaPointsPropertyName = "karmaPoints";
    private static final String additionalPropertiesName = "additionalProperties";
    private static final String employeeNumberParameterName = "employeeNumber";
    private static final String knownNameParameterName = "knownName";
    private static final Logger log = LoggerFactory.getLogger(MyProfileHandler.class);
    private String serviceName;
    private OMRSRepositoryHelper repositoryHelper = null;
    private OMRSRepositoryValidator repositoryValidator = null;
    private String serverName = null;
    private ErrorHandler errorHandler = null;

    MyProfileHandler(String serviceName, OMRSRepositoryConnector repositoryConnector) {
        this.serviceName = serviceName;
        if (repositoryConnector != null) {
            this.repositoryHelper = repositoryConnector.getRepositoryHelper();
            this.repositoryValidator = repositoryConnector.getRepositoryValidator();
            this.serverName = repositoryConnector.getServerName();
            this.errorHandler = new ErrorHandler(repositoryConnector);
        }
    }

    private InstanceProperties createMyProfileProperties(String methodName, String employeeNumber, String fullName, String knownName, String jobTitle, String jobRoleDescription, int karmaPoints, Map<String, Object> additionalProperties) throws InvalidParameterException {
        this.errorHandler.validateName(employeeNumber, employeeNumberParameterName, methodName);
        this.errorHandler.validateName(knownName, knownNameParameterName, methodName);
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "qualifiedName", employeeNumber, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, fullNamePropertyName, fullName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, knownNamePropertyName, knownName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, jobTitlePropertyName, jobTitle, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, jobDescriptionPropertyName, jobRoleDescription, methodName);
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, karmaPointsPropertyName, karmaPoints, methodName);
        properties = this.repositoryHelper.addMapPropertyToInstance(this.serviceName, properties, additionalPropertiesName, additionalProperties, methodName);
        log.debug("Instance properties: " + properties.toString());
        return properties;
    }

    private MyProfile getMyProfileFromEntity(EntityDetail entity, String methodName) {
        MyProfile myProfile = null;
        if (entity != null) {
            myProfile = new MyProfile();
            myProfile.setGUID(entity.getGUID());
            InstanceType instanceType = entity.getType();
            if (instanceType != null) {
                myProfile.setType(instanceType.getTypeDefName());
            } else {
                myProfile.setType(personalDetailsTypeName);
            }
            InstanceProperties instanceProperties = entity.getProperties();
            if (instanceProperties != null) {
                myProfile.setEmployeeNumber(this.repositoryHelper.getStringProperty(this.serviceName, "qualifiedName", instanceProperties, methodName));
                myProfile.setFullName(this.repositoryHelper.getStringProperty(this.serviceName, fullNamePropertyName, instanceProperties, methodName));
                myProfile.setKnownName(this.repositoryHelper.getStringProperty(this.serviceName, knownNamePropertyName, instanceProperties, methodName));
                myProfile.setJobTitle(this.repositoryHelper.getStringProperty(this.serviceName, jobTitlePropertyName, instanceProperties, methodName));
                myProfile.setJobRoleDescription(this.repositoryHelper.getStringProperty(this.serviceName, jobDescriptionPropertyName, instanceProperties, methodName));
                myProfile.setKarmaPoints(this.repositoryHelper.getIntProperty(this.serviceName, karmaPointsPropertyName, instanceProperties, methodName));
                myProfile.setAdditionalProperties(this.repositoryHelper.getMapFromProperty(this.serviceName, additionalPropertiesName, instanceProperties, methodName));
            }
            log.debug("MyProfile: " + myProfile.toString());
        } else {
            log.debug("MyProfile: <null>");
        }
        return myProfile;
    }

    private void createMyProfile(String userId, String employeeNumber, String fullName, String knownName, String jobTitle, String jobRoleDescription, Map<String, Object> additionalProperties) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "createMyProfile";
        this.errorHandler.validateUserId(userId, "createMyProfile");
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector("createMyProfile");
        InstanceProperties properties = this.createMyProfileProperties("createMyProfile", employeeNumber, fullName, knownName, jobTitle, jobRoleDescription, 0, additionalProperties);
        try {
            EntityDetail personalDetailsEntity = metadataCollection.addEntity(userId, personalDetailsTypeGUID, properties, null, null);
            if (personalDetailsEntity != null) {
                log.debug("New personal details entity: " + personalDetailsEntity.getGUID());
            }
        }
        catch (UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, "createMyProfile", this.serverName, this.serviceName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, "createMyProfile", this.serverName, this.serviceName);
        }
    }

    private void updateMyProfile(String userId, String profileGUID, String employeeNumber, String fullName, String knownName, String jobTitle, String jobRoleDescription, int karmaPoints, Map<String, Object> additionalProperties) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "updateMyProfile";
        this.errorHandler.validateUserId(userId, "updateMyProfile");
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector("updateMyProfile");
        InstanceProperties properties = this.createMyProfileProperties("updateMyProfile", employeeNumber, fullName, knownName, jobTitle, jobRoleDescription, karmaPoints, additionalProperties);
        try {
            metadataCollection.updateEntityProperties(userId, profileGUID, properties);
        }
        catch (UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, "updateMyProfile", this.serverName, this.serviceName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, "updateMyProfile", this.serverName, this.serviceName);
        }
        log.debug("Update of my profile successful: " + profileGUID);
    }

    private String getUserIdentity(String userId, String methodName) throws PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector(methodName);
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "qualifiedName", userId, methodName);
        try {
            List findResults = metadataCollection.findEntitiesByProperty(userId, userIdentityTypeGUID, properties, MatchCriteria.ANY, 0, null, null, null, null, null, 5);
            this.repositoryValidator.validateAtMostOneEntityResult(findResults, userIdentityTypeName, this.serviceName, methodName);
            if (findResults == null) {
                return this.addUserIdentity(userId);
            }
            EntityDetail userIdentityEntity = (EntityDetail)findResults.get(0);
            if (userIdentityEntity != null) {
                log.debug("User Identity entity found for: " + userId);
                return userIdentityEntity.getGUID();
            }
            log.debug("Null User Identity entity found for: " + userId);
            return null;
        }
        catch (UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName, this.serverName, this.serviceName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName, this.serverName, this.serviceName);
        }
        log.debug("Unreachable statement for: " + userId);
        return null;
    }

    private String addUserIdentity(String userId) throws PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "addUserIdentity";
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector("addUserIdentity");
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, "qualifiedName", userId, "addUserIdentity");
        try {
            EntityDetail userIdentity = metadataCollection.addEntity(userId, userIdentityTypeGUID, properties, null, null);
            if (userIdentity != null) {
                return userIdentity.getGUID();
            }
            AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.UNABLE_TO_CREATE_USER_IDENTITY;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{userId});
            throw new PropertyServerException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addUserIdentity", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        catch (UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, "addUserIdentity", this.serverName, this.serviceName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, "addUserIdentity", this.serverName, this.serviceName);
        }
        log.debug("Unreachable statement for: " + userId);
        return null;
    }

    private MyProfile getProfile(String userId, String methodName) throws PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String userIdentityGUID = this.getUserIdentity(userId, methodName);
        if (userIdentityGUID != null) {
            OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector(methodName);
            try {
                List userProfiles = metadataCollection.getRelationshipsForEntity(userId, userIdentityGUID, userIdentityProfileLinkTypeGUID, 0, null, null, null, null, 0);
                this.repositoryValidator.validateAtMostOneRelationshipResult(userProfiles, userIdentityTypeName, this.serviceName, methodName);
                if (userProfiles == null || userProfiles.isEmpty()) {
                    return null;
                }
                return this.getMyProfileByGUID(userId, this.repositoryHelper.getEnd1EntityGUID((Relationship)userProfiles.get(0)), methodName);
            }
            catch (UserNotAuthorizedException error) {
                this.errorHandler.handleUnauthorizedUser(userId, methodName, this.serverName, this.serviceName);
            }
            catch (Throwable error) {
                this.errorHandler.handleRepositoryError(error, methodName, this.serverName, this.serviceName);
            }
        }
        return null;
    }

    private MyProfile getMyProfileByGUID(String userId, String profileGUID, String methodName) throws PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        OMRSMetadataCollection metadataCollection = this.errorHandler.validateRepositoryConnector(methodName);
        try {
            return this.getMyProfileFromEntity(metadataCollection.getEntityDetail(userId, profileGUID), methodName);
        }
        catch (UserNotAuthorizedException error) {
            this.errorHandler.handleUnauthorizedUser(userId, methodName, this.serverName, this.serviceName);
        }
        catch (Throwable error) {
            this.errorHandler.handleRepositoryError(error, methodName, this.serverName, this.serviceName);
        }
        log.debug("Null return from method: " + methodName);
        return null;
    }

    void addKarmaPoint(String userId) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "addKarmaPoint";
        MyProfile profile = this.getProfile(userId, "addKarmaPoint");
        if (profile != null) {
            int karmaPoints = profile.getKarmaPoints();
            profile.setKarmaPoints(++karmaPoints);
            this.updateMyProfile(userId, profile.getGUID(), profile.getEmployeeNumber(), profile.getFullName(), profile.getKnownName(), profile.getJobTitle(), profile.getJobRoleDescription(), profile.getKarmaPoints(), profile.getAdditionalProperties());
        }
    }

    MyProfile getMyProfile(String userId) throws InvalidParameterException, NoProfileForUserException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "getMyProfile";
        this.errorHandler.validateUserId(userId, "getMyProfile");
        MyProfile profile = this.getProfile(userId, "getMyProfile");
        if (profile == null) {
            AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.NO_PROFILE_FOR_USER;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{userId});
            throw new NoProfileForUserException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getMyProfile", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), userId);
        }
        return profile;
    }

    void updateMyProfile(String userId, String employeeNumber, String fullName, String knownName, String jobTitle, String jobRoleDescription, Map<String, Object> additionalProperties) throws InvalidParameterException, PropertyServerException, org.odpi.openmetadata.accessservices.assetconsumer.ffdc.exceptions.UserNotAuthorizedException {
        String methodName = "updateMyProfile";
        this.errorHandler.validateUserId(userId, "updateMyProfile");
        this.errorHandler.validateName(userId, employeeNumberParameterName, "updateMyProfile");
        MyProfile profile = this.getProfile(userId, "updateMyProfile");
        if (profile == null) {
            this.createMyProfile(userId, employeeNumber, fullName, knownName, jobTitle, jobRoleDescription, additionalProperties);
        } else {
            int karmaPoints = profile.getKarmaPoints();
            this.updateMyProfile(userId, profile.getGUID(), employeeNumber, fullName, knownName, jobTitle, jobRoleDescription, ++karmaPoints, additionalProperties);
        }
    }
}

