/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.admin;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.assetconsumer.auditlog.AssetConsumerAuditCode;
import org.odpi.openmetadata.accessservices.assetconsumer.ffdc.AssetConsumerErrorCode;
import org.odpi.openmetadata.accessservices.assetconsumer.listener.AssetConsumerOMRSTopicListener;
import org.odpi.openmetadata.accessservices.assetconsumer.server.AssetConsumerServicesInstance;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceAdmin;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class AssetConsumerAdmin
implements AccessServiceAdmin {
    private OMRSAuditLog auditLog = null;
    private AssetConsumerServicesInstance instance = null;
    private String serverName = null;

    public void initialize(AccessServiceConfig accessServiceConfig, OMRSTopicConnector omrsTopicConnector, OMRSRepositoryConnector repositoryConnector, OMRSAuditLog auditLog, String serverUserName) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        AssetConsumerAuditCode auditCode = AssetConsumerAuditCode.SERVICE_INITIALIZING;
        auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
        try {
            this.auditLog = auditLog;
            List<String> supportedZones = this.extractSupportedZones(accessServiceConfig.getAccessServiceOptions());
            this.instance = new AssetConsumerServicesInstance(repositoryConnector, supportedZones, auditLog);
            this.serverName = this.instance.getServerName();
            if (omrsTopicConnector != null && accessServiceConfig.getAccessServiceOutTopic() != null) {
                auditCode = AssetConsumerAuditCode.SERVICE_REGISTERED_WITH_ENTERPRISE_TOPIC;
                auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.serverName), null, auditCode.getSystemAction(), auditCode.getUserAction());
                AssetConsumerOMRSTopicListener omrsTopicListener = new AssetConsumerOMRSTopicListener(accessServiceConfig.getAccessServiceOutTopic(), repositoryConnector.getRepositoryHelper(), repositoryConnector.getRepositoryValidator(), accessServiceConfig.getAccessServiceName(), supportedZones, auditLog);
                omrsTopicConnector.registerListener((OMRSTopicListener)omrsTopicListener);
            }
            auditCode = AssetConsumerAuditCode.SERVICE_INITIALIZED;
            auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.serverName), null, auditCode.getSystemAction(), auditCode.getUserAction());
        }
        catch (OMAGConfigurationErrorException error) {
            throw error;
        }
        catch (Throwable error) {
            auditCode = AssetConsumerAuditCode.SERVICE_INSTANCE_FAILURE;
            auditLog.logRecord("initialize", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(error.getMessage()), null, auditCode.getSystemAction(), auditCode.getUserAction());
        }
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        if (this.instance != null) {
            this.instance.shutdown();
        }
        AssetConsumerAuditCode auditCode = AssetConsumerAuditCode.SERVICE_SHUTDOWN;
        this.auditLog.logRecord("shutdown", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(this.serverName), null, auditCode.getSystemAction(), auditCode.getUserAction());
    }

    private List<String> extractSupportedZones(Map<String, Object> accessServiceOptions) throws OMAGConfigurationErrorException {
        String methodName = "extractSupportedZones";
        if (accessServiceOptions == null) {
            return null;
        }
        Object zoneListObject = accessServiceOptions.get("SupportedZones");
        if (zoneListObject == null) {
            AssetConsumerAuditCode auditCode = AssetConsumerAuditCode.ALL_ZONES;
            this.auditLog.logRecord("extractSupportedZones", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
            return null;
        }
        try {
            List zoneList = (List)zoneListObject;
            AssetConsumerAuditCode auditCode = AssetConsumerAuditCode.SUPPORTED_ZONES;
            this.auditLog.logRecord("extractSupportedZones", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(zoneList.toString()), null, auditCode.getSystemAction(), auditCode.getUserAction());
            return zoneList;
        }
        catch (Throwable error) {
            AssetConsumerAuditCode auditCode = AssetConsumerAuditCode.BAD_CONFIG;
            this.auditLog.logRecord("extractSupportedZones", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(zoneListObject.toString(), "SupportedZones"), null, auditCode.getSystemAction(), auditCode.getUserAction());
            AssetConsumerErrorCode errorCode = AssetConsumerErrorCode.BAD_CONFIG;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{zoneListObject.toString(), "SupportedZones", error.getClass().getName(), error.getMessage()});
            throw new OMAGConfigurationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "extractSupportedZones", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }
}

