/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.converters;

import org.odpi.openmetadata.accessservices.assetconsumer.converters.ReferenceableHeaderConverter;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.Asset;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.ReferenceableHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class AssetConverter
extends ReferenceableHeaderConverter {
    public static final String DISPLAY_NAME_PROPERTY_NAME = "name";
    private static final String ownerPropertyName = "owner";
    private static final String descriptionPropertyName = "description";
    private static final String zoneMembershipPropertyName = "zoneMembership";
    private static final String latestChangePropertyName = "latestChange";
    private Asset assetBean = null;

    public AssetConverter(EntityDetail entity, OMRSRepositoryHelper repositoryHelper, String componentName) {
        super(entity, repositoryHelper, componentName);
        if (entity != null) {
            this.assetBean = new Asset();
            super.setBean((ReferenceableHeader)this.assetBean);
            this.updateAssetBean(entity, repositoryHelper, componentName);
        }
    }

    private void updateAssetBean(EntityDetail entity, OMRSRepositoryHelper repositoryHelper, String componentName) {
        String methodName = "updateAssetBean";
        if (entity != null) {
            InstanceProperties instanceProperties = entity.getProperties();
            this.assetBean.setDisplayName(repositoryHelper.getStringProperty(componentName, DISPLAY_NAME_PROPERTY_NAME, instanceProperties, "updateAssetBean"));
            this.assetBean.setOwner(repositoryHelper.getStringProperty(componentName, ownerPropertyName, instanceProperties, "updateAssetBean"));
            this.assetBean.setDescription(repositoryHelper.getStringProperty(componentName, descriptionPropertyName, instanceProperties, "updateAssetBean"));
            this.assetBean.setZoneMembership(repositoryHelper.getStringArrayProperty(componentName, zoneMembershipPropertyName, instanceProperties, "updateAssetBean"));
            this.assetBean.setLastChange(repositoryHelper.getStringProperty(componentName, latestChangePropertyName, instanceProperties, "updateAssetBean"));
        }
    }

    public Asset getBean() {
        return this.assetBean;
    }
}

