/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.assetconsumer.converters;

import org.odpi.openmetadata.accessservices.assetconsumer.converters.ReferenceableHeaderConverter;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.GlossaryTerm;
import org.odpi.openmetadata.accessservices.assetconsumer.properties.ReferenceableHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GlossaryTermConverter
extends ReferenceableHeaderConverter {
    public static final String DISPLAY_NAME_PROPERTY_NAME = "displayName";
    private static final String summaryPropertyName = "summary";
    private static final String descriptionPropertyName = "description";
    private static final String examplesPropertyName = "usage";
    private static final String abbreviationPropertyName = "abbreviation";
    private static final String usagePropertyName = "usage";
    private GlossaryTerm glossaryTermBean = null;

    public GlossaryTermConverter(EntityDetail entity, OMRSRepositoryHelper repositoryHelper, String componentName) {
        super(entity, repositoryHelper, componentName);
        if (entity != null) {
            this.glossaryTermBean = new GlossaryTerm();
            super.setBean((ReferenceableHeader)this.glossaryTermBean);
            this.updateGlossaryTermBean(entity, repositoryHelper, componentName);
        }
    }

    private void updateGlossaryTermBean(EntityDetail entity, OMRSRepositoryHelper repositoryHelper, String componentName) {
        String methodName = "updateGlossaryTermBean";
        if (entity != null) {
            InstanceProperties instanceProperties = entity.getProperties();
            this.glossaryTermBean.setDisplayName(repositoryHelper.getStringProperty(componentName, DISPLAY_NAME_PROPERTY_NAME, instanceProperties, "updateGlossaryTermBean"));
            this.glossaryTermBean.setSummary(repositoryHelper.getStringProperty(componentName, summaryPropertyName, instanceProperties, "updateGlossaryTermBean"));
            this.glossaryTermBean.setDescription(repositoryHelper.getStringProperty(componentName, descriptionPropertyName, instanceProperties, "updateGlossaryTermBean"));
            this.glossaryTermBean.setUsage(repositoryHelper.getStringProperty(componentName, "usage", instanceProperties, "updateGlossaryTermBean"));
            this.glossaryTermBean.setAbbreviation(repositoryHelper.getStringProperty(componentName, abbreviationPropertyName, instanceProperties, "updateGlossaryTermBean"));
            this.glossaryTermBean.setExamples(repositoryHelper.getStringProperty(componentName, "usage", instanceProperties, "updateGlossaryTermBean"));
        }
    }

    public GlossaryTerm getBean() {
        return this.glossaryTermBean;
    }
}

